/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.client.renderer.tile;

import com.kentington.thaumichorizons.common.tiles.TileSyntheticNode;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.renderers.models.ModelCrystal;

public class TileEtherealShardRender
extends TileEntitySpecialRenderer {
    private final ModelCrystal model = new ModelCrystal();
    static String tx1 = "textures/items/lightningringv.png";
    static String tx2 = "textures/misc/nodes.png";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        TileSyntheticNode tco = (TileSyntheticNode)te;
        long red = 255L;
        long green = 255L;
        long blue = 255L;
        long numPoints = 0L;
        long numPointsFilled = 0L;
        if (tco != null && tco.getAspectsBase() != null && tco.getAspects() != null && tco.getAspects().size() > 0 && tco.getAspectsBase().size() > 0) {
            for (Aspect asp : tco.getAspectsBase().getAspects()) {
                long amt = tco.getAspectsBase().getAmount(asp);
                Color col = new Color(asp.getColor());
                red += (long)col.getRed() * amt;
                green += (long)col.getGreen() * amt;
                blue += (long)col.getBlue() * amt;
                numPoints += amt;
                numPointsFilled += (long)tco.getAspects().getAmount(asp);
            }
            red /= numPoints + 1L;
            green /= numPoints + 1L;
            blue /= numPoints + 1L;
            red = Math.min(255L, Math.max(red, 0L));
            green = Math.min(255L, Math.max(green, 0L));
            blue = Math.min(255L, Math.max(blue, 0L));
        }
        try {
            Color col2 = new Color((int)red, (int)green, (int)blue);
            UtilsFX.bindTexture((String)"textures/models/crystal.png");
            Random rand = new Random((long)(tco.getBlockMetadata() + tco.xCoord) + (long)tco.yCoord * (long)tco.zCoord);
            this.drawCrystal(0, (float)x, (float)y, (float)z, tco.rotation, 0.0f, rand, col2.getRGB(), 1.1f);
            long nt = System.nanoTime();
            UtilsFX.bindTexture((String)tx2);
            int frames = 32;
            int i = (int)(((double)(nt / 40000000L) + x) % 32.0);
            if (tco != null && tco.getAspectsBase() != null && tco.getAspects() != null && tco.getAspectsBase().size() > 0 && tco.getAspects().getAspects()[0] != null && tco.getAspectsBase().getAspects()[0] != null) {
                double offset = Math.PI * 2 / (double)tco.getAspectsBase().size();
                int which = 0;
                GL11.glAlphaFunc((int)516, (float)0.003921569f);
                GL11.glDepthMask((boolean)false);
                for (Aspect asp2 : tco.getAspectsBase().getAspects()) {
                    if (asp2 == null) break;
                    Color colo = new Color(asp2.getColor());
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    double radian = Math.toRadians(tco.rotation);
                    double dist = 0.4 + 0.1 * Math.cos(radian);
                    UtilsFX.renderFacingStrip((double)((double)tco.xCoord + 0.5 + dist * Math.sin(2.0 * radian + offset * (double)which)), (double)((double)tco.yCoord + 0.64 + (double)0.1f * Math.sin(Math.toRadians(tco.rotation))), (double)((double)tco.zCoord + 0.5 + dist * Math.cos(2.0 * radian + offset * (double)which)), (float)0.0f, (float)(0.1f + 0.005f * (float)tco.getAspects().getAmount(asp2)), (float)0.9f, (int)32, (int)1, (int)((int)tco.rotation % 32), (float)f, (int)colo.getRGB());
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                    ++which;
                }
                GL11.glDepthMask((boolean)true);
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
            if (tco != null && tco.drainEntity != null && tco.drainCollision != null) {
                Entity drainEntity = tco.drainEntity;
                if (drainEntity instanceof EntityPlayer && !((EntityPlayer)drainEntity).isUsingItem()) {
                    tco.drainEntity = null;
                    tco.drainCollision = null;
                    return;
                }
                MovingObjectPosition drainCollision = tco.drainCollision;
                GL11.glPushMatrix();
                float f2 = 0.0f;
                int iiud = ((EntityPlayer)drainEntity).getItemInUseDuration();
                if (drainEntity instanceof EntityPlayer) {
                    f2 = MathHelper.sin((float)((float)iiud / 10.0f)) * 10.0f;
                }
                Vec3 vec3 = Vec3.createVectorHelper((double)-0.1, (double)-0.1, (double)0.5);
                vec3.rotateAroundX(-(drainEntity.prevRotationPitch + (drainEntity.rotationPitch - drainEntity.prevRotationPitch) * f) * (float)Math.PI / 180.0f);
                vec3.rotateAroundY(-(drainEntity.prevRotationYaw + (drainEntity.rotationYaw - drainEntity.prevRotationYaw) * f) * (float)Math.PI / 180.0f);
                vec3.rotateAroundY(-f2 * 0.01f);
                vec3.rotateAroundX(-f2 * 0.015f);
                double d3 = drainEntity.prevPosX + (drainEntity.posX - drainEntity.prevPosX) * (double)f + vec3.xCoord;
                double d4 = drainEntity.prevPosY + (drainEntity.posY - drainEntity.prevPosY) * (double)f + vec3.yCoord;
                double d5 = drainEntity.prevPosZ + (drainEntity.posZ - drainEntity.prevPosZ) * (double)f + vec3.zCoord;
                double d6 = drainEntity == Minecraft.getMinecraft().thePlayer ? 0.0 : (double)drainEntity.getEyeHeight();
                UtilsFX.drawFloatyLine((double)d3, (double)(d4 + d6), (double)d5, (double)((double)drainCollision.blockX + 0.5), (double)((double)drainCollision.blockY + 0.5), (double)((double)drainCollision.blockZ + 0.5), (float)f, (int)tco.color.getRGB(), (String)"textures/misc/wispy.png", (float)-0.02f, (float)((float)Math.min(iiud, 10) / 10.0f));
                GL11.glPopMatrix();
            }
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            GL11.glPopMatrix();
        }
    }

    private void drawCrystal(int ori, float x, float y, float z, float a1, float a2, Random rand, int color, float size) {
        EntityClientPlayerMP p = Minecraft.getMinecraft().thePlayer;
        float shade = MathHelper.sin((float)((float)(p.ticksExisted + rand.nextInt(10)) / (5.0f + rand.nextFloat()))) * 0.075f + 0.925f;
        Color c = new Color(color);
        float r = (float)c.getRed() / 220.0f;
        float g = (float)c.getGreen() / 220.0f;
        float b = (float)c.getBlue() / 220.0f;
        GL11.glPushMatrix();
        GL11.glEnable((int)2977);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)(x + 0.5f), (float)((float)((double)(y - 0.15f) + (double)0.1f * Math.sin(Math.toRadians(a1)))), (float)(z + 0.5f));
        GL11.glRotatef((float)a1, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)a2, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)((0.15f + rand.nextFloat() * 0.075f) * size), (float)((0.5f + rand.nextFloat() * 0.1f) * size), (float)((0.15f + rand.nextFloat() * 0.05f) * size));
        int var19 = (int)(210.0f * shade);
        int var20 = var19 % 65536;
        int var21 = var19 / 65536;
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)var20, (float)var21);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        this.model.render();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

