/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.blocks;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.lib.GatewayTeleporter;
import com.kentington.thaumichorizons.common.lib.PocketPlaneData;
import com.kentington.thaumichorizons.common.tiles.TileSlot;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.BlockBreakable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;

public class BlockPortalTH
extends BlockBreakable {
    public BlockPortalTH() {
        super("portal", ThaumicHorizons.portal, false);
        this.setTickRandomly(true);
        this.setBlockUnbreakable();
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return null;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderBlockPass() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World p_149734_1_, int p_149734_2_, int p_149734_3_, int p_149734_4_, Random p_149734_5_) {
        for (int l = 0; l < 4; ++l) {
            double d0 = (float)p_149734_2_ + p_149734_5_.nextFloat();
            double d2 = (float)p_149734_3_ + p_149734_5_.nextFloat();
            double d3 = (float)p_149734_4_ + p_149734_5_.nextFloat();
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            int i1 = p_149734_5_.nextInt(2) * 2 - 1;
            d4 = ((double)p_149734_5_.nextFloat() - 0.5) * 0.5;
            d5 = ((double)p_149734_5_.nextFloat() - 0.5) * 0.5;
            d6 = ((double)p_149734_5_.nextFloat() - 0.5) * 0.5;
            if (p_149734_1_.getBlock(p_149734_2_ - 1, p_149734_3_, p_149734_4_) != this && p_149734_1_.getBlock(p_149734_2_ + 1, p_149734_3_, p_149734_4_) != this) {
                d0 = (double)p_149734_2_ + 0.5 + 0.25 * (double)i1;
                d4 = p_149734_5_.nextFloat() * 2.0f * (float)i1;
            } else {
                d3 = (double)p_149734_4_ + 0.5 + 0.25 * (double)i1;
                d6 = p_149734_5_.nextFloat() * 2.0f * (float)i1;
            }
            p_149734_1_.spawnParticle("portal", d0, d2, d3, d4, d5, d6);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item getItem(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return null;
    }

    public int quantityDropped(Random p_149745_1_) {
        return 0;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity player) {
        if (player.ridingEntity == null && player.riddenByEntity == null && player instanceof EntityPlayerMP) {
            if (player.timeUntilPortal > 0) {
                player.timeUntilPortal = 10;
                return;
            }
            player.timeUntilPortal = 10;
            int targetX = 0;
            int targetY = 0;
            int targetZ = 0;
            int targetDim = 0;
            if (world.provider.dimensionId == ThaumicHorizons.dimensionPocketId) {
                int[] portal;
                int planeNum = (z + 128) / 256;
                int which = world.getBlockMetadata(x, y, z);
                PocketPlaneData plane = PocketPlaneData.planes.get(planeNum);
                switch (which) {
                    case 0: {
                        portal = plane.portalA;
                        break;
                    }
                    case 1: {
                        portal = plane.portalC;
                        break;
                    }
                    case 2: {
                        portal = plane.portalB;
                        break;
                    }
                    case 3: {
                        portal = plane.portalD;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                targetX = portal[0];
                targetY = portal[1] - 2;
                targetZ = portal[2];
                if (portal.length > 3) {
                    targetDim = portal[3];
                }
                MinecraftServer mServer = FMLCommonHandler.instance().getMinecraftServerInstance();
                ((EntityPlayerMP)player).mcServer.getConfigurationManager().transferPlayerToDimension((EntityPlayerMP)player, targetDim, (Teleporter)new GatewayTeleporter(mServer.worldServerForDimension(ThaumicHorizons.dimensionPocketId), targetX, targetY, targetZ, player.rotationYaw));
            } else {
                TileEntity te;
                int slotY = y;
                int slotX = x;
                int slotZ = z;
                while (world.getBlock(slotX, ++slotY, slotZ) == ThaumicHorizons.blockPortal) {
                }
                if (world.getBlock(slotX, slotY, slotZ) == ThaumicHorizons.blockGateway) {
                    if (world.getBlock(slotX + 1, slotY, slotZ) == ThaumicHorizons.blockSlot) {
                        ++slotX;
                    } else if (world.getBlock(slotX - 1, slotY, slotZ) == ThaumicHorizons.blockSlot) {
                        --slotX;
                    } else if (world.getBlock(slotX, slotY, slotZ + 1) == ThaumicHorizons.blockSlot) {
                        ++slotZ;
                    } else if (world.getBlock(slotX, slotY, slotZ - 1) == ThaumicHorizons.blockSlot) {
                        --slotZ;
                    }
                }
                if ((te = world.getTileEntity(slotX, slotY, slotZ)) instanceof TileSlot) {
                    TileSlot tco = (TileSlot)te;
                    targetY = 128;
                    float targetYaw = 0.0f;
                    switch (tco.which) {
                        case 1: {
                            targetZ = tco.pocketID * 256 + PocketPlaneData.planes.get((int)tco.pocketID).radius;
                            targetYaw = 180.0f;
                            break;
                        }
                        case 2: {
                            targetZ = tco.pocketID * 256 - PocketPlaneData.planes.get((int)tco.pocketID).radius;
                            break;
                        }
                        case 3: {
                            targetZ = tco.pocketID * 256;
                            targetX = PocketPlaneData.planes.get((int)tco.pocketID).radius;
                            targetYaw = 90.0f;
                            break;
                        }
                        case 4: {
                            targetZ = tco.pocketID * 256;
                            targetX = -PocketPlaneData.planes.get((int)tco.pocketID).radius;
                            targetYaw = 270.0f;
                        }
                    }
                    MinecraftServer mServer2 = FMLCommonHandler.instance().getMinecraftServerInstance();
                    ((EntityPlayerMP)player).mcServer.getConfigurationManager().transferPlayerToDimension((EntityPlayerMP)player, ThaumicHorizons.dimensionPocketId, (Teleporter)new GatewayTeleporter(mServer2.worldServerForDimension(ThaumicHorizons.dimensionPocketId), targetX, targetY, targetZ, targetYaw));
                }
            }
        }
    }
}

