/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.entities;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntityGolemTH;
import com.kentington.thaumichorizons.common.items.ItemFocusAnimation;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityLightningBoltFinite
extends EntityLightningBolt {
    public int boltLength;
    public boolean animate;

    public EntityLightningBoltFinite(World p_i1703_1_, double p_i1703_2_, double p_i1703_4_, double p_i1703_6_, int boltLength, boolean animate) {
        super(p_i1703_1_, p_i1703_2_, p_i1703_4_, p_i1703_6_);
        this.boltLength = boltLength;
        this.animate = animate;
    }

    public EntityLightningBoltFinite(World w) {
        super(w, 0.0, 0.0, 0.0);
    }

    protected void readEntityFromNBT(NBTTagCompound tag) {
        super.readEntityFromNBT(tag);
        this.boltLength = tag.getInteger("length");
        this.animate = tag.getBoolean("animate");
    }

    protected void writeEntityToNBT(NBTTagCompound tag) {
        super.writeEntityToNBT(tag);
        tag.setBoolean("animate", this.animate);
        tag.setInteger("length", this.boltLength);
    }

    public void onUpdate() {
        super.onUpdate();
        ThaumicHorizons.proxy.lightningBolt(this.worldObj, this.posX, this.posY, this.posZ, this.boltLength);
        if (!this.animate) {
            return;
        }
        int p_77648_4_ = (int)Math.floor(this.posX);
        int p_77648_5_ = (int)this.posY;
        int p_77648_6_ = (int)Math.floor(this.posZ);
        Block blocky = this.worldObj.getBlock(p_77648_4_, p_77648_5_, p_77648_6_);
        int md = this.worldObj.getBlockMetadata(p_77648_4_, p_77648_5_, p_77648_6_);
        if (this.worldObj.isRemote) {
            return;
        }
        if (!blocky.hasTileEntity(md) && !blocky.isAir((IBlockAccess)this.worldObj, p_77648_4_, p_77648_5_, p_77648_6_) && (blocky.isOpaqueCube() || ItemFocusAnimation.isWhitelisted(blocky, md)) && blocky.getBlockHardness(this.worldObj, p_77648_4_, p_77648_5_, p_77648_6_) != -1.0f) {
            if (!this.worldObj.isRemote && ThaumicHorizons.blockCloud.getBlockHardness(this.worldObj, p_77648_4_, p_77648_5_, p_77648_6_) > 0.0f) {
                EntityGolemTH golem = new EntityGolemTH(this.worldObj);
                golem.loadGolem((double)p_77648_4_ + 0.5, p_77648_5_, (double)p_77648_6_ + 0.5, blocky, md, 1200, false, false, false);
                this.worldObj.setBlockToAir(p_77648_4_, p_77648_5_, p_77648_6_);
                this.worldObj.playSoundEffect((double)p_77648_4_ + 0.5, (double)p_77648_5_ + 0.5, (double)p_77648_6_ + 0.5, "thaumcraft:wand", 1.0f, 1.0f);
                golem.setHomeArea((int)golem.posX, (int)golem.posY, (int)golem.posZ, 32);
                golem.setOwner("");
                golem.berserk = true;
                golem.extinguish();
                golem.heal(100.0f);
                this.worldObj.spawnEntityInWorld((Entity)golem);
                this.worldObj.setEntityState((Entity)golem, (byte)7);
            } else {
                Minecraft.getMinecraft().effectRenderer.addBlockDestroyEffects(p_77648_4_, p_77648_5_, p_77648_6_, blocky, md);
            }
        }
    }
}

