/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.entities.ai;

import com.kentington.thaumichorizons.common.entities.EntityOrePig;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class EntityAIEatStone
extends EntityAIBase {
    private final EntityOrePig thePig;
    private Entity targetEntity;
    int count = 0;

    public EntityAIEatStone(EntityOrePig par1EntityCreature) {
        this.thePig = par1EntityCreature;
    }

    public boolean shouldExecute() {
        return this.findItem();
    }

    private boolean findItem() {
        float dmod = 16.0f;
        double mindis_e = 128.0;
        List targets = this.thePig.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this.thePig, AxisAlignedBB.getBoundingBox((double)(this.thePig.posX - 16.0), (double)(this.thePig.posY - 16.0), (double)(this.thePig.posZ - 16.0), (double)(this.thePig.posX + 16.0), (double)(this.thePig.posY + 16.0), (double)(this.thePig.posZ + 16.0)));
        if (targets.size() == 0) {
            return false;
        }
        for (Entity e : targets) {
            double distance2;
            if (!(e instanceof EntityItem) || ((EntityItem)e).getEntityItem().getItem() != Item.getItemFromBlock((Block)Blocks.cobblestone) || ((EntityItem)e).delayBeforeCanPickup >= 5 || (distance2 = e.getDistanceSq(this.thePig.posX, this.thePig.posY, this.thePig.posZ)) >= 256.0 || mindis_e < distance2) continue;
            mindis_e = distance2;
            this.targetEntity = e;
        }
        return this.targetEntity != null;
    }

    public boolean continueExecuting() {
        return this.count-- > 0 && !this.thePig.getNavigator().noPath() && this.targetEntity.isEntityAlive();
    }

    public void resetTask() {
        this.count = 0;
        this.targetEntity = null;
        this.thePig.getNavigator().clearPathEntity();
    }

    public void updateTask() {
        this.thePig.getLookHelper().setLookPositionWithEntity(this.targetEntity, 30.0f, 30.0f);
        double dist = this.thePig.getDistanceSqToEntity(this.targetEntity);
        if (dist <= 2.0) {
            this.pickUp();
        }
    }

    private void pickUp() {
        boolean amount = false;
        if (this.targetEntity instanceof EntityItem) {
            this.thePig.eatStone();
            ItemStack entityItem = ((EntityItem)this.targetEntity).getEntityItem();
            --entityItem.stackSize;
            if (((EntityItem)this.targetEntity).getEntityItem().stackSize <= 0) {
                this.targetEntity.setDead();
            }
        }
        this.targetEntity.worldObj.playSoundAtEntity(this.targetEntity, "random.burp", 0.2f, ((this.targetEntity.worldObj.rand.nextFloat() - this.targetEntity.worldObj.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
    }

    public void startExecuting() {
        this.count = 500;
        this.thePig.getNavigator().tryMoveToEntityLiving(this.targetEntity, (double)(this.thePig.getAIMoveSpeed() + 1.0f));
    }
}

