/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.kentington.thaumichorizons.common.ThaumicHorizons;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.api.IRunicArmor;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileMirror;

public class ItemAmuletMirror
extends Item
implements IBauble,
IRunicArmor {
    public IIcon icon;

    public ItemAmuletMirror() {
        this.maxStackSize = 1;
        this.canRepair = false;
        this.setMaxDamage(0);
        this.setCreativeTab(ThaumicHorizons.tabTH);
        this.setHasSubtypes(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumichorizons:amuletmirror");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return "item.amuletMirror";
    }

    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    public int getRunicCharge(ItemStack itemstack) {
        return 0;
    }

    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    public void onEquipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    public void onUnequipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    public void onWornTick(ItemStack arg0, EntityLivingBase arg1) {
    }

    public boolean getShareTag() {
        return true;
    }

    public boolean hasEffect(ItemStack par1ItemStack) {
        return par1ItemStack.hasTagCompound();
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        Block bi = world.getBlock(x, y, z);
        if (bi != ConfigBlocks.blockMirror) {
            return false;
        }
        if (world.isRemote) {
            player.swingItem();
            return super.onItemUseFirst(itemstack, player, world, x, y, z, par7, par8, par9, par10);
        }
        TileEntity tm = world.getTileEntity(x, y, z);
        if (tm instanceof TileMirror) {
            itemstack.setTagInfo("linkX", (NBTBase)new NBTTagInt(tm.xCoord));
            itemstack.setTagInfo("linkY", (NBTBase)new NBTTagInt(tm.yCoord));
            itemstack.setTagInfo("linkZ", (NBTBase)new NBTTagInt(tm.zCoord));
            itemstack.setTagInfo("linkDim", (NBTBase)new NBTTagInt(world.provider.dimensionId));
            itemstack.setTagInfo("dimname", (NBTBase)new NBTTagString(DimensionManager.getProvider((int)world.provider.dimensionId).getDimensionName()));
            world.playSoundEffect((double)x, (double)y, (double)z, "thaumcraft:jar", 1.0f, 2.0f);
            player.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.GRAY + StatCollector.translateToLocal((String)"tc.handmirrorlinked")));
            player.inventoryContainer.detectAndSendChanges();
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack item, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (item.hasTagCompound()) {
            int lx = item.stackTagCompound.getInteger("linkX");
            int ly = item.stackTagCompound.getInteger("linkY");
            int lz = item.stackTagCompound.getInteger("linkZ");
            int ldim = item.stackTagCompound.getInteger("linkDim");
            String dimname = item.stackTagCompound.getString("dimname");
            list.add(StatCollector.translateToLocal((String)"tc.handmirrorlinkedto") + " " + lx + "," + ly + "," + lz + " in " + dimname);
        }
    }
}

