/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntitySoul;
import com.kentington.thaumichorizons.common.lib.networking.PacketFXContainment;
import com.kentington.thaumichorizons.common.lib.networking.PacketHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.InventoryUtils;

public class ItemFocusContainment
extends ItemFocusBasic {
    public static FocusUpgradeType slow = new FocusUpgradeType(FocusUpgradeType.types.length, new ResourceLocation("thaumichorizons", "textures/foci/slow.png"), "focus.upgrade.slow.name", "focus.upgrade.slow.text", new AspectList().add(Aspect.TRAP, 8));
    public static HashMap<String, Object> beam = new HashMap();
    public static HashMap<String, Entity> hitCritters = new HashMap();
    public static HashMap<String, Float> contain = new HashMap();
    public static HashMap<String, Long> soundDelay = new HashMap();
    IIcon depthIcon = null;
    private static final AspectList cost = new AspectList().add(Aspect.AIR, 10).add(Aspect.ENTROPY, 10);

    public ItemFocusContainment() {
        this.setCreativeTab(ThaumicHorizons.tabTH);
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return StatCollector.translateToLocal((String)"item.focusContainment.name");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.depthIcon = ir.registerIcon("thaumichorizons:focus_containment_depth");
        this.icon = ir.registerIcon("thaumichorizons:focus_containment");
    }

    public IIcon getFocusDepthLayerIcon(ItemStack itemstack) {
        return this.depthIcon;
    }

    public int getFocusColor(ItemStack itemstack) {
        return 29631;
    }

    public String getSortingHelper(ItemStack itemstack) {
        return "CN" + super.getSortingHelper(itemstack);
    }

    public AspectList getVisCost(ItemStack focusstack) {
        return cost.copy();
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        switch (rank) {
            case 1: 
            case 3: 
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 2: 
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, slow};
            }
        }
        return null;
    }

    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer p, MovingObjectPosition movingobjectposition) {
        ItemWandCasting wand = (ItemWandCasting)itemstack.getItem();
        p.setItemInUse(itemstack, Integer.MAX_VALUE);
        return itemstack;
    }

    public void onUsingFocusTick(ItemStack stack, EntityPlayer p, int count) {
        ItemWandCasting wand = (ItemWandCasting)stack.getItem();
        if (!this.canJarEntity(p)) {
            if (p.ticksExisted % 5 == 0) {
                p.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GRAY + StatCollector.translateToLocal((String)"thaumichorizons.noJar")));
            }
            p.stopUsingItem();
            return;
        }
        if (!wand.consumeAllVis(stack, p, this.getVisCost(stack), false, false)) {
            p.stopUsingItem();
            return;
        }
        String pp = "R" + p.getDisplayName();
        Entity ent = ItemFocusContainment.getPointedEntity(p.worldObj, (EntityLivingBase)p, 10.0);
        MovingObjectPosition mop = BlockUtils.getTargetBlock((World)p.worldObj, (Entity)p, (boolean)true);
        Vec3 v = p.getLookVec();
        double tx = p.posX + v.xCoord * 10.0;
        double ty = p.posY + v.yCoord * 10.0;
        double tz = p.posZ + v.zCoord * 10.0;
        int impact = 0;
        if (ent instanceof EntityLiving) {
            tx = ent.posX;
            ty = ent.posY + (ent.boundingBox.maxY - ent.boundingBox.minY) / 2.0;
            tz = ent.posZ;
            impact = 5;
            if (!(p == null || p.worldObj == null || p.worldObj.isRemote || soundDelay.get(pp) != null && soundDelay.get(pp) >= System.currentTimeMillis())) {
                ent.worldObj.playSoundEffect(tx, ty, tz, "thaumcraft:jacobs", 0.3f, 1.0f);
                soundDelay.put(pp, System.currentTimeMillis() + 1200L);
            }
        } else if (mop != null) {
            tx = mop.hitVec.xCoord;
            ty = mop.hitVec.yCoord;
            tz = mop.hitVec.zCoord;
            impact = 5;
        } else {
            soundDelay.put(pp, 0L);
        }
        if (p.worldObj.isRemote) {
            beam.put(pp, Thaumcraft.proxy.beamCont(p.worldObj, p, tx, ty, tz, 2, 0x4466FF, true, impact > 0 ? 2.0f : 0.0f, beam.get(pp), impact));
        }
        if (ent != null && ent instanceof EntityLiving && !(ent instanceof EntityPlayer) && !ent.isDead && !(ent instanceof IBossDisplayData) && !(ent instanceof EntityGolemBase) && wand.consumeAllVis(stack, p, this.getVisCost(stack), true, false)) {
            if (this.getUpgradeLevel(wand.getFocusItem(stack), slow) > 0) {
                ((EntityLiving)ent).addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 40, this.getUpgradeLevel(wand.getFocusItem(stack), slow) - 1));
            }
            if (hitCritters.get(pp) == null || ent.getEntityId() != hitCritters.get(pp).getEntityId()) {
                hitCritters.put(pp, ent);
                contain.put(pp, Float.valueOf(2.0f + (float)wand.getFocusPotency(stack) / 2.0f));
            } else {
                contain.put(pp, Float.valueOf(contain.get(pp).floatValue() + 2.0f + (float)(wand.getFocusPotency(stack) / 3)));
            }
            if (!p.worldObj.isRemote && contain.get(pp).floatValue() > ((EntityLiving)ent).getHealth() * 20.0f && !(ent instanceof EntitySoul)) {
                NBTTagCompound entityData = new NBTTagCompound();
                entityData.setString("id", EntityList.getEntityString((Entity)ent));
                ent.writeToNBT(entityData);
                this.jarEntity(p, entityData, ent.getCommandSenderName(), ent.posX, ent.posY + (double)(ent.height / 2.0f), ent.posZ);
                p.worldObj.playSoundEffect(ent.posX, ent.posY + (ent.boundingBox.maxY - ent.boundingBox.minY) / 2.0, ent.posZ, "thaumcraft:craftfail", 1.0f, 1.0f);
                contain.remove(pp);
                hitCritters.remove(pp);
                p.worldObj.removeEntity(ent);
            } else if (!p.worldObj.isRemote && contain.get(pp).floatValue() > ((EntityLiving)ent).getHealth() * 20.0f) {
                p.worldObj.playSoundEffect(ent.posX, ent.posY + (ent.boundingBox.maxY - ent.boundingBox.minY) / 2.0, ent.posZ, "thaumcraft:craftfail", 1.0f, 1.0f);
                p.inventory.decrStackSize(InventoryUtils.isPlayerCarrying((EntityPlayer)p, (ItemStack)new ItemStack(ConfigBlocks.blockJar, 1, 0)), 1);
                ItemStack jar = new ItemStack(ThaumicHorizons.blockJar);
                jar.setTagCompound(new NBTTagCompound());
                jar.getTagCompound().setBoolean("isSoul", true);
                if (!p.inventory.addItemStackToInventory(jar)) {
                    p.entityDropItem(jar, 1.0f);
                }
                if (!p.worldObj.isRemote) {
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXContainment(ent.posX, ent.posY, ent.posZ), new NetworkRegistry.TargetPoint(p.worldObj.provider.dimensionId, ent.posX, ent.posY, ent.posZ, 32.0));
                }
                contain.remove(pp);
                hitCritters.remove(pp);
                p.worldObj.removeEntity(ent);
            }
        }
    }

    public static Entity getPointedEntity(World world, EntityLivingBase entityplayer, double range) {
        Entity pointedEntity = null;
        Vec3 vec3d = Vec3.createVectorHelper((double)entityplayer.posX, (double)(entityplayer.posY + (double)entityplayer.getEyeHeight()), (double)entityplayer.posZ);
        Vec3 vec3d2 = entityplayer.getLookVec();
        Vec3 vec3d3 = vec3d.addVector(vec3d2.xCoord * range, vec3d2.yCoord * range, vec3d2.zCoord * range);
        float f1 = 1.1f;
        List list = world.getEntitiesWithinAABBExcludingEntity((Entity)entityplayer, entityplayer.boundingBox.addCoord(vec3d2.xCoord * range, vec3d2.yCoord * range, vec3d2.zCoord * range).expand((double)1.1f, (double)1.1f, (double)1.1f));
        double d2 = 0.0;
        for (Object o : list) {
            double d3;
            Entity entity = (Entity)o;
            if (!entity.canBeCollidedWith() || world.rayTraceBlocks(Vec3.createVectorHelper((double)entityplayer.posX, (double)(entityplayer.posY + (double)entityplayer.getEyeHeight()), (double)entityplayer.posZ), Vec3.createVectorHelper((double)entity.posX, (double)(entity.posY + (double)entity.getEyeHeight()), (double)entity.posZ), false) != null) continue;
            float f2 = Math.max(0.8f, entity.getCollisionBorderSize());
            AxisAlignedBB axisalignedbb = entity.boundingBox.expand((double)f2, (double)f2, (double)f2);
            MovingObjectPosition movingobjectposition = axisalignedbb.calculateIntercept(vec3d, vec3d3);
            if (axisalignedbb.isVecInside(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.distanceTo(movingobjectposition.hitVec)) < d2) && d2 != 0.0) continue;
            pointedEntity = entity;
            d2 = d3;
        }
        return pointedEntity;
    }

    boolean canJarEntity(EntityPlayer p) {
        return InventoryUtils.inventoryContains((IInventory)p.inventory, (ItemStack)new ItemStack(ConfigBlocks.blockJar, 1, 0), (int)0, (boolean)true, (boolean)true, (boolean)false) && InventoryUtils.placeItemStackIntoInventory((ItemStack)new ItemStack(ThaumicHorizons.blockJar), (IInventory)p.inventory, (int)0, (boolean)false) == null;
    }

    void jarEntity(EntityPlayer p, NBTTagCompound tag, String name, double x, double y, double z) {
        p.inventory.decrStackSize(InventoryUtils.isPlayerCarrying((EntityPlayer)p, (ItemStack)new ItemStack(ConfigBlocks.blockJar, 1, 0)), 1);
        ItemStack jar = new ItemStack(ThaumicHorizons.blockJar);
        jar.setTagCompound(tag);
        jar.getTagCompound().setString("jarredCritterName", name);
        jar.getTagCompound().setBoolean("isSoul", false);
        if (!p.inventory.addItemStackToInventory(jar)) {
            p.entityDropItem(jar, 1.0f);
        }
        if (!p.worldObj.isRemote) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXContainment(x, y, z), new NetworkRegistry.TargetPoint(p.worldObj.provider.dimensionId, x, y, z, 32.0));
        }
    }

    public boolean isVisCostPerTick(ItemStack focusstack) {
        return true;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack focusstack) {
        return ItemFocusBasic.WandFocusAnimation.CHARGE;
    }
}

