/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items;

import com.kentington.thaumichorizons.common.entities.EntityGolemTH;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import thaumcraft.codechicken.lib.math.MathHelper;
import thaumcraft.common.entities.golems.ItemGolemBell;

public class ItemGolemPlacer
extends thaumcraft.common.entities.golems.ItemGolemPlacer {
    public IIcon icon;
    public IIcon newBell;

    public ItemGolemPlacer() {
        this.setCreativeTab(null);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        super.registerIcons(ir);
        this.icon = ir.registerIcon("thaumichorizons:golem");
        this.newBell = ir.registerIcon("thaumichorizons:newbell");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int p_82790_2_) {
        if (!stack.hasTagCompound() || !stack.getTagCompound().hasKey("block")) {
            return 0;
        }
        int[] block = stack.getTagCompound().getIntArray("block");
        if (Block.getBlockById((int)block[0]) == Blocks.air) {
            return 0;
        }
        int color = Block.getBlockById((int)block[0]).getMapColor((int)block[1]).colorValue;
        if (color != 0) {
            return color;
        }
        return -1;
    }

    public void addInformation(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (stack.hasTagCompound() && stack.getTagCompound().hasKey("block")) {
            int[] block = stack.getTagCompound().getIntArray("block");
            String name = "?";
            ItemStack blockStack = new ItemStack(Block.getBlockById((int)block[0]), 1, block[1]);
            if (blockStack.getItem() != null) {
                list.add(blockStack.getDisplayName());
            } else if (Block.getBlockById((int)block[0]) == Blocks.air) {
                list.add("Voidling");
            } else {
                list.add(Block.getBlockById((int)block[0]).getLocalizedName());
            }
        }
        super.addInformation(stack, par2EntityPlayer, list, par4);
    }

    public boolean spawnCreature(World par0World, double par2, double par4, double par6, int side, ItemStack stack, EntityPlayer player) {
        boolean adv = stack.hasTagCompound() && stack.stackTagCompound.hasKey("advanced");
        EntityGolemTH golem = new EntityGolemTH(par0World);
        if (golem != null) {
            golem.setLocationAndAngles(par2, par4, par6, par0World.rand.nextFloat() * 360.0f, 0.0f);
            golem.playLivingSound();
            golem.setHomeArea(MathHelper.floor_double((double)par2), MathHelper.floor_double((double)par4), MathHelper.floor_double((double)par6), 32);
            int[] block = new int[]{0, 0};
            if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("core")) {
                golem.setCore(stack.stackTagCompound.getByte("core"));
            }
            String deco = "";
            if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("deco")) {
                golem.decoration = deco = stack.stackTagCompound.getString("deco");
            }
            if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("block")) {
                block = stack.stackTagCompound.getIntArray("block");
            }
            golem.setup(side);
            golem.loadGolem(golem.posX, golem.posY, golem.posZ, Block.getBlockById((int)block[0]), block[1], 600, adv, stack.stackTagCompound.getBoolean("berserk"), stack.stackTagCompound.getBoolean("explosive"));
            if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("upgrades")) {
                int ul = golem.upgrades.length;
                golem.upgrades = stack.stackTagCompound.getByteArray("upgrades");
                if (ul != golem.upgrades.length) {
                    int a;
                    byte[] tt = new byte[ul];
                    for (a = 0; a < ul; ++a) {
                        tt[a] = -1;
                    }
                    for (a = 0; a < golem.upgrades.length; ++a) {
                        if (a >= ul) continue;
                        tt[a] = golem.upgrades[a];
                    }
                    golem.upgrades = tt;
                }
            }
            par0World.spawnEntityInWorld((Entity)golem);
            golem.setGolemDecoration(deco);
            golem.setOwner(player.getCommandSenderName());
            golem.setMarkers(ItemGolemBell.getMarkers((ItemStack)stack));
            int a2 = 0;
            for (byte b : golem.upgrades) {
                golem.setUpgrade(a2, b);
                ++a2;
            }
            if (stack.hasDisplayName()) {
                golem.setCustomNameTag(stack.getDisplayName());
                golem.func_110163_bv();
            }
            if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("Inventory")) {
                NBTTagList nbttaglist2 = stack.stackTagCompound.getTagList("Inventory", 10);
                golem.inventory.readFromNBT(nbttaglist2);
            }
        }
        return golem != null;
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return "item.golemPlacer";
    }
}

