/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntityBlastPhial;
import com.kentington.thaumichorizons.common.entities.EntitySyringe;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thaumcraft.api.IRepairable;

public class ItemInjector
extends ItemBow
implements IRepairable {
    public ItemInjector() {
        this.maxStackSize = 1;
        this.setMaxDamage(1000);
        this.setCreativeTab(ThaumicHorizons.tabTH);
        this.setTextureName("thaumichorizons:injector");
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return "item.injector";
    }

    public int getItemEnchantability() {
        return 3;
    }

    public EnumAction getItemUseAction(ItemStack p_77661_1_) {
        return EnumAction.none;
    }

    public void onPlayerStoppedUsing(ItemStack p_77615_1_, World p_77615_2_, EntityPlayer p_77615_3_, int p_77615_4_) {
        int j = this.getMaxItemUseDuration(null) - p_77615_4_;
        if (this.getAmmo(p_77615_1_, 0) != null) {
            float f = (float)j / 30.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                p_77615_1_.stackTagCompound.setInteger("usetime", 0);
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            Object projectile = null;
            if (this.getAmmo(p_77615_1_, 0).getItemDamage() == 0) {
                int l;
                int k;
                EntitySyringe entityarrow = new EntitySyringe(p_77615_2_, (EntityLivingBase)p_77615_3_, f * 2.0f, this.getAmmo((ItemStack)p_77615_1_, (int)0).stackTagCompound);
                if (f == 1.0f) {
                    entityarrow.setIsCritical(true);
                }
                if ((k = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)p_77615_1_)) > 0) {
                    entityarrow.setDamage(entityarrow.getDamage() + (double)k * 0.5 + 0.5);
                }
                if ((l = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)p_77615_1_)) > 0) {
                    entityarrow.setKnockbackStrength(l);
                }
                if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)p_77615_1_) > 0) {
                    entityarrow.setFire(100);
                }
                projectile = entityarrow;
            } else {
                projectile = new EntityBlastPhial(p_77615_2_, (EntityLivingBase)p_77615_3_, f * 2.0f, this.getAmmo(p_77615_1_, 0));
            }
            p_77615_1_.damageItem(1, (EntityLivingBase)p_77615_3_);
            p_77615_2_.playSoundAtEntity((Entity)p_77615_3_, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (!p_77615_2_.isRemote) {
                p_77615_2_.spawnEntityInWorld((Entity)projectile);
                this.rotateAmmo(p_77615_1_);
            }
            p_77615_1_.stackTagCompound.setInteger("usetime", 0);
            p_77615_1_.stackTagCompound.setInteger("rotationTarget", p_77615_1_.stackTagCompound.getInteger("rotationTarget") + 90);
            if (p_77615_1_.stackTagCompound.getInteger("rotationTarget") > 360) {
                p_77615_1_.stackTagCompound.setInteger("rotationTarget", p_77615_1_.stackTagCompound.getInteger("rotationTarget") - 360);
            }
        }
    }

    public ItemStack onItemRightClick(ItemStack p_77659_1_, World p_77659_2_, EntityPlayer p_77659_3_) {
        if (p_77659_3_.isSneaking()) {
            p_77659_3_.openGui((Object)ThaumicHorizons.instance, 6, p_77659_2_, MathHelper.floor_double((double)p_77659_3_.posX), MathHelper.floor_double((double)p_77659_3_.posY), MathHelper.floor_double((double)p_77659_3_.posZ));
        } else if (this.getAmmo(p_77659_1_, 0) == null) {
            this.rotateAmmo(p_77659_1_);
            p_77659_2_.playSoundEffect(p_77659_3_.posX, p_77659_3_.posY + (double)p_77659_3_.getEyeHeight(), p_77659_3_.posZ, "random.click", 1.0f, 1.0f);
        } else {
            p_77659_3_.setItemInUse(p_77659_1_, this.getMaxItemUseDuration(p_77659_1_));
        }
        return p_77659_1_;
    }

    public ItemStack getAmmo(ItemStack stack, int slot) {
        if (stack.stackTagCompound == null) {
            return null;
        }
        NBTTagList ammo = stack.stackTagCompound.getTagList("ammo", 10);
        return ItemStack.loadItemStackFromNBT((NBTTagCompound)ammo.getCompoundTagAt(slot));
    }

    void rotateAmmo(ItemStack stack) {
        if (stack.stackTagCompound == null) {
            return;
        }
        NBTTagList ammo = stack.stackTagCompound.getTagList("ammo", 10);
        NBTTagList newAmmo = new NBTTagList();
        for (int i = 1; i < 7; ++i) {
            if (ammo.getCompoundTagAt(i) != null) {
                newAmmo.appendTag(ammo.getCompoundTagAt(i).copy());
                continue;
            }
            newAmmo.appendTag((NBTBase)new NBTTagCompound());
        }
        newAmmo.appendTag((NBTBase)new NBTTagCompound());
        stack.stackTagCompound.setTag("ammo", (NBTBase)newAmmo);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (player.worldObj.isRemote) {
            stack.stackTagCompound.setInteger("usetime", stack.stackTagCompound.getInteger("usetime") + 1);
            stack.stackTagCompound.setInteger("rotationTarget", stack.stackTagCompound.getInteger("rotation"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister p_94581_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIconForUseDuration(int p_94599_1_) {
        return null;
    }

    public int getMaxItemUseDuration(ItemStack p_77626_1_) {
        return 72000;
    }

    public ItemStack onEaten(ItemStack p_77654_1_, World p_77654_2_, EntityPlayer p_77654_3_) {
        return p_77654_1_;
    }
}

