/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.lib;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntityMeatSlime;
import com.kentington.thaumichorizons.common.entities.EntityMercurialSlime;
import com.kentington.thaumichorizons.common.tiles.TileVortex;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.monster.EntityTaintSporeSwarmer;
import thaumcraft.common.entities.monster.EntityTaintacle;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;

public class PocketPlaneData {
    public int radius = 32;
    public int color = 0;
    public int[] potionEffects;
    public int[] portalA;
    public int[] portalB;
    public int[] portalC;
    public int[] portalD;
    public String name = "Generic Pocket Plane";
    private static final short MAX_CREATURES = 100;
    private static short creatures;
    public static final LinkedList<PocketPlaneData> planes;
    public static final HashMap<Integer, Vec3> positions;
    public static int pocketPlaneMAXID;

    private static int fastFloor(Number a) {
        return (float)a.intValue() > a.floatValue() ? a.intValue() - 1 : a.intValue();
    }

    public static void generatePocketPlane(AspectList aspects, PocketPlaneData data, World world, int vortexX, int vortexY, int vortexZ, int returnID) {
        if (!world.isRemote) {
            boolean xCenter = false;
            int yCenter = 128;
            int zCenter = 256 * planes.size();
            data.radius = (float)aspects.visSize() * 0.75f < 128.0f ? (int)Math.max(32.0f, (float)aspects.visSize() * 0.75f) : 127;
            data.color = PocketPlaneData.getColor(aspects);
            BiomeGenBase bio = PocketPlaneData.setBiome(0, 128, zCenter, data, world, aspects);
            int noise = PocketPlaneData.fastFloor(PocketPlaneData.calcNoise(aspects));
            int life = PocketPlaneData.fastFloor(PocketPlaneData.calcLife(aspects));
            PocketPlaneData.drawLayers(0, 128, zCenter, data, world, aspects, noise, bio, life);
            PocketPlaneData.drawCaves(0, 128, zCenter, data, world, aspects, noise);
            PocketPlaneData.drawPockets(0, 128, zCenter, data, world, aspects, noise);
            PocketPlaneData.drawRavines(0, 128, zCenter, data, world, aspects, noise);
            PocketPlaneData.drawClouds(0, 128, zCenter, data, world, aspects, noise);
            PocketPlaneData.drawSurfaceFeatures(0, 128, zCenter, data, world, aspects, noise, life);
            PocketPlaneData.drawUndergroundFeatures(0, 128, zCenter, data, world, aspects, noise, life);
            PocketPlaneData.drawLeviathanBones(0, 128, zCenter, data, world, aspects, noise);
            PocketPlaneData.addEffects(data, aspects);
            PocketPlaneData.drawRings(0, 128, zCenter, data, world, aspects);
            PocketPlaneData.drawSphere(0, 128, zCenter, data.radius, ThaumicHorizons.blockVoid, 0, world);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    world.setBlock(0 + x, 128, zCenter + z, ConfigBlocks.blockCosmeticSolid, 6, 0);
                    world.setBlockToAir(0 + x, 129, zCenter + z);
                    world.setBlockToAir(0 + x, 130, zCenter + z);
                }
            }
            world.setBlock(0, 129, zCenter, ThaumicHorizons.blockVortex);
            TileVortex vortex = (TileVortex)world.getTileEntity(0, 129, zCenter);
            vortex.cheat = true;
            vortex.returnID = returnID;
            vortex.dimensionID = planes.size();
            vortex.createdDimension = true;
            world.setTileEntity(0, 129, zCenter, (TileEntity)vortex);
            data.portalA = new int[4];
            data.portalB = new int[4];
            data.portalC = new int[4];
            data.portalD = new int[4];
            planes.add(data);
            positions.put(pocketPlaneMAXID, Vec3.createVectorHelper((double)vortexX, (double)vortexY, (double)vortexZ));
            world.getChunkFromBlockCoords((int)vortexX, (int)vortexZ).isModified = true;
            creatures = 0;
            ++pocketPlaneMAXID;
        }
    }

    static int getColor(AspectList aspects) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (Aspect asp : aspects.getAspects()) {
            if (asp == null) continue;
            Color aspColor = new Color(asp.getColor());
            r += (int)((double)aspColor.getRed() * PocketPlaneData.aspectFraction(asp, aspects));
            g += (int)((double)aspColor.getGreen() * PocketPlaneData.aspectFraction(asp, aspects));
            b += (int)((double)aspColor.getBlue() * PocketPlaneData.aspectFraction(asp, aspects));
        }
        return r * 256 * 256 + g * 256 + b;
    }

    public static void addEffects(PocketPlaneData data, AspectList aspects) {
        int pointer = 0;
        data.potionEffects = new int[8];
        if (aspects.getAmount(Aspect.MOTION) > 0) {
            data.potionEffects[pointer] = Potion.moveSpeed.id;
            ++pointer;
        }
        if (aspects.getAmount(Aspect.FLIGHT) > 0) {
            data.potionEffects[pointer] = Potion.jump.id;
            ++pointer;
        }
        if (aspects.getAmount(Aspect.HEAL) > 0) {
            data.potionEffects[pointer] = Potion.regeneration.id;
            ++pointer;
        }
        if (aspects.getAmount(Aspect.TRAVEL) > 0) {
            data.potionEffects[pointer] = Potion.moveSpeed.id;
            ++pointer;
        }
        if (aspects.getAmount(Aspect.TOOL) > 0) {
            data.potionEffects[pointer] = Potion.digSpeed.id;
            ++pointer;
        }
        if (aspects.getAmount(Aspect.WEAPON) > 0) {
            data.potionEffects[pointer] = Potion.damageBoost.id;
            ++pointer;
        }
        if (aspects.getAmount(Aspect.ARMOR) > 0) {
            data.potionEffects[pointer] = Potion.resistance.id;
            ++pointer;
        }
    }

    public static boolean drawRings(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects) {
        boolean drewAnything = false;
        int numRings = 0;
        if (aspects.getAmount(Aspect.ELDRITCH) > 0) {
            PocketPlaneData.drawSphere(xCenter, yCenter, zCenter, data.radius - ++numRings, ConfigBlocks.blockCosmeticSolid, 11, world);
            drewAnything = true;
        }
        if (aspects.getAmount(Aspect.DARKNESS) > 0) {
            PocketPlaneData.drawSphere(xCenter, yCenter, zCenter, data.radius - ++numRings, Blocks.obsidian, 0, world);
            drewAnything = true;
        }
        if (aspects.getAmount(Aspect.ELDRITCH) > 0) {
            PocketPlaneData.drawSphere(xCenter, yCenter, zCenter, data.radius - ++numRings, ConfigBlocks.blockCosmeticSolid, 11, world);
            drewAnything = true;
        }
        if (aspects.getAmount(Aspect.CRYSTAL) > 0) {
            PocketPlaneData.drawSphere(xCenter, yCenter, zCenter, data.radius - ++numRings, Blocks.glass, 0, world);
            drewAnything = true;
        }
        if (aspects.getAmount(Aspect.COLD) > 0) {
            PocketPlaneData.drawSphere(xCenter, yCenter, zCenter, data.radius - ++numRings, Blocks.packed_ice, 0, world);
            drewAnything = true;
        }
        return drewAnything;
    }

    public static double calcNoise(AspectList aspects) {
        double noise = 50.0;
        noise -= PocketPlaneData.aspectFraction(Aspect.ORDER, aspects) * 100.0;
        noise += PocketPlaneData.aspectFraction(Aspect.ENTROPY, aspects) * 100.0;
        noise += PocketPlaneData.aspectFraction(Aspect.MOTION, aspects) * 50.0;
        noise += PocketPlaneData.aspectFraction(Aspect.EXCHANGE, aspects) * 100.0;
        noise += PocketPlaneData.aspectFraction(Aspect.FLIGHT, aspects) * 50.0;
        if ((noise -= PocketPlaneData.aspectFraction(Aspect.TRAVEL, aspects) * 100.0) > 100.0) {
            return 100.0;
        }
        return Math.max(noise, 0.0);
    }

    public static double calcLife(AspectList aspects) {
        double life = 0.0;
        life += PocketPlaneData.aspectFraction(Aspect.LIGHT, aspects) * 25.0;
        life += PocketPlaneData.aspectFraction(Aspect.WEATHER, aspects) * 25.0;
        life += PocketPlaneData.aspectFraction(Aspect.LIFE, aspects) * 150.0;
        life -= PocketPlaneData.aspectFraction(Aspect.POISON, aspects) * 75.0;
        life -= PocketPlaneData.aspectFraction(Aspect.DEATH, aspects) * 100.0;
        life -= PocketPlaneData.aspectFraction(Aspect.DARKNESS, aspects) * 25.0;
        life += PocketPlaneData.aspectFraction(Aspect.SOUL, aspects) * 50.0;
        life += PocketPlaneData.aspectFraction(Aspect.HEAL, aspects) * 150.0;
        life += PocketPlaneData.aspectFraction(Aspect.AURA, aspects) * 50.0;
        life += PocketPlaneData.aspectFraction(Aspect.SLIME, aspects) * 50.0;
        life += PocketPlaneData.aspectFraction(Aspect.PLANT, aspects) * 100.0;
        life += PocketPlaneData.aspectFraction(Aspect.TREE, aspects) * 100.0;
        life += PocketPlaneData.aspectFraction(Aspect.BEAST, aspects) * 100.0;
        life += PocketPlaneData.aspectFraction(Aspect.FLESH, aspects) * 50.0;
        life -= PocketPlaneData.aspectFraction(Aspect.UNDEAD, aspects) * 50.0;
        life += PocketPlaneData.aspectFraction(Aspect.MIND, aspects) * 25.0;
        life += PocketPlaneData.aspectFraction(Aspect.SENSES, aspects) * 25.0;
        life += PocketPlaneData.aspectFraction(Aspect.MAN, aspects) * 25.0;
        life += PocketPlaneData.aspectFraction(Aspect.CROP, aspects) * 50.0;
        life += PocketPlaneData.aspectFraction(Aspect.HARVEST, aspects) * 25.0;
        life -= PocketPlaneData.aspectFraction(Aspect.WEAPON, aspects) * 25.0;
        life -= PocketPlaneData.aspectFraction(Aspect.HUNGER, aspects) * 25.0;
        if ((life += PocketPlaneData.aspectFraction(Aspect.CLOTH, aspects) * 25.0) < 0.0) {
            life = 0.0;
        } else if (life > 100.0) {
            life = 100.0;
        }
        return life;
    }

    public static double aspectFraction(Aspect asp, AspectList aspects) {
        return (double)aspects.getAmount(asp) / (double)aspects.visSize();
    }

    private static Aspect getMainAspect(AspectList aspects) {
        int max = 0;
        Aspect ret = null;
        for (Aspect a : aspects.aspects.keySet()) {
            if ((Integer)aspects.aspects.get(a) <= max) continue;
            max = (Integer)aspects.aspects.get(a);
            ret = a;
        }
        return ret;
    }

    public static void drawLayers(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects, int noise, BiomeGenBase bio, int life) {
        int total = aspects.visSize();
        int level = yCenter;
        boolean drewAnything = false;
        if (aspects.getAmount(Aspect.COLD) > 0) {
            PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, Blocks.packed_ice, 0, level, 0, null, 0, aspects);
            level -= PocketPlaneData.fastFloor(PocketPlaneData.aspectFraction(Aspect.COLD, aspects) * (double)data.radius);
            drewAnything = true;
        }
        if (aspects.getAmount(Aspect.WATER) > 0) {
            PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, Blocks.water, 0, level, 0, bio, life, aspects);
            level -= PocketPlaneData.fastFloor(PocketPlaneData.aspectFraction(Aspect.WATER, aspects) * (double)data.radius / 1.5);
            drewAnything = true;
        }
        if (aspects.getAmount(Aspect.TAINT) > 0) {
            PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, ConfigBlocks.blockTaint, 1, level, noise, bio, life, aspects);
            level -= PocketPlaneData.fastFloor(PocketPlaneData.aspectFraction(Aspect.TAINT, aspects) * (double)data.radius);
            drewAnything = true;
        }
        if (aspects.getAmount(Aspect.CLOTH) > 0) {
            PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, Blocks.wool, 0, level, noise, null, 0, aspects);
            level -= PocketPlaneData.fastFloor(PocketPlaneData.aspectFraction(Aspect.CLOTH, aspects) * (double)data.radius);
            drewAnything = true;
        }
        if (aspects.getAmount(Aspect.FLESH) > 0) {
            PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, ConfigBlocks.blockTaint, 2, level, noise, null, 0, aspects);
            level -= PocketPlaneData.fastFloor(PocketPlaneData.aspectFraction(Aspect.CLOTH, aspects) * (double)data.radius);
            drewAnything = true;
        }
        if (aspects.getAmount(Aspect.EARTH) > 0) {
            if (bio == BiomeGenBase.desert) {
                PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, (Block)Blocks.sand, 0, level, noise, bio, life, aspects);
            } else {
                PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, Blocks.dirt, 0, level, noise, bio, life, aspects);
            }
            if (aspects.getAmount(Aspect.ORDER) >= aspects.getAmount(Aspect.ENTROPY)) {
                PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, Blocks.stone, 0, level - 5, noise, null, 0, aspects);
            } else {
                PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, Blocks.cobblestone, 0, level - 5, noise, null, 0, aspects);
            }
            level -= PocketPlaneData.fastFloor(PocketPlaneData.aspectFraction(Aspect.EARTH, aspects) * (double)data.radius);
            drewAnything = true;
        }
        if (aspects.getAmount(Aspect.FIRE) > 0) {
            PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, Blocks.netherrack, 0, level, noise, null, 0, aspects);
            level -= PocketPlaneData.fastFloor(PocketPlaneData.aspectFraction(Aspect.FIRE, aspects) * (double)data.radius);
            drewAnything = true;
        }
        if (aspects.getAmount(Aspect.ARMOR) > 0) {
            PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, Blocks.obsidian, 0, level, noise, null, 0, aspects);
            level -= PocketPlaneData.fastFloor(PocketPlaneData.aspectFraction(Aspect.ARMOR, aspects) * (double)data.radius);
            drewAnything = true;
        }
        if (!drewAnything) {
            PocketPlaneData.drawLayer(xCenter, yCenter, zCenter, data, world, ThaumicHorizons.blockDust, 0, level, noise, bio, life, aspects);
            level -= PocketPlaneData.fastFloor(PocketPlaneData.aspectFraction(Aspect.ARMOR, aspects) * (double)data.radius);
            drewAnything = true;
        }
    }

    public static void drawLayer(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, Block block, int md, int level, int noise, BiomeGenBase bio, int life, AspectList aspects) {
        NoiseGeneratorOctaves noiseGen = new NoiseGeneratorOctaves(world.rand, 10);
        double[] noiseData = null;
        if (noise != 0) {
            noiseData = noiseGen.generateNoiseOctaves(noiseData, xCenter - data.radius, yCenter, zCenter - data.radius, 2 * data.radius, 1, 2 * data.radius, (double)((float)noise / 25.0f), (double)((float)noise / 50.0f), (double)((float)noise / 25.0f));
        }
        for (int x = -data.radius; x <= data.radius; ++x) {
            for (int z = -data.radius; z <= data.radius; ++z) {
                int y;
                int top = 0;
                if (noise != 0 && x + data.radius + (z * 2 * data.radius + data.radius * data.radius * 2) < noiseData.length) {
                    top = (int)(noiseData[x + data.radius + (z * 2 * data.radius + data.radius * data.radius * 2)] / 8.0);
                }
                int offsettop = -level + yCenter;
                int ctop = x * x + z * z + offsettop * offsettop - data.radius * data.radius;
                int tmax = offsettop + (int)Math.sqrt(offsettop * offsettop - ctop);
                int offsetbottom = level - yCenter;
                int cbottom = x * x + z * z + offsetbottom * offsetbottom - data.radius * data.radius;
                int bmax = offsetbottom + (int)Math.sqrt(offsetbottom * offsetbottom - cbottom);
                if (top > tmax) {
                    top = tmax;
                }
                int bottom = y = -bmax;
                while (y <= top) {
                    if (top != bottom && level + y > 0) {
                        if (y == top) {
                            if (block != null) {
                                world.setBlock(x + xCenter, y + level, z + zCenter, block, md, 0);
                            }
                            if (block == Blocks.water) {
                                if (bio != null && bio.getTempCategory() == BiomeGenBase.TempCategory.COLD) {
                                    world.setBlock(x + xCenter, y + level, z + zCenter, Blocks.ice, 0, 0);
                                } else {
                                    world.setBlock(x + xCenter, y + level, z + zCenter, block, 0, 0);
                                    if ((life > 40 || aspects.getAmount(Aspect.BEAST) > 0) && world.rand.nextInt(100) > 98 && creatures < 100) {
                                        EntitySquid squiddie = new EntitySquid(world);
                                        squiddie.setPosition((double)(x + xCenter), (double)(y + level), (double)(z + zCenter));
                                        squiddie.func_110163_bv();
                                        world.spawnEntityInWorld((Entity)squiddie);
                                        creatures = (short)(creatures + 1);
                                    }
                                    if (life > 0 && world.rand.nextInt(100) > 98) {
                                        world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.waterlily, 0, 0);
                                    }
                                }
                            } else if (block == Blocks.dirt) {
                                if (life > 0 && world.isAirBlock(x + xCenter, y + level + 1, z + zCenter)) {
                                    world.setBlock(x + xCenter, y + level, z + zCenter, (Block)Blocks.grass, 0, 0);
                                    if (life >= 10) {
                                        if ((life >= 20 || aspects.getAmount(Aspect.CROP) > 0 || aspects.getAmount(Aspect.HARVEST) > 0) && world.rand.nextInt(100) > 97) {
                                            switch (world.rand.nextInt(10)) {
                                                case 0: {
                                                    world.setBlock(x + xCenter, y + level, z + zCenter, Blocks.farmland, 0, 0);
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.carrots, 0, 0);
                                                    break;
                                                }
                                                case 1: {
                                                    world.setBlock(x + xCenter, y + level, z + zCenter, Blocks.farmland, 0, 0);
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.potatoes, 0, 0);
                                                    break;
                                                }
                                                case 2: {
                                                    world.setBlock(x + xCenter, y + level, z + zCenter, Blocks.farmland, 0, 0);
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.wheat, 0, 0);
                                                    break;
                                                }
                                                case 3: {
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.melon_block, 0, 0);
                                                    break;
                                                }
                                                case 4: {
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.pumpkin, 0, 0);
                                                    break;
                                                }
                                                case 5: {
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.reeds, 0, 0);
                                                    break;
                                                }
                                                case 6: {
                                                    world.setBlock(x + xCenter, y + level, z + zCenter, (Block)Blocks.mycelium, 0, 0);
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, (Block)Blocks.red_mushroom, 0, 0);
                                                    break;
                                                }
                                                case 7: {
                                                    world.setBlock(x + xCenter, y + level, z + zCenter, (Block)Blocks.mycelium, 0, 0);
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, (Block)Blocks.brown_mushroom, 0, 0);
                                                    break;
                                                }
                                                case 8: {
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, ConfigBlocks.blockCustomPlant, 2, 0);
                                                    break;
                                                }
                                                case 9: {
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, ConfigBlocks.blockCustomPlant, 5, 0);
                                                }
                                            }
                                        } else if ((life >= 15 || aspects.getAmount(Aspect.TREE) > 0) && world.rand.nextInt(100) > 97) {
                                            switch (world.rand.nextInt(10)) {
                                                case 0: {
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.sapling, 0, 0);
                                                    break;
                                                }
                                                case 1: {
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.sapling, 1, 0);
                                                    break;
                                                }
                                                case 2: {
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.sapling, 2, 0);
                                                    break;
                                                }
                                                case 3: {
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.sapling, 3, 0);
                                                    break;
                                                }
                                                case 4: {
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.sapling, 4, 0);
                                                    break;
                                                }
                                                case 5: {
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.sapling, 5, 0);
                                                    break;
                                                }
                                                case 6: {
                                                    if ((bio == null || bio.biomeID != Config.biomeMagicalForestID) && aspects.getAmount(Aspect.MAGIC) <= 10 && aspects.getAmount(Aspect.AURA) <= 5 || world.rand.nextInt(4) != 0) break;
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, ConfigBlocks.blockCustomPlant, 1, 0);
                                                    break;
                                                }
                                                case 7: {
                                                    if (world.rand.nextInt(3) != 0) break;
                                                    world.setBlock(x + xCenter, y + level + 1, z + zCenter, ConfigBlocks.blockCustomPlant, 0, 0);
                                                }
                                            }
                                        } else if ((life >= 10 || aspects.getAmount(Aspect.PLANT) > 0) && world.rand.nextInt(100) > 94) {
                                            int random = world.rand.nextInt(18);
                                            if (random <= 15) {
                                                world.setBlock(x + xCenter, y + level + 1, z + zCenter, (Block)Blocks.red_flower, random, 0);
                                            } else {
                                                world.setBlock(x + xCenter, y + level + 1, z + zCenter, (Block)Blocks.tallgrass, random - 16, 0);
                                            }
                                        }
                                    }
                                } else {
                                    world.setBlock(x + xCenter, y + level, z + zCenter, block, 0, 0);
                                }
                            } else if (block == Blocks.sand) {
                                world.setBlock(x + xCenter, y + level, z + zCenter, block, 0, 0);
                                if (life > 10) {
                                    if (life >= 20 && world.rand.nextInt(100) > 98) {
                                        world.setBlock(x + xCenter, y + level + 1, z + zCenter, ConfigBlocks.blockCustomPlant, 3, 0);
                                    } else if (world.rand.nextInt(100) > 97) {
                                        world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.cactus, 0, 0);
                                    }
                                }
                            } else if (block == ConfigBlocks.blockTaint && md == 2 && world.rand.nextInt(300) > 298) {
                                int why;
                                int zee;
                                if (world.rand.nextBoolean()) {
                                    for (int ecks = 0; ecks < 3; ++ecks) {
                                        for (zee = 0; zee < 2; ++zee) {
                                            for (why = 0; why < 2; ++why) {
                                                world.setBlock(x + xCenter + ecks, y + level + why, z + zCenter + zee, ThaumicHorizons.blockBrain, 0, 0);
                                            }
                                        }
                                    }
                                } else {
                                    for (int ecks = 0; ecks < 2; ++ecks) {
                                        for (zee = 0; zee < 3; ++zee) {
                                            for (why = 0; why < 2; ++why) {
                                                world.setBlock(x + xCenter + ecks, y + level + why, z + zCenter + zee, ThaumicHorizons.blockBrain, 0, 0);
                                            }
                                        }
                                    }
                                }
                            }
                            if (bio != null && block.isNormalCube() && bio.getTempCategory() == BiomeGenBase.TempCategory.COLD) {
                                world.setBlock(x + xCenter, y + level + 1, z + zCenter, Blocks.snow_layer, 1, 0);
                            }
                            if ((life >= 50 || aspects.getAmount(Aspect.BEAST) > 0) && world.rand.nextInt(100) > 98) {
                                EntityCow critter = null;
                                switch (world.rand.nextInt(7)) {
                                    case 0: {
                                        critter = new EntityCow(world);
                                        break;
                                    }
                                    case 1: {
                                        critter = new EntityPig(world);
                                        break;
                                    }
                                    case 2: {
                                        critter = new EntityChicken(world);
                                        break;
                                    }
                                    case 3: {
                                        critter = new EntitySheep(world);
                                        break;
                                    }
                                    case 4: {
                                        critter = new EntityHorse(world);
                                        break;
                                    }
                                    case 5: {
                                        critter = new EntityOcelot(world);
                                        break;
                                    }
                                    case 6: {
                                        critter = new EntityWolf(world);
                                    }
                                }
                                if (critter != null && creatures < 100) {
                                    critter.setPosition((double)(x + xCenter) + 0.5, (double)(y + level + 1), (double)(z + zCenter) + 0.5);
                                    world.spawnEntityInWorld((Entity)critter);
                                    creatures = (short)(creatures + 1);
                                }
                            }
                            if ((aspects.getAmount(Aspect.POISON) > 0 || aspects.getAmount(Aspect.EXCHANGE) > 0 || aspects.getAmount(Aspect.METAL) > 0 || aspects.getAmount(Aspect.MECHANISM) > 0) && world.rand.nextInt(100) > 98 && creatures < 100) {
                                EntityMercurialSlime slime = new EntityMercurialSlime(world);
                                slime.setPosition((double)(x + xCenter) + 0.5, y + level + 1, (double)(z + zCenter) + 0.5);
                                world.spawnEntityInWorld((Entity)slime);
                                creatures = (short)(creatures + 1);
                            }
                            if ((aspects.getAmount(Aspect.SLIME) > 0 || aspects.getAmount(Aspect.FLESH) > 0 || aspects.getAmount(Aspect.HUNGER) > 0) && world.rand.nextInt(100) > 98 && creatures < 100) {
                                EntityMeatSlime slime2 = new EntityMeatSlime(world);
                                slime2.setPosition((double)(x + xCenter) + 0.5, y + level + 1, (double)(z + zCenter) + 0.5);
                                world.spawnEntityInWorld((Entity)slime2);
                                creatures = (short)(creatures + 1);
                            }
                            if (aspects.getAmount(Aspect.SLIME) > 0 && world.rand.nextInt(100) > 98 && creatures < 100) {
                                EntitySlime slime3 = new EntitySlime(world);
                                slime3.setPosition((double)(x + xCenter) + 0.5, (double)(y + level + 1), (double)(z + zCenter) + 0.5);
                                world.spawnEntityInWorld((Entity)slime3);
                                creatures = (short)(creatures + 1);
                            }
                            if (aspects.getAmount(Aspect.ELDRITCH) > 0 && world.rand.nextInt(200) > 198) {
                                world.setBlock(x + xCenter, y + level, z + zCenter, ConfigBlocks.blockCosmeticSolid, 1, 0);
                                world.setBlock(x + xCenter, y + level + 1, z + zCenter, ConfigBlocks.blockCosmeticSolid, 0, 0);
                                world.setBlock(x + xCenter, y + level + 2, z + zCenter, ConfigBlocks.blockCosmeticSolid, 0, 0);
                                world.setBlock(x + xCenter, y + level + 3, z + zCenter, ConfigBlocks.blockCosmeticSolid, 0, 0);
                            }
                            if (aspects.getAmount(Aspect.CRAFT) > 0 && world.rand.nextInt(200) > 198) {
                                world.setBlock(x + xCenter, y + level + 1, z + zCenter, ConfigBlocks.blockStoneDevice, 1, 0);
                            }
                            if (aspects.getAmount(Aspect.TAINT) > 0 && world.rand.nextInt(100) > 98) {
                                world.setBlock(x + xCenter, y + level, z + zCenter, ConfigBlocks.blockTaintFibres, 0, 0);
                            }
                            if (aspects.getAmount(Aspect.TAINT) > 0 && world.rand.nextInt(200) > 198 && creatures < 100) {
                                EntityTaintacle slime4 = new EntityTaintacle(world);
                                slime4.setPosition((double)(x + xCenter) + 0.5, (double)(y + level + 1), (double)(z + zCenter) + 0.5);
                                world.spawnEntityInWorld((Entity)slime4);
                                creatures = (short)(creatures + 1);
                            }
                            if (aspects.getAmount(Aspect.TAINT) > 0 && world.rand.nextInt(200) > 198 && creatures < 100) {
                                EntityTaintSporeSwarmer slime5 = new EntityTaintSporeSwarmer(world);
                                slime5.setPosition((double)(x + xCenter) + 0.5, (double)(y + level + 1), (double)(z + zCenter) + 0.5);
                                world.spawnEntityInWorld((Entity)slime5);
                                creatures = (short)(creatures + 1);
                            }
                        } else if (block != null) {
                            world.setBlock(x + xCenter, y + level, z + zCenter, block, md, 0);
                        }
                    }
                    ++y;
                }
            }
        }
    }

    public static void drawCaves(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects, int noise) {
        float solidity = 0.5f;
        solidity = (float)((double)solidity - PocketPlaneData.aspectFraction(Aspect.AIR, aspects) * 0.5);
        solidity = (float)((double)solidity + PocketPlaneData.aspectFraction(Aspect.ORDER, aspects) * 0.25);
        solidity = (float)((double)solidity - PocketPlaneData.aspectFraction(Aspect.VOID, aspects));
        solidity = (float)((double)solidity - PocketPlaneData.aspectFraction(Aspect.FLIGHT, aspects) * 0.5);
        solidity = (float)((double)solidity + PocketPlaneData.aspectFraction(Aspect.CRAFT, aspects) * 0.5);
        if ((solidity = (float)((double)solidity - PocketPlaneData.aspectFraction(Aspect.TRAP, aspects) * 0.5)) <= 0.0f) {
            solidity = 0.0f;
        } else if (solidity > 1.0f) {
            solidity = 1.0f;
        }
        int numCaves = (int)((float)(data.radius * data.radius * data.radius / 10000) * (solidity + 0.1f));
        HashMap<Aspect, Number> dressing = new HashMap<Aspect, Number>();
        if (aspects.getAmount(Aspect.EARTH) > 0) {
            dressing.put(Aspect.EARTH, PocketPlaneData.aspectFraction(Aspect.EARTH, aspects));
        }
        if (aspects.getAmount(Aspect.FIRE) > 0) {
            dressing.put(Aspect.FIRE, PocketPlaneData.aspectFraction(Aspect.FIRE, aspects));
        }
        if (aspects.getAmount(Aspect.ORDER) > 0) {
            dressing.put(Aspect.ORDER, PocketPlaneData.aspectFraction(Aspect.ORDER, aspects));
        }
        if (aspects.getAmount(Aspect.AIR) > 0) {
            dressing.put(Aspect.AIR, PocketPlaneData.aspectFraction(Aspect.AIR, aspects));
        }
        if (aspects.getAmount(Aspect.WATER) > 0) {
            dressing.put(Aspect.WATER, PocketPlaneData.aspectFraction(Aspect.WATER, aspects));
        }
        if (aspects.getAmount(Aspect.ENTROPY) > 0) {
            dressing.put(Aspect.ENTROPY, PocketPlaneData.aspectFraction(Aspect.ENTROPY, aspects));
        }
        if (aspects.getAmount(Aspect.METAL) > 0) {
            dressing.put(Aspect.METAL, PocketPlaneData.aspectFraction(Aspect.METAL, aspects));
        }
        if (aspects.getAmount(Aspect.DEATH) > 0) {
            dressing.put(Aspect.DEATH, PocketPlaneData.aspectFraction(Aspect.DEATH, aspects));
        }
        if (aspects.getAmount(Aspect.UNDEAD) > 0) {
            dressing.put(Aspect.UNDEAD, PocketPlaneData.aspectFraction(Aspect.UNDEAD, aspects));
        }
        if (aspects.getAmount(Aspect.SENSES) > 0) {
            dressing.put(Aspect.SENSES, PocketPlaneData.aspectFraction(Aspect.SENSES, aspects));
        }
        if (aspects.getAmount(Aspect.GREED) > 0) {
            dressing.put(Aspect.GREED, PocketPlaneData.aspectFraction(Aspect.GREED, aspects));
        }
        for (int i = 0; i < numCaves; ++i) {
            PocketPlaneData.drawACave(xCenter, yCenter, zCenter, data, world, aspects, noise, Blocks.air, world.rand.nextInt(10) + 10, world.rand.nextInt(10) + 10, world.rand.nextInt((int)((float)data.radius * 1.5f)) - (int)((float)data.radius * 0.75f), -world.rand.nextInt((int)((float)data.radius * 0.5f)), world.rand.nextInt((int)((float)data.radius * 1.5f)) - (int)((float)data.radius * 0.75f), dressing);
        }
    }

    public static void drawACave(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects, int noise, Block block, int xSize, int zSize, int xOffset, int yOffset, int zOffset, HashMap<Aspect, Number> dressing) {
        NoiseGeneratorOctaves noiseGen = new NoiseGeneratorOctaves(world.rand, 10);
        double[] noiseData = null;
        noiseData = noiseGen.generateNoiseOctaves(noiseData, xCenter - xSize + xOffset, yCenter + yOffset, zCenter - zSize + zOffset, xSize, 16, zSize, (double)((float)noise / 10.0f), (double)((float)noise / 25.0f), (double)((float)noise / 10.0f));
        int avg = PocketPlaneData.getAvg(noiseData);
        for (int x = 0; x < xSize; ++x) {
            for (int z = 0; z < zSize; ++z) {
                for (int y = 0; y < 16; ++y) {
                    if (!(noiseData[x + xSize * z + y * xSize * zSize] > (double)avg) || world.getBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z) == Blocks.water) continue;
                    if (!world.isAirBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y - 1, zCenter - zSize + zOffset + z) && world.rand.nextInt(50) == 49) {
                        float which = world.rand.nextFloat();
                        Aspect whichAspect = null;
                        Iterator<Aspect> it = dressing.keySet().iterator();
                        boolean doDressing = false;
                        while (it.hasNext()) {
                            whichAspect = it.next();
                            if (which <= dressing.get(whichAspect).floatValue()) {
                                doDressing = true;
                                break;
                            }
                            which -= dressing.get(whichAspect).floatValue();
                        }
                        if (!doDressing || whichAspect == null || world.isAirBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z) || world.getBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z) == Blocks.water) continue;
                        if (whichAspect == Aspect.EARTH) {
                            world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, ConfigBlocks.blockCrystal, 3, 0);
                            continue;
                        }
                        if (whichAspect == Aspect.AIR) {
                            world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, ConfigBlocks.blockCrystal, 0, 0);
                            continue;
                        }
                        if (whichAspect == Aspect.WATER) {
                            world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, ConfigBlocks.blockCrystal, 2, 0);
                            continue;
                        }
                        if (whichAspect == Aspect.FIRE) {
                            world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, ConfigBlocks.blockCrystal, 1, 0);
                            continue;
                        }
                        if (whichAspect == Aspect.ORDER) {
                            world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, ConfigBlocks.blockCrystal, 4, 0);
                            continue;
                        }
                        if (whichAspect == Aspect.ENTROPY) {
                            world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, ConfigBlocks.blockCrystal, 5, 0);
                            continue;
                        }
                        if (whichAspect == Aspect.DEATH || whichAspect == Aspect.UNDEAD) {
                            world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, Blocks.skull, 0, 0);
                            continue;
                        }
                        if (whichAspect == Aspect.SENSES) {
                            world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, Blocks.lapis_block, 0, 0);
                            continue;
                        }
                        if (whichAspect == Aspect.GREED) {
                            if (world.rand.nextBoolean()) {
                                world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, Blocks.gold_block, 0, 0);
                                continue;
                            }
                            world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, Blocks.emerald_block, 0, 0);
                            continue;
                        }
                        if (whichAspect != Aspect.METAL) continue;
                        if (world.rand.nextBoolean()) {
                            world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, Blocks.gold_block, 0, 0);
                            continue;
                        }
                        world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, Blocks.iron_block, 0, 0);
                        continue;
                    }
                    world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, Blocks.air, 0, 0);
                }
            }
        }
    }

    public static void drawRavines(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects, int noise) {
    }

    public static void drawClouds(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects, int noise) {
    }

    public static void drawSurfaceFeatures(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects, int noise, float life) {
    }

    public static void drawUndergroundFeatures(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects, int noise, float life) {
    }

    public static void drawLeviathanBones(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects, int noise) {
    }

    public static int getAvg(double[] array) {
        long x = 0L;
        for (double v : array) {
            x += (long)v;
        }
        return (int)(x /= (long)array.length);
    }

    public static void drawPockets(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects, int noise) {
        int numPockets = data.radius * data.radius * data.radius / 200;
        HashMap<Aspect, Double> probabilities = new HashMap<Aspect, Double>();
        if (aspects.getAmount(Aspect.EARTH) > 0) {
            probabilities.put(Aspect.EARTH, PocketPlaneData.aspectFraction(Aspect.EARTH, aspects));
        }
        if (aspects.getAmount(Aspect.FIRE) > 0) {
            probabilities.put(Aspect.FIRE, PocketPlaneData.aspectFraction(Aspect.FIRE, aspects));
        }
        if (aspects.getAmount(Aspect.ORDER) > 0) {
            probabilities.put(Aspect.ORDER, PocketPlaneData.aspectFraction(Aspect.ORDER, aspects));
        }
        if (aspects.getAmount(Aspect.AIR) > 0) {
            probabilities.put(Aspect.AIR, PocketPlaneData.aspectFraction(Aspect.AIR, aspects));
        }
        if (aspects.getAmount(Aspect.WATER) > 0) {
            probabilities.put(Aspect.WATER, PocketPlaneData.aspectFraction(Aspect.WATER, aspects));
        }
        if (aspects.getAmount(Aspect.ENTROPY) > 0) {
            probabilities.put(Aspect.ENTROPY, PocketPlaneData.aspectFraction(Aspect.ENTROPY, aspects));
        }
        if (aspects.getAmount(Aspect.METAL) > 0) {
            probabilities.put(Aspect.METAL, PocketPlaneData.aspectFraction(Aspect.METAL, aspects));
        }
        if (aspects.getAmount(Aspect.CRYSTAL) > 0) {
            probabilities.put(Aspect.CRYSTAL, PocketPlaneData.aspectFraction(Aspect.CRYSTAL, aspects));
        }
        if (aspects.getAmount(Aspect.SOUL) > 0) {
            probabilities.put(Aspect.SOUL, PocketPlaneData.aspectFraction(Aspect.SOUL, aspects));
        }
        if (aspects.getAmount(Aspect.MAGIC) > 0) {
            probabilities.put(Aspect.MAGIC, PocketPlaneData.aspectFraction(Aspect.MAGIC, aspects));
        }
        if (aspects.getAmount(Aspect.AURA) > 0) {
            probabilities.put(Aspect.AURA, PocketPlaneData.aspectFraction(Aspect.AURA, aspects));
        }
        if (aspects.getAmount(Aspect.ENERGY) > 0) {
            probabilities.put(Aspect.ENERGY, PocketPlaneData.aspectFraction(Aspect.ENERGY, aspects));
        }
        if (aspects.getAmount(Aspect.TREE) > 0) {
            probabilities.put(Aspect.TREE, PocketPlaneData.aspectFraction(Aspect.TREE, aspects));
        }
        if (aspects.getAmount(Aspect.FLESH) > 0) {
            probabilities.put(Aspect.FLESH, PocketPlaneData.aspectFraction(Aspect.FLESH, aspects));
        }
        if (aspects.getAmount(Aspect.SENSES) > 0) {
            probabilities.put(Aspect.SENSES, PocketPlaneData.aspectFraction(Aspect.SENSES, aspects));
        }
        if (aspects.getAmount(Aspect.MINE) > 0) {
            probabilities.put(Aspect.MINE, PocketPlaneData.aspectFraction(Aspect.MINE, aspects));
        }
        if (aspects.getAmount(Aspect.TOOL) > 0) {
            probabilities.put(Aspect.TOOL, PocketPlaneData.aspectFraction(Aspect.TOOL, aspects));
        }
        if (aspects.getAmount(Aspect.GREED) > 0) {
            probabilities.put(Aspect.GREED, PocketPlaneData.aspectFraction(Aspect.GREED, aspects));
        }
        if (aspects.getAmount(Aspect.TAINT) > 0) {
            probabilities.put(Aspect.TAINT, PocketPlaneData.aspectFraction(Aspect.TAINT, aspects));
        }
        if (aspects.getAmount(Aspect.POISON) > 0) {
            probabilities.put(Aspect.POISON, PocketPlaneData.aspectFraction(Aspect.POISON, aspects));
        }
        if (aspects.getAmount(Aspect.EXCHANGE) > 0) {
            probabilities.put(Aspect.EXCHANGE, PocketPlaneData.aspectFraction(Aspect.EXCHANGE, aspects));
        }
        if (aspects.getAmount(Aspect.MIND) > 0) {
            probabilities.put(Aspect.MIND, PocketPlaneData.aspectFraction(Aspect.MIND, aspects));
        }
        if (aspects.getAmount(Aspect.MAN) > 0) {
            probabilities.put(Aspect.MAN, PocketPlaneData.aspectFraction(Aspect.MAN, aspects));
        }
        if (aspects.getAmount(Aspect.HUNGER) > 0) {
            probabilities.put(Aspect.HUNGER, PocketPlaneData.aspectFraction(Aspect.HUNGER, aspects));
        }
        if (aspects.getAmount(Aspect.CRAFT) > 0) {
            probabilities.put(Aspect.CRAFT, PocketPlaneData.aspectFraction(Aspect.CRAFT, aspects));
        }
        Block block = Blocks.air;
        int md = 0;
        for (int i = 0; i < numPockets; ++i) {
            float which = world.rand.nextFloat();
            Aspect whichAspect = null;
            Iterator it = probabilities.keySet().iterator();
            boolean doDressing = false;
            while (it.hasNext()) {
                whichAspect = (Aspect)it.next();
                if (which <= ((Number)probabilities.get(whichAspect)).floatValue()) {
                    doDressing = true;
                    break;
                }
                which -= ((Number)probabilities.get(whichAspect)).floatValue();
            }
            if (doDressing && whichAspect != null) {
                if (whichAspect == Aspect.EARTH) {
                    block = ConfigBlocks.blockCustomOre;
                    md = 4;
                } else if (whichAspect == Aspect.AIR) {
                    block = ConfigBlocks.blockCustomOre;
                    md = 1;
                } else if (whichAspect == Aspect.WATER) {
                    block = ConfigBlocks.blockCustomOre;
                    md = 3;
                } else if (whichAspect == Aspect.FIRE) {
                    if (world.rand.nextBoolean()) {
                        block = ConfigBlocks.blockCustomOre;
                        md = 2;
                    } else {
                        block = Blocks.lava;
                    }
                } else if (whichAspect == Aspect.ORDER) {
                    block = ConfigBlocks.blockCustomOre;
                    md = 5;
                } else if (whichAspect == Aspect.ENTROPY) {
                    block = ConfigBlocks.blockCustomOre;
                    md = 6;
                } else if (whichAspect == Aspect.METAL) {
                    if ((double)world.rand.nextFloat() <= 0.5) {
                        block = Blocks.iron_ore;
                    } else if ((double)world.rand.nextFloat() <= 0.8) {
                        block = Blocks.gold_ore;
                    } else {
                        block = ConfigBlocks.blockCustomOre;
                        md = 0;
                    }
                } else if (whichAspect == Aspect.MAGIC || whichAspect == Aspect.AURA) {
                    block = ConfigBlocks.blockCustomOre;
                    md = world.rand.nextInt(6) + 1;
                } else if (whichAspect == Aspect.CRYSTAL) {
                    block = Blocks.quartz_block;
                } else if (whichAspect == Aspect.SOUL) {
                    block = Blocks.soul_sand;
                } else if (whichAspect == Aspect.ENERGY) {
                    block = Blocks.redstone_block;
                } else if (whichAspect == Aspect.TREE) {
                    if (world.rand.nextBoolean()) {
                        block = Blocks.log;
                    } else {
                        block = ConfigBlocks.blockCustomOre;
                        md = 7;
                    }
                } else if (whichAspect == Aspect.FLESH) {
                    block = ConfigBlocks.blockTaint;
                    md = 2;
                } else if (whichAspect == Aspect.SENSES) {
                    block = Blocks.lapis_ore;
                } else if (whichAspect == Aspect.MINE || whichAspect == Aspect.TOOL) {
                    float f = world.rand.nextFloat();
                    if (f < 0.4f) {
                        block = Blocks.iron_ore;
                    } else if (f < 0.5f) {
                        block = Blocks.gold_ore;
                    } else if (f < 0.6f) {
                        block = Blocks.diamond_ore;
                    } else if (f < 0.7f) {
                        block = Blocks.emerald_ore;
                    } else if (f < 0.8f) {
                        block = Blocks.lapis_ore;
                    } else {
                        block = ConfigBlocks.blockCustomOre;
                        md = world.rand.nextInt(8);
                    }
                } else if (whichAspect == Aspect.GREED) {
                    float f = world.rand.nextFloat();
                    block = f < 0.4f ? Blocks.gold_ore : (f < 0.6f ? Blocks.diamond_ore : (f < 0.8f ? Blocks.emerald_ore : Blocks.lapis_ore));
                } else if (whichAspect == Aspect.TAINT) {
                    block = ConfigBlocks.blockTaint;
                    md = 0;
                } else if (whichAspect == Aspect.POISON) {
                    block = ConfigBlocks.blockFluidDeath;
                    md = 16;
                } else if (whichAspect == Aspect.EXCHANGE) {
                    block = ConfigBlocks.blockCustomOre;
                    md = 0;
                } else if (whichAspect == Aspect.MIND) {
                    block = world.rand.nextBoolean() ? Blocks.bookshelf : ThaumicHorizons.blockBrain;
                } else if (whichAspect == Aspect.MAN) {
                    int man = world.rand.nextInt(3);
                    if (man == 0) {
                        block = Blocks.bookshelf;
                    } else if (man == 1) {
                        block = ThaumicHorizons.blockBrain;
                    } else {
                        block = ConfigBlocks.blockTaint;
                        md = 2;
                    }
                } else if (whichAspect == Aspect.HUNGER) {
                    block = ConfigBlocks.blockTaint;
                    md = 2;
                } else if (whichAspect == Aspect.CRAFT) {
                    block = Blocks.crafting_table;
                }
            }
            PocketPlaneData.drawAPocket(xCenter, yCenter, zCenter, data, world, aspects, noise, block, md, world.rand.nextInt(3) + 1, world.rand.nextInt(3) + 1, world.rand.nextInt((int)((float)data.radius * 2.0f)) - (int)((float)data.radius * 1.0f), -world.rand.nextInt((int)((float)data.radius * 1.0f)), world.rand.nextInt((int)((float)data.radius * 2.0f)) - (int)((float)data.radius * 1.0f));
        }
    }

    public static void drawAPocket(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects, int noise, Block block, int md, int xSize, int zSize, int xOffset, int yOffset, int zOffset) {
        NoiseGeneratorOctaves noiseGen = new NoiseGeneratorOctaves(world.rand, 10);
        double[] noiseDataTop = null;
        noiseDataTop = noiseGen.generateNoiseOctaves(noiseDataTop, xCenter - xSize + xOffset, yCenter + yOffset, zCenter - zSize + zOffset, xSize, 1, zSize, (double)noise / 50.0, (double)noise / 25.0, (double)noise / 50.0);
        double[] noiseDataBottom = null;
        noiseDataBottom = noiseGen.generateNoiseOctaves(noiseDataBottom, xCenter - xSize + xOffset, yCenter + yOffset, zCenter - zSize + zOffset, xSize, 1, zSize, (double)noise / 50.0, (double)noise / 25.0, (double)noise / 50.0);
        for (int x = 0; x < xSize; ++x) {
            for (int z = 0; z < zSize; ++z) {
                int y;
                int top = (int)(noiseDataTop[x + z * xSize] / 16.0) + 1;
                int bottom = y = (int)(noiseDataBottom[x + z * xSize] / 16.0) - 1;
                while (y < top) {
                    if (!world.isAirBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z) && world.getBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z) != Blocks.water) {
                        world.setBlock(xCenter - xSize + xOffset + x, yCenter + yOffset + y, zCenter - zSize + zOffset + z, block, md, 0);
                    }
                    ++y;
                }
            }
        }
    }

    public static BiomeGenBase setBiome(int xCenter, int yCenter, int zCenter, PocketPlaneData data, World world, AspectList aspects) {
        BiomeGenBase bio = null;
        if (aspects.getAmount(Aspect.TAINT) > 0) {
            bio = ThaumcraftWorldGenerator.biomeTaint;
        } else if (aspects.getAmount(Aspect.ELDRITCH) > 0 || aspects.getAmount(Aspect.UNDEAD) > 0) {
            bio = ThaumcraftWorldGenerator.biomeEerie;
        } else if (aspects.getAmount(Aspect.MAGIC) > 0 || aspects.getAmount(Aspect.AURA) > 0) {
            bio = ThaumcraftWorldGenerator.biomeMagicalForest;
        } else {
            float temp = 0.5f;
            float moist = 0.5f;
            temp = (float)((double)temp + PocketPlaneData.aspectFraction(Aspect.FIRE, aspects));
            temp = (float)((double)temp - PocketPlaneData.aspectFraction(Aspect.WATER, aspects) * 0.5);
            temp = (float)((double)temp - PocketPlaneData.aspectFraction(Aspect.ORDER, aspects) * 0.5);
            temp = (float)((double)temp - PocketPlaneData.aspectFraction(Aspect.VOID, aspects) * 0.5);
            temp = (float)((double)temp + PocketPlaneData.aspectFraction(Aspect.LIGHT, aspects) * 0.5);
            temp = (float)((double)temp - PocketPlaneData.aspectFraction(Aspect.WEATHER, aspects) * 0.25);
            temp = (float)((double)temp + PocketPlaneData.aspectFraction(Aspect.MOTION, aspects) * 0.5);
            temp = (float)((double)temp - PocketPlaneData.aspectFraction(Aspect.COLD, aspects));
            temp = (float)((double)temp + PocketPlaneData.aspectFraction(Aspect.ENERGY, aspects) * 0.5);
            if ((temp = (float)((double)temp - PocketPlaneData.aspectFraction(Aspect.DARKNESS, aspects) * 0.25)) < 0.0f) {
                temp = 0.0f;
            } else if (temp > 1.0f) {
                temp = 1.0f;
            }
            moist = (float)((double)moist + PocketPlaneData.aspectFraction(Aspect.WATER, aspects));
            moist = (float)((double)moist - PocketPlaneData.aspectFraction(Aspect.FIRE, aspects) * 0.5);
            moist = (float)((double)moist - PocketPlaneData.aspectFraction(Aspect.ENTROPY, aspects) * 0.25);
            moist = (float)((double)moist - PocketPlaneData.aspectFraction(Aspect.VOID, aspects) * 0.25);
            moist = (float)((double)moist + PocketPlaneData.aspectFraction(Aspect.WEATHER, aspects) * 0.5);
            moist = (float)((double)moist + PocketPlaneData.aspectFraction(Aspect.SLIME, aspects) * 0.5);
            if (moist < 0.0f) {
                moist = 0.0f;
            } else if (moist > 1.0f) {
                moist = 1.0f;
            }
            bio = (double)temp > 0.8 ? BiomeGenBase.desert : ((double)temp > 0.5 ? ((double)moist < 0.4 ? BiomeGenBase.savanna : BiomeGenBase.jungle) : ((double)temp > 0.2 ? ((double)moist < 0.4 ? BiomeGenBase.plains : BiomeGenBase.forest) : BiomeGenBase.icePlains));
        }
        for (int x = -data.radius; x <= data.radius; ++x) {
            for (int z = -data.radius; z <= data.radius; ++z) {
                Utils.setBiomeAt((World)world, (int)(x + xCenter), (int)(z + zCenter), (BiomeGenBase)bio);
            }
        }
        return bio;
    }

    public static void drawCircle(int x0, int y0, int z0, int y1, int radius, int error0, Block block, int md, World world) {
        int x = radius;
        int radiusError = error0;
        for (int z = 0; x >= z; ++z) {
            world.setBlock(x0 + x, y0 + y1, z0 + z, block, md, 0);
            world.setBlock(x0 + z, y0 + y1, z0 + x, block, md, 0);
            world.setBlock(x0 - x, y0 + y1, z0 + z, block, md, 0);
            world.setBlock(x0 - z, y0 + y1, z0 + x, block, md, 0);
            world.setBlock(x0 - x, y0 + y1, z0 - z, block, md, 0);
            world.setBlock(x0 - z, y0 + y1, z0 - x, block, md, 0);
            world.setBlock(x0 + x, y0 + y1, z0 - z, block, md, 0);
            world.setBlock(x0 + z, y0 + y1, z0 - x, block, md, 0);
            world.setBlock(x0 + x, y0 - y1, z0 + z, block, md, 0);
            world.setBlock(x0 + z, y0 - y1, z0 + x, block, md, 0);
            world.setBlock(x0 - x, y0 - y1, z0 + z, block, md, 0);
            world.setBlock(x0 - z, y0 - y1, z0 + x, block, md, 0);
            world.setBlock(x0 - x, y0 - y1, z0 - z, block, md, 0);
            world.setBlock(x0 - z, y0 - y1, z0 - x, block, md, 0);
            world.setBlock(x0 + x, y0 - y1, z0 - z, block, md, 0);
            world.setBlock(x0 + z, y0 - y1, z0 - x, block, md, 0);
            world.setBlock(x0 + y1, y0 + x, z0 + z, block, md, 0);
            world.setBlock(x0 + z, y0 + x, z0 + y1, block, md, 0);
            world.setBlock(x0 - y1, y0 + x, z0 + z, block, md, 0);
            world.setBlock(x0 - z, y0 + x, z0 + y1, block, md, 0);
            world.setBlock(x0 + y1, y0 + x, z0 - z, block, md, 0);
            world.setBlock(x0 + z, y0 + x, z0 - y1, block, md, 0);
            world.setBlock(x0 - y1, y0 + x, z0 - z, block, md, 0);
            world.setBlock(x0 - z, y0 + x, z0 - y1, block, md, 0);
            world.setBlock(x0 + y1, y0 - x, z0 + z, block, md, 0);
            world.setBlock(x0 + z, y0 - x, z0 + y1, block, md, 0);
            world.setBlock(x0 - y1, y0 - x, z0 + z, block, md, 0);
            world.setBlock(x0 - z, y0 - x, z0 + y1, block, md, 0);
            world.setBlock(x0 + y1, y0 - x, z0 - z, block, md, 0);
            world.setBlock(x0 + z, y0 - x, z0 - y1, block, md, 0);
            world.setBlock(x0 - y1, y0 - x, z0 - z, block, md, 0);
            world.setBlock(x0 - z, y0 - x, z0 - y1, block, md, 0);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    public static void drawSphere(int x0, int y0, int z0, int radius, Block block, int md, World world) {
        int x = radius;
        int radiusError = 1 - x;
        for (int y = 0; x >= y; ++y) {
            PocketPlaneData.drawCircle(x0, y0, z0, y, x, radiusError, block, md, world);
            if (radiusError < 0) {
                radiusError += 2 * y + 1;
                continue;
            }
            radiusError += 2 * (y - --x + 1);
        }
    }

    public static void loadPocketPlanes(World world) {
        File planeFile = new File(world.getSaveHandler().getWorldDirectory(), "pocketplane.dat");
        NBTTagCompound root = null;
        if (planeFile.exists()) {
            try {
                root = CompressedStreamTools.readCompressed((InputStream)new FileInputStream(planeFile));
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if (root != null) {
                planes.clear();
                NBTTagList planeNBT = root.getTagList("Data", 10);
                pocketPlaneMAXID = root.getInteger("MaxID");
                for (int i = 0; i < planeNBT.tagCount(); ++i) {
                    NBTTagCompound thePlane = planeNBT.getCompoundTagAt(i);
                    PocketPlaneData data = new PocketPlaneData();
                    data.radius = thePlane.getInteger("radius");
                    data.potionEffects = thePlane.getIntArray("effects");
                    data.name = thePlane.getString("name");
                    data.color = thePlane.getInteger("color");
                    data.portalA = thePlane.getIntArray("portalA");
                    data.portalB = thePlane.getIntArray("portalB");
                    data.portalC = thePlane.getIntArray("portalC");
                    data.portalD = thePlane.getIntArray("portalD");
                    planes.add(data);
                }
                NBTTagCompound positionz = root.getCompoundTag("Positions");
                positions.clear();
                Set keySet = positionz.func_150296_c();
                for (String id : keySet) {
                    positions.put(Integer.valueOf(id), Vec3.createVectorHelper((double)positionz.getIntArray(id)[0], (double)positionz.getIntArray(id)[1], (double)positionz.getIntArray(id)[2]));
                }
            }
        }
    }

    public static void savePocketPlanes(World world) {
        File planeFile = new File(world.getSaveHandler().getWorldDirectory(), "pocketplane.dat");
        NBTTagCompound root = new NBTTagCompound();
        NBTTagCompound positionz = new NBTTagCompound();
        for (Map.Entry<Integer, Vec3> entry : positions.entrySet()) {
            positionz.setIntArray(entry.getKey().toString(), new int[]{(int)entry.getValue().xCoord, (int)entry.getValue().yCoord, (int)entry.getValue().zCoord});
        }
        root.setInteger("MaxID", pocketPlaneMAXID);
        root.setTag("Positions", (NBTBase)positionz);
        NBTTagList planeNBT = new NBTTagList();
        root.setTag("Data", (NBTBase)planeNBT);
        for (PocketPlaneData data : planes) {
            if (data == null) continue;
            NBTTagCompound thePlane = new NBTTagCompound();
            thePlane.setInteger("radius", data.radius);
            thePlane.setIntArray("effects", data.potionEffects);
            thePlane.setString("name", data.name);
            thePlane.setInteger("color", data.color);
            thePlane.setIntArray("portalA", data.portalA);
            thePlane.setIntArray("portalB", data.portalB);
            thePlane.setIntArray("portalC", data.portalC);
            thePlane.setIntArray("portalD", data.portalD);
            planeNBT.appendTag((NBTBase)thePlane);
        }
        try {
            CompressedStreamTools.writeCompressed((NBTTagCompound)root, (OutputStream)new FileOutputStream(planeFile));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static int firstAvailablePortal(int num) {
        PocketPlaneData data = planes.get(num);
        if (data.portalA[0] == 0 && data.portalA[1] == 0 && data.portalA[2] == 0) {
            return 1;
        }
        if (data.portalB[0] == 0 && data.portalB[1] == 0 && data.portalB[2] == 0) {
            return 2;
        }
        if (data.portalC[0] == 0 && data.portalC[1] == 0 && data.portalC[2] == 0) {
            return 3;
        }
        if (data.portalD[0] == 0 && data.portalD[1] == 0 && data.portalD[2] == 0) {
            return 4;
        }
        return 0;
    }

    public static void destroyPortal(int id, int which) {
        PocketPlaneData data = planes.get(id);
        WorldServer world = MinecraftServer.getServer().worldServerForDimension(ThaumicHorizons.dimensionPocketId);
        if (which == 1) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = 126; y <= 128; ++y) {
                    world.setBlock(x, y, 256 * id + data.radius, ThaumicHorizons.blockVoid);
                }
            }
            data.portalA[0] = 0;
            data.portalA[1] = 0;
            data.portalA[2] = 0;
        } else if (which == 2) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = 126; y <= 128; ++y) {
                    world.setBlock(x, y, 256 * id - data.radius, ThaumicHorizons.blockVoid);
                }
            }
            data.portalB[0] = 0;
            data.portalB[1] = 0;
            data.portalB[2] = 0;
        } else if (which == 3) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 126; y <= 128; ++y) {
                    world.setBlock(data.radius, y, 256 * id + z, ThaumicHorizons.blockVoid);
                }
            }
            data.portalC[0] = 0;
            data.portalC[1] = 0;
            data.portalC[2] = 0;
        } else if (which == 4) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 126; y <= 128; ++y) {
                    world.setBlock(-data.radius, y, 256 * id + z, ThaumicHorizons.blockVoid);
                }
            }
            data.portalD[0] = 0;
            data.portalD[1] = 0;
            data.portalD[2] = 0;
        }
    }

    public static void makePortal(int id, int which, int xCoord, int yCoord, int zCoord) {
        PocketPlaneData data = planes.get(id);
        WorldServer world = MinecraftServer.getServer().worldServerForDimension(ThaumicHorizons.dimensionPocketId);
        if (which == 1) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = 126; y <= 128; ++y) {
                    world.setBlock(x, y, 256 * id + data.radius, ThaumicHorizons.blockPortal, 0, 3);
                    world.setBlock(x, y, 256 * id + data.radius + 1, ThaumicHorizons.blockVoid);
                }
            }
            data.portalA[0] = xCoord;
            data.portalA[1] = yCoord;
            data.portalA[2] = zCoord;
        } else if (which == 2) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = 126; y <= 128; ++y) {
                    world.setBlock(x, y, 256 * id - data.radius, ThaumicHorizons.blockPortal, 2, 3);
                    world.setBlock(x, y, 256 * id - data.radius - 1, ThaumicHorizons.blockVoid);
                }
            }
            data.portalB[0] = xCoord;
            data.portalB[1] = yCoord;
            data.portalB[2] = zCoord;
        } else if (which == 3) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 126; y <= 128; ++y) {
                    world.setBlock(data.radius, y, 256 * id + z, ThaumicHorizons.blockPortal, 1, 3);
                    world.setBlock(data.radius + 1, y, 256 * id + z, ThaumicHorizons.blockVoid);
                }
            }
            data.portalC[0] = xCoord;
            data.portalC[1] = yCoord;
            data.portalC[2] = zCoord;
        } else if (which == 4) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 126; y <= 128; ++y) {
                    world.setBlock(-data.radius, y, 256 * id + z, ThaumicHorizons.blockPortal, 3, 3);
                    world.setBlock(-data.radius - 1, y, 256 * id + z, ThaumicHorizons.blockVoid);
                }
            }
            data.portalD[0] = xCoord;
            data.portalD[1] = yCoord;
            data.portalD[2] = zCoord;
        }
    }

    void buildStructure(int x, int y, int z, Structure struct) {
    }

    static {
        planes = new LinkedList();
        positions = new HashMap();
    }

    private static class Structure {
        public int x;
        public int y;
        public int z;
        public Block[] blocks;
        public int[] meta;

        public Structure(int x, int y, int z, Block[] blocks, int[] meta) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.blocks = blocks;
            this.meta = meta;
        }
    }
}

