/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.tiles;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.WorldCoordinates;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.visnet.TileVisNode;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.common.lib.research.ResearchManager;

public class TileEssentiaDynamo
extends TileVisNode
implements IAspectContainer,
IEssentiaTransport {
    AspectList primalsActuallyProvided = new AspectList();
    AspectList primalsProvided = new AspectList();
    public Aspect essentia = null;
    public int ticksProvided = 0;
    public float rise = 0.0f;
    public float rotation = 0.0f;
    public float rotation2 = 0.0f;

    public AspectList getAspects() {
        if (this.primalsProvided.getAspects().length > 0 && this.primalsProvided.getAspects()[0] != null) {
            return this.primalsProvided;
        }
        return null;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        return 0;
    }

    public int getRange() {
        return 0;
    }

    public boolean isSource() {
        return this.ticksProvided > 0;
    }

    public int consumeVis(Aspect aspect, int amount) {
        int drain = Math.min(this.primalsActuallyProvided.getAmount(aspect), amount);
        if (drain > 0) {
            this.primalsActuallyProvided.reduce(aspect, drain);
        }
        return drain;
    }

    public boolean isConnectable(ForgeDirection face) {
        return face == ForgeDirection.DOWN;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return face == ForgeDirection.DOWN;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection face) {
        if (this.ticksProvided <= 20) {
            return 128;
        }
        return 0;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        this.ticksProvided += 21;
        this.essentia = aspect;
        VisNetHandler.sources.computeIfAbsent(this.worldObj.provider.dimensionId, k -> new HashMap());
        if (((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).get(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId)) == null) {
            ((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).put(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId), new WeakReference<TileEssentiaDynamo>(this));
        } else if (((WeakReference)((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).get(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId))).get() == null) {
            ((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).remove(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId));
            ((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).put(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId), new WeakReference<TileEssentiaDynamo>(this));
        }
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        return 1;
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return this.essentia;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return 0;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.ticksProvided >= 0) {
            if (this.rise < 0.3f) {
                this.rise += 0.02f;
            } else {
                this.rotation2 += 2.0f;
                if (this.rotation2 >= 360.0f) {
                    this.rotation2 -= 360.0f;
                }
            }
            this.rotation += 2.0f;
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
            }
        } else if (this.ticksProvided < 0 && (this.rise > 0.0f || this.rotation2 != 0.0f)) {
            if (this.rotation2 > 0.0f) {
                this.rotation2 -= 8.0f;
                if (this.rotation2 < 0.0f) {
                    this.rotation2 = 0.0f;
                }
            } else if (this.rise > 0.0f) {
                this.rise -= 0.02f;
            }
        }
        if (this.ticksProvided > 0) {
            this.primalsProvided = ResearchManager.reduceToPrimals((AspectList)new AspectList().add(this.essentia, 1));
            int numEach = 12 / this.primalsProvided.size();
            for (Aspect asp : this.primalsProvided.getAspects()) {
                int num = this.primalsProvided.getAmount(asp);
                if (num > numEach) {
                    this.primalsProvided.reduce(asp, num - numEach);
                    continue;
                }
                if (num >= numEach) continue;
                this.primalsProvided.add(asp, numEach - num);
            }
            this.primalsActuallyProvided = this.primalsProvided.copy();
            --this.ticksProvided;
            if (!this.worldObj.isRemote) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.markDirty();
            }
        } else if (this.ticksProvided == 0) {
            if (!this.worldObj.isRemote && !this.drawEssentia() && VisNetHandler.sources.get(this.worldObj.provider.dimensionId) != null) {
                --this.ticksProvided;
                this.killMe();
                this.primalsProvided = new AspectList();
                this.primalsActuallyProvided = new AspectList();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.markDirty();
            }
        } else if (!this.worldObj.isRemote && this.ticksProvided < 0) {
            this.drawEssentia();
        }
    }

    public void killMe() {
        if (VisNetHandler.sources != null && this.worldObj != null && this.worldObj.provider != null && VisNetHandler.sources.get(this.worldObj.provider.dimensionId) != null) {
            ((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).remove(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId));
            this.removeThisNode();
        }
    }

    boolean drawEssentia() {
        TileEntity te = ThaumcraftApiHelper.getConnectableTile((World)this.worldObj, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord, (ForgeDirection)ForgeDirection.DOWN);
        if (te != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(ForgeDirection.UP)) {
                return false;
            }
            Aspect ta = null;
            if (ic.getEssentiaAmount(ForgeDirection.UP) > 0 && ic.getSuctionAmount(ForgeDirection.UP) < this.getSuctionAmount(ForgeDirection.DOWN) && this.getSuctionAmount(ForgeDirection.DOWN) >= ic.getMinimumSuction()) {
                ta = ic.getEssentiaType(ForgeDirection.UP);
            }
            if (ta != null && ic.takeEssentia(ta, 1, ForgeDirection.UP) == 1) {
                this.addEssentia(ta, 1, ForgeDirection.DOWN);
                return true;
            }
        }
        return false;
    }

    public void debug() {
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        if (this.essentia != null) {
            nbttagcompound.setString("key", this.essentia.getTag());
        }
        nbttagcompound.setInteger("ticks", this.ticksProvided);
        NBTTagList tlist = new NBTTagList();
        nbttagcompound.setTag("AspectsProvided", (NBTBase)tlist);
        for (Aspect aspect : this.primalsProvided.getAspects()) {
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.setString("key", aspect.getTag());
            f.setInteger("amount", this.primalsProvided.getAmount(aspect));
            tlist.appendTag((NBTBase)f);
        }
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.essentia = Aspect.getAspect((String)nbttagcompound.getString("key"));
        this.ticksProvided = nbttagcompound.getInteger("ticks");
        AspectList al = new AspectList();
        NBTTagList tlist = nbttagcompound.getTagList("AspectsProvided", 10);
        for (int j = 0; j < tlist.tagCount(); ++j) {
            NBTTagCompound rs = tlist.getCompoundTagAt(j);
            if (!rs.hasKey("key")) continue;
            al.add(Aspect.getAspect((String)rs.getString("key")), rs.getInteger("amount"));
        }
        this.primalsProvided = al.copy();
        this.primalsActuallyProvided = this.primalsProvided.copy();
        if (this.ticksProvided < 0) {
            this.killMe();
        }
    }
}

