/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.tiles;

import com.kentington.thaumichorizons.common.tiles.ISoulReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.common.config.ConfigItems;

public class TileInspiratron
extends TileThaumcraft
implements ISoulReceiver,
ISidedInventory {
    public ItemStack paper;
    public ItemStack knowledge;
    public int progress;
    private final int PROGRESS_MAX = 100;
    public float rota;
    public float rotb;
    public float field_40063_b;
    public float field_40061_d;
    public float field_40059_f;
    public float field_40066_q;

    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            float f4;
            EntityPlayer entity = null;
            this.rotb = this.rota;
            if (entity == null) {
                entity = this.worldObj.getClosestPlayer((double)((float)this.xCoord + 0.5f), (double)((float)this.yCoord + 0.5f), (double)((float)this.zCoord + 0.5f), 6.0);
            }
            if (entity != null) {
                double d = entity.posX - (double)((float)this.xCoord + 0.5f);
                double d2 = entity.posZ - (double)((float)this.zCoord + 0.5f);
                this.field_40066_q = (float)Math.atan2(d2, d);
                this.field_40059_f += 0.1f;
                if (this.field_40059_f < 0.5f || entity.worldObj.rand.nextInt(40) == 0) {
                    float f3 = this.field_40061_d;
                    do {
                        this.field_40061_d += (float)(entity.worldObj.rand.nextInt(4) - entity.worldObj.rand.nextInt(4));
                    } while (f3 == this.field_40061_d);
                }
            } else {
                this.field_40066_q += 0.01f;
            }
            while (this.rota >= (float)Math.PI) {
                this.rota -= (float)Math.PI * 2;
            }
            while (this.rota < (float)(-Math.PI)) {
                this.rota += (float)Math.PI * 2;
            }
            while (this.field_40066_q >= (float)Math.PI) {
                this.field_40066_q -= (float)Math.PI * 2;
            }
            while (this.field_40066_q < (float)(-Math.PI)) {
                this.field_40066_q += (float)Math.PI * 2;
            }
            for (f4 = this.field_40066_q - this.rota; f4 < (float)(-Math.PI); f4 += (float)Math.PI * 2) {
            }
            this.rota += f4 * 0.04f;
        }
    }

    @Override
    public void addSoulBits(int bits) {
        for (int i = 0; i < bits; ++i) {
            if (!(Math.random() >= 0.97)) continue;
            this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "thaumcraft:write", 0.2f, this.worldObj.rand.nextFloat());
            ++this.progress;
        }
        if (this.progress >= 100) {
            this.progress -= 100;
            if (this.knowledge == null) {
                this.knowledge = new ItemStack(ConfigItems.itemResource, 1, 9);
            } else {
                ItemStack knowledge = this.knowledge;
                ++knowledge.stackSize;
            }
            ItemStack paper = this.paper;
            --paper.stackSize;
            if (this.paper.stackSize <= 0) {
                this.paper = null;
            }
        }
    }

    @Override
    public boolean canAcceptSouls() {
        return this.paper != null && this.paper.stackSize > 0 && (this.knowledge == null || this.knowledge.stackSize < 64);
    }

    public int getSizeInventory() {
        return 2;
    }

    public ItemStack getStackInSlot(int p_70301_1_) {
        if (p_70301_1_ == 0) {
            return this.paper;
        }
        if (p_70301_1_ == 1) {
            return this.knowledge;
        }
        return null;
    }

    public ItemStack decrStackSize(int p_70298_1_, int p_70298_2_) {
        if (p_70298_1_ == 0) {
            int oldsize = this.paper.stackSize;
            ItemStack paper = this.paper;
            paper.stackSize -= p_70298_2_;
            if (this.paper.stackSize <= 0) {
                this.paper = null;
            }
            return new ItemStack(Items.paper, Math.min(p_70298_2_, oldsize));
        }
        if (p_70298_1_ == 1) {
            int oldsize = this.knowledge.stackSize;
            ItemStack knowledge = this.knowledge;
            knowledge.stackSize -= p_70298_2_;
            if (this.knowledge.stackSize <= 0) {
                this.knowledge = null;
            }
            return new ItemStack(ConfigItems.itemResource, Math.min(p_70298_2_, oldsize), 9);
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int p_70304_1_) {
        return null;
    }

    public void setInventorySlotContents(int p_70299_1_, ItemStack p_70299_2_) {
        if (p_70299_1_ == 0) {
            this.paper = p_70299_2_;
        } else if (p_70299_1_ == 1) {
            this.knowledge = p_70299_2_;
        }
    }

    public String getInventoryName() {
        return "container.inspiratron";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer p_70300_1_) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this && p_70300_1_.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int p_94041_1_, ItemStack p_94041_2_) {
        if (p_94041_1_ == 0) {
            return p_94041_2_.isItemEqual(new ItemStack(Items.paper));
        }
        return p_94041_1_ == 1 && p_94041_2_.isItemEqual(new ItemStack(ConfigItems.itemResource, 1, 9));
    }

    public int[] getAccessibleSlotsFromSide(int p_94128_1_) {
        return new int[]{0, 1};
    }

    public boolean canInsertItem(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return p_102007_1_ != 1 && this.isItemValidForSlot(p_102007_1_, p_102007_2_);
    }

    public boolean canExtractItem(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return p_102008_1_ == 1 && this.knowledge != null;
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.setInteger("progress", this.progress);
        NBTTagList nbttaglist = new NBTTagList();
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        if (this.paper != null) {
            this.paper.writeToNBT(nbttagcompound2);
        }
        nbttaglist.appendTag((NBTBase)nbttagcompound2);
        NBTTagCompound nbttagcompound3 = new NBTTagCompound();
        if (this.knowledge != null) {
            this.knowledge.writeToNBT(nbttagcompound3);
        }
        nbttaglist.appendTag((NBTBase)nbttagcompound3);
        nbttagcompound.setTag("Items", (NBTBase)nbttaglist);
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.progress = nbttagcompound.getInteger("progress");
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items", 10);
        NBTTagCompound nbttagcompound2 = nbttaglist.getCompoundTagAt(0);
        this.paper = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound2);
        nbttagcompound2 = nbttaglist.getCompoundTagAt(1);
        this.knowledge = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound2);
    }

    @SideOnly(value=Side.CLIENT)
    public int getTimeRemainingScaled(int p_145955_1_) {
        int n = this.progress * p_145955_1_;
        this.getClass();
        return n / 100;
    }
}

