/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.client.fx;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;

public class FXSonic
extends EntityFX {
    float yaw = 0.0f;
    float pitch = 0.0f;
    public static IModelCustom model;
    private static final ResourceLocation MODEL;

    public FXSonic(World world, double d, double d1, double d2, int age, int dir) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.particleRed = 0.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.particleGravity = 0.0f;
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.particleMaxAge = age + this.rand.nextInt(age / 2);
        this.noClip = false;
        this.setSize(0.01f, 0.01f);
        this.noClip = true;
        this.particleScale = 1.0f;
        switch (dir) {
            case 0: {
                this.pitch = 90.0f;
                break;
            }
            case 1: {
                this.pitch = -90.0f;
                break;
            }
            case 2: {
                this.yaw = 180.0f;
                break;
            }
            case 3: {
                this.yaw = 0.0f;
                break;
            }
            case 4: {
                this.yaw = 90.0f;
                break;
            }
            case 5: {
                this.yaw = 270.0f;
            }
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        tessellator.draw();
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        if (model == null) {
            model = AdvancedModelLoader.loadModel((ResourceLocation)MODEL);
        }
        float fade = ((float)this.particleAge + f) / (float)this.particleMaxAge;
        float xx = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f - interpPosX);
        float yy = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f - interpPosY);
        float zz = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - interpPosZ);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        float b = 1.0f;
        int frame = Math.min(15, (int)(14.0f * fade) + 1);
        UtilsFX.bindTexture((String)("textures/models/ripple" + frame + ".png"));
        b = 0.5f;
        int i = 220;
        int j = 220;
        boolean k = false;
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)220.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScaled((double)0.5, (double)0.5, (double)-0.5);
        GL11.glColor4f((float)0.0f, (float)b, (float)b, (float)1.0f);
        model.renderAll();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        Minecraft.getMinecraft().renderEngine.bindTexture(UtilsFX.getParticleTexture());
        tessellator.startDrawingQuads();
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
    }

    static {
        MODEL = new ResourceLocation("thaumcraft", "textures/models/hemis.obj");
    }
}

