/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.client.renderer.entity;

import com.kentington.thaumichorizons.client.renderer.model.ModelGolemTH;
import com.kentington.thaumichorizons.common.entities.EntityGolemTH;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.renderers.entity.RenderGolemBase;
import thaumcraft.client.renderers.models.entities.ModelGolemAccessories;
import thaumcraft.common.config.ConfigItems;

public class RenderGolemTH
extends RenderGolemBase {
    ResourceLocation voidGolem = new ResourceLocation("thaumichorizons", "textures/models/golem_void.png");
    ModelBase damage;
    ModelBase accessories = new ModelGolemAccessories(0.0f, 30.0f);

    public RenderGolemTH(ModelBase arg0) {
        super(arg0);
        if (arg0 instanceof ModelGolemTH) {
            ModelGolemTH mg = new ModelGolemTH(false);
            mg.pass = 2;
            this.damage = mg;
        }
    }

    protected ResourceLocation getEntityTexture(Entity entity) {
        if (entity instanceof EntityGolemTH) {
            EntityGolemTH golem = (EntityGolemTH)entity;
            if (golem.texture == null && golem.blocky != null && golem.blocky != Blocks.air) {
                golem.loadTexture();
            } else if (golem.texture == null) {
                return this.voidGolem;
            }
            return golem.texture;
        }
        return null;
    }

    public void render(EntityGolemTH e, double par2, double par4, double par6, float par8, float par9) {
        super.doRender((EntityLiving)e, par2, par4, par6, par8, par9);
    }

    public void doRender(EntityLiving par1EntityLiving, double par2, double par4, double par6, float par8, float par9) {
        this.render((EntityGolemTH)par1EntityLiving, par2, par4, par6, par8, par9);
    }

    public void doRender(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        this.render((EntityGolemTH)par1Entity, par2, par4, par6, par8, par9);
    }

    protected int shouldRenderPass(EntityLivingBase entity, int pass, float par3) {
        if (pass == 0) {
            String deco = ((EntityGolemTH)entity).getGolemDecoration();
            if (((EntityGolemTH)entity).getCore() > -1) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0875f, (float)-0.96f, (float)(0.15f + (deco.contains("P") ? 0.03f : 0.0f)));
                GL11.glScaled((double)0.175, (double)0.175, (double)0.175);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                Tessellator tessellator = Tessellator.instance;
                IIcon icon = ConfigItems.itemGolemCore.getIconFromDamage((int)((EntityGolemTH)entity).getCore());
                float f1 = icon.getMaxU();
                float f2 = icon.getMinV();
                float f3 = icon.getMinU();
                float f4 = icon.getMaxV();
                this.renderManager.renderEngine.bindTexture(TextureMap.locationItemsTexture);
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)f1, (float)f2, (float)f3, (float)f4, (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.2f);
                GL11.glPopMatrix();
            }
            int upgrades = ((EntityGolemTH)entity).upgrades.length;
            float shift = 0.08f;
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            for (int a = 0; a < upgrades; ++a) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(-0.05f - 0.08f * (float)(upgrades - 1) / 2.0f + 0.08f * (float)a), (float)-1.106f, (float)0.099f);
                GL11.glScaled((double)0.1, (double)0.1, (double)0.1);
                Tessellator tessellator2 = Tessellator.instance;
                IIcon icon2 = ConfigItems.itemGolemUpgrade.getIconFromDamage((int)((EntityGolemTH)entity).getUpgrade(a));
                float f5 = icon2.getMaxU();
                float f6 = icon2.getMinV();
                float f7 = icon2.getMinU();
                float f8 = icon2.getMaxV();
                this.renderManager.renderEngine.bindTexture(TextureMap.locationItemsTexture);
                tessellator2.startDrawingQuads();
                tessellator2.setNormal(0.0f, 0.0f, 1.0f);
                tessellator2.addVertexWithUV(0.0, 0.0, 0.0, (double)f5, (double)f8);
                tessellator2.addVertexWithUV(1.0, 0.0, 0.0, (double)f7, (double)f8);
                tessellator2.addVertexWithUV(1.0, 1.0, 0.0, (double)f7, (double)f6);
                tessellator2.addVertexWithUV(0.0, 1.0, 0.0, (double)f5, (double)f6);
                tessellator2.draw();
                GL11.glPopMatrix();
            }
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        } else {
            if (pass == 1 && (((EntityGolemTH)entity).getGolemDecoration().length() > 0 || ((EntityGolemTH)entity).advanced)) {
                UtilsFX.bindTexture((String)"textures/models/golem_decoration.png");
                this.setRenderPassModel(this.accessories);
                return 1;
            }
            if (pass == 2 && ((EntityGolemTH)entity).getHealthPercentage() < 1.0f) {
                UtilsFX.bindTexture((String)"textures/models/golem_damage.png");
                this.setRenderPassModel(this.damage);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - ((EntityGolemTH)entity).getHealthPercentage()));
                return 2;
            }
        }
        return -1;
    }
}

