/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.entities;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class EntityEndersteed
extends EntityHorse {
    boolean initialized = false;

    public EntityEndersteed(World p_i1685_1_) {
        super(p_i1685_1_);
    }

    public void readEntityFromNBT(NBTTagCompound p_70037_1_) {
        super.readEntityFromNBT(p_70037_1_);
        this.initialized = p_70037_1_.getBoolean("initialized");
        if (!this.initialized) {
            HashMultimap map = HashMultimap.create();
            map.put((Object)"generic.movementSpeed", (Object)new AttributeModifier("generic.movementSpeed", 0.1, 1));
            map.put((Object)"horse.jumpStrength", (Object)new AttributeModifier("horse.jumpStrength", 0.25, 1));
            map.put((Object)"generic.maxHealth", (Object)new AttributeModifier("generic.maxHealth", 4.0, 1));
            this.getAttributeMap().applyAttributeModifiers((Multimap)map);
            this.initialized = true;
        }
    }

    public void writeEntityToNBT(NBTTagCompound p_70014_1_) {
        super.writeEntityToNBT(p_70014_1_);
        p_70014_1_.setBoolean("initialized", this.initialized);
    }

    public void setJumpPower(int p_110206_1_) {
        double blocks = (double)p_110206_1_ / 7.0;
        this.teleportTo(this.posX - blocks * Math.sin(Math.toRadians(this.rotationYaw)), this.posY, this.posZ + blocks * Math.cos(Math.toRadians(this.rotationYaw)));
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.ThaumicHorizons.Endersteed.name");
    }

    protected boolean teleportTo(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, p_70825_1_, p_70825_3_, p_70825_5_, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = this.posX;
        double d4 = this.posY;
        double d5 = this.posZ;
        this.posX = event.targetX;
        this.posY = MathHelper.floor_double((double)event.targetY) - 3;
        this.posZ = event.targetZ;
        boolean flag = false;
        int i = MathHelper.floor_double((double)this.posX);
        int j = MathHelper.floor_double((double)this.posY);
        int k = MathHelper.floor_double((double)this.posZ);
        boolean foundGround = false;
        boolean foundAir = false;
        while (!(foundGround && foundAir || !((double)j < d4 + 4.0))) {
            Block block = this.worldObj.getBlock(i, j - 1, k);
            if (block.getMaterial().blocksMovement()) {
                foundGround = true;
            } else if (!foundGround) {
                ++j;
                this.posY += 1.0;
            }
            if (foundGround) {
                this.setPosition(this.posX, this.posY, this.posZ);
                if (this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox)) {
                    flag = true;
                    foundAir = true;
                }
            }
            ++j;
            this.posY += 1.0;
        }
        this.setPosition(this.posX, this.posY, this.posZ);
        if (!flag) {
            this.setPosition(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < 128; ++l) {
            double d6 = (double)l / 127.0;
            float f = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f3 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.posX - d3) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            double d8 = d4 + (this.posY - d4) * d6 + this.rand.nextDouble() * (double)this.height;
            double d9 = d5 + (this.posZ - d5) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            this.worldObj.spawnParticle("portal", d7, d8, d9, (double)f, (double)f2, (double)f3);
        }
        this.worldObj.playSoundEffect(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.playSound("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }
}

