/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.entities;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntityEndersteed;
import com.kentington.thaumichorizons.common.lib.NightmareTeleporter;
import com.kentington.thaumichorizons.common.lib.networking.PacketHandler;
import com.kentington.thaumichorizons.common.lib.networking.PacketMountNightmare;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityNightmare
extends EntityEndersteed {
    NightmareTeleporter nightmareTeleporterOverworld;
    NightmareTeleporter nightmareTeleporterNether;

    public EntityNightmare(World p_i1685_1_) {
        super(p_i1685_1_);
        this.isImmuneToFire = true;
        if (!p_i1685_1_.isRemote) {
            this.nightmareTeleporterOverworld = new NightmareTeleporter(MinecraftServer.getServer().worldServerForDimension(0));
            this.nightmareTeleporterNether = new NightmareTeleporter(MinecraftServer.getServer().worldServerForDimension(-1));
        }
    }

    @Override
    public void setJumpPower(int p_110206_1_) {
        double blocks = (double)p_110206_1_ / 7.0;
        if (p_110206_1_ < 90 || this.worldObj.provider.dimensionId != 0 && this.worldObj.provider.dimensionId != -1) {
            this.teleportTo(this.posX - blocks * Math.sin(Math.toRadians(this.rotationYaw)), this.posY, this.posZ + blocks * Math.cos(Math.toRadians(this.rotationYaw)));
        } else if (this.dimension == 0 || this.dimension == -1) {
            if (this.dimension == 0) {
                this.netherport(-1);
            } else {
                this.netherport(0);
            }
        }
    }

    private void netherport(int dim) {
        Entity newNightmare;
        this.worldObj.newExplosion((Entity)this, this.posX, this.posY + (double)(this.height / 2.0f), this.posZ, 2.0f, true, true);
        EntityPlayerMP player = (EntityPlayerMP)this.riddenByEntity;
        player.mountEntity(null);
        if (this.dimension == 0) {
            player = this.playerTravelToDimension(player, -1);
            newNightmare = this.nightmareTravelToDimension(-1);
        } else {
            player = this.playerTravelToDimension(player, 0);
            newNightmare = this.nightmareTravelToDimension(0);
        }
        player.rotationYaw = newNightmare.rotationYaw;
        player.rotationPitch = newNightmare.rotationPitch;
        player.mountEntity(null);
        player.mountEntity(newNightmare);
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketMountNightmare(newNightmare, (EntityPlayer)player), player);
    }

    public Entity nightmareTravelToDimension(int p_71027_1_) {
        if (!this.worldObj.isRemote && !this.isDead) {
            this.worldObj.theProfiler.startSection("changeDimension");
            MinecraftServer minecraftserver = MinecraftServer.getServer();
            int j = this.dimension;
            WorldServer worldserver = minecraftserver.worldServerForDimension(j);
            WorldServer worldserver2 = minecraftserver.worldServerForDimension(p_71027_1_);
            this.dimension = p_71027_1_;
            this.worldObj.removeEntity((Entity)this);
            this.isDead = false;
            this.worldObj.theProfiler.startSection("reposition");
            if (p_71027_1_ == -1) {
                minecraftserver.getConfigurationManager().transferEntityToWorld((Entity)this, j, worldserver, worldserver2, (Teleporter)this.nightmareTeleporterNether);
            } else {
                minecraftserver.getConfigurationManager().transferEntityToWorld((Entity)this, j, worldserver, worldserver2, (Teleporter)this.nightmareTeleporterOverworld);
            }
            this.worldObj.theProfiler.endStartSection("reloading");
            Entity entity = EntityList.createEntityByName((String)EntityList.getEntityString((Entity)this), (World)worldserver2);
            if (entity != null) {
                entity.copyDataFrom((Entity)this, true);
                worldserver2.spawnEntityInWorld(entity);
            }
            this.isDead = true;
            this.worldObj.theProfiler.endSection();
            worldserver.resetUpdateEntityTick();
            worldserver2.resetUpdateEntityTick();
            this.worldObj.theProfiler.endSection();
            return entity;
        }
        return null;
    }

    public EntityPlayerMP playerTravelToDimension(EntityPlayerMP player, int p_71027_1_) {
        if (p_71027_1_ == -1) {
            player.mcServer.getConfigurationManager().transferPlayerToDimension(player, p_71027_1_, (Teleporter)this.nightmareTeleporterNether);
        } else {
            player.mcServer.getConfigurationManager().transferPlayerToDimension(player, p_71027_1_, (Teleporter)this.nightmareTeleporterOverworld);
        }
        return player;
    }

    @Override
    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)"entity.ThaumicHorizons.NightmareTH.name");
    }

    public void onUpdate() {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)this.boundingBox.minX, (double)this.boundingBox.minY, (double)this.boundingBox.minZ, (double)this.boundingBox.maxX, (double)this.boundingBox.maxY, (double)this.boundingBox.maxZ);
        if (this.worldObj.isAABBInMaterial(axisalignedbb, Material.lava)) {
            this.motionY += 0.1;
            if (this.motionY > 0.25) {
                this.motionY = 0.25;
            }
            this.onGround = true;
            this.fallDistance = 0.0f;
        } else if (this.worldObj.getBlock((int)this.posX, (int)Math.floor(this.posY - 1.0), (int)this.posZ).getMaterial() == Material.lava) {
            this.onGround = true;
            this.fallDistance = 0.0f;
            if (this.motionY < 0.0) {
                this.motionY = 0.0;
            }
        }
        super.onUpdate();
        Block underfoot = this.worldObj.getBlock((int)this.posX, (int)this.posY - 1, (int)this.posZ);
        Block in = this.worldObj.getBlock((int)this.posX, (int)this.posY, (int)this.posZ);
        Block up = this.worldObj.getBlock((int)this.posX, (int)this.posY + 1, (int)this.posZ);
        if (underfoot.getMaterial() == Material.grass) {
            this.worldObj.setBlock((int)this.posX, (int)this.posY - 1, (int)this.posZ, Blocks.dirt);
            ThaumicHorizons.proxy.smeltFX((int)this.posX, (int)this.posY - 1, (int)this.posZ, this.worldObj, 10, false);
        }
        if (this.worldObj.isRemote && underfoot.isBlockNormalCube() && this.moveForward > 0.0f) {
            ThaumicHorizons.proxy.smeltFX((int)this.posX, (int)this.posY - 1, (int)this.posZ, this.worldObj, 3, false);
        }
        if (in.getMaterial() == Material.leaves || in.getMaterial() == Material.web || in.getMaterial() == Material.vine || in.getMaterial() == Material.plants) {
            this.worldObj.setBlockToAir((int)this.posX, (int)this.posY, (int)this.posZ);
            ThaumicHorizons.proxy.smeltFX((int)this.posX, (int)this.posY, (int)this.posZ, this.worldObj, 15, false);
        }
        if (up.getMaterial() == Material.leaves || up.getMaterial() == Material.web || up.getMaterial() == Material.vine || up.getMaterial() == Material.plants) {
            this.worldObj.setBlockToAir((int)this.posX, (int)this.posY + 1, (int)this.posZ);
            ThaumicHorizons.proxy.smeltFX((int)this.posX, (int)this.posY + 1, (int)this.posZ, this.worldObj, 15, false);
        }
    }

    public void setInWeb() {
        this.isInWeb = false;
        this.fallDistance = 0.0f;
    }
}

