/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.Utils;

public class ItemFocusLiquefaction
extends ItemFocusBasic {
    public static FocusUpgradeType nuggets = new FocusUpgradeType(FocusUpgradeType.types.length, new ResourceLocation("thaumichorizons", "textures/foci/nuggets.png"), "focus.upgrade.nuggets.name", "focus.upgrade.nuggets.text", new AspectList().add(Aspect.METAL, 8));
    public static FocusUpgradeType purity = new FocusUpgradeType(FocusUpgradeType.types.length, new ResourceLocation("thaumichorizons", "textures/foci/purity.png"), "focus.upgrade.purity.name", "focus.upgrade.purity.text", new AspectList().add(Aspect.ORDER, 8));
    private static final AspectList cost = new AspectList().add(Aspect.FIRE, 40);
    private static final AspectList costCritter = new AspectList().add(Aspect.FIRE, 15);
    static HashMap<String, Long> soundDelay = new HashMap();
    static HashMap<String, Object> beam = new HashMap();
    static HashMap<String, Float> breakcount = new HashMap();
    static HashMap<String, Integer> lastX = new HashMap();
    static HashMap<String, Integer> lastY = new HashMap();
    static HashMap<String, Integer> lastZ = new HashMap();

    public ItemFocusLiquefaction() {
        this.setCreativeTab(ThaumicHorizons.tabTH);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumichorizons:focus_liquefaction");
    }

    public String getSortingHelper(ItemStack itemstack) {
        return "BE" + super.getSortingHelper(itemstack);
    }

    public int getFocusColor() {
        return 0xFF4444;
    }

    public boolean isVisCostPerTick() {
        return false;
    }

    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer p, MovingObjectPosition mop) {
        p.setItemInUse(itemstack, Integer.MAX_VALUE);
        return itemstack;
    }

    public void onUsingFocusTick(ItemStack stack, EntityPlayer player, int count) {
        ItemWandCasting wand = (ItemWandCasting)stack.getItem();
        int size = 2 + wand.getFocusEnlarge(stack) * 8;
        if (!wand.consumeAllVis(stack, player, this.getVisCost(stack), false, true)) {
            player.stopUsingItem();
        } else {
            ItemStack smeltingOutput;
            String playerProfile = "SP|" + player.getCommandSenderName();
            if (!player.worldObj.isRemote) {
                playerProfile = "MP|" + player.getCommandSenderName();
            }
            soundDelay.putIfAbsent(playerProfile, 0L);
            breakcount.putIfAbsent(playerProfile, Float.valueOf(0.0f));
            lastX.putIfAbsent(playerProfile, 0);
            lastY.putIfAbsent(playerProfile, 0);
            lastZ.putIfAbsent(playerProfile, 0);
            MovingObjectPosition mop = BlockUtils.getTargetBlock((World)player.worldObj, (Entity)player, (boolean)true);
            Entity ent = ItemFocusLiquefaction.getPointedEntity(player.worldObj, (EntityLivingBase)player, 10.0);
            Vec3 v = player.getLookVec();
            double tx = player.posX + v.xCoord * 10.0;
            double ty = player.posY + v.yCoord * 10.0;
            double tz = player.posZ + v.zCoord * 10.0;
            int impact = 0;
            ItemStack droppedItem = null;
            ItemStack resultItem = null;
            if (ent instanceof EntityItem && (droppedItem = ((EntityItem)ent).getEntityItem()) != null && droppedItem.stackSize > 0 && (smeltingOutput = FurnaceRecipes.smelting().getSmeltingResult(droppedItem)) != null) {
                resultItem = smeltingOutput.copy();
            }
            if (ent instanceof EntityLiving) {
                tx = ent.posX;
                ty = ent.posY;
                tz = ent.posZ;
                impact = 5;
                if (!player.worldObj.isRemote && soundDelay.get(playerProfile) < System.currentTimeMillis()) {
                    player.worldObj.playSoundEffect(tx, ty, tz, "fire.fire", 0.3f, 1.0f);
                    soundDelay.put(playerProfile, System.currentTimeMillis() + 1200L);
                }
            } else if (resultItem == null && mop != null) {
                tx = mop.hitVec.xCoord;
                ty = mop.hitVec.yCoord;
                tz = mop.hitVec.zCoord;
                impact = 5;
                if (!player.worldObj.isRemote && soundDelay.get(playerProfile) < System.currentTimeMillis()) {
                    player.worldObj.playSoundEffect(tx, ty, tz, "fire.fire", 8.0f, 1.0f);
                    soundDelay.put(playerProfile, System.currentTimeMillis() + 1200L);
                }
            } else {
                soundDelay.put(playerProfile, 0L);
            }
            if (player.worldObj.isRemote) {
                beam.put(playerProfile, Thaumcraft.proxy.beamCont(player.worldObj, player, tx, ty, tz, 0, 0xFF4444, false, impact > 0 ? (float)size : 0.0f, beam.get(playerProfile), 5));
            }
            if (ent instanceof EntityLiving) {
                if (wand.consumeAllVis(stack, player, costCritter, true, true)) {
                    ThaumicHorizons.proxy.smeltFX(ent.posX - 0.5, ent.posY, ent.posZ - 0.5, player.worldObj, 5, false);
                    ent.attackEntityFrom(DamageSource.inFire, 1.0f + 0.5f * (float)wand.getFocusPotency(stack));
                }
            } else if (resultItem != null) {
                int quantity = ((EntityItem)ent).getEntityItem().stackSize;
                if (wand.consumeAllVis(stack, player, this.getVisCost(stack), true, true)) {
                    ThaumicHorizons.proxy.smeltFX(ent.posX - 0.5, ent.posY, ent.posZ - 0.5, player.worldObj, 5 * quantity, false);
                    resultItem.stackSize = quantity;
                    ((EntityItem)ent).setEntityItemStack(resultItem);
                }
            } else if (mop != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
                Block block = player.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
                int meta = player.worldObj.getBlockMetadata(mop.blockX, mop.blockY, mop.blockZ);
                ItemStack resultBlock = FurnaceRecipes.smelting().getSmeltingResult(new ItemStack(block, 1, meta));
                int meltingBehaviour = this.isMeltableBlock(block, meta);
                boolean flammable = block.isFlammable((IBlockAccess)player.worldObj, mop.blockX, mop.blockY, mop.blockZ, ForgeDirection.UNKNOWN);
                if (meltingBehaviour > 0 || flammable || resultBlock != null) {
                    int pot = wand.getFocusPotency(stack);
                    float speed = 0.15f + (float)pot * 0.05f;
                    float hardness = 2.0f;
                    if (meltingBehaviour == 6) {
                        hardness = 20.0f;
                    } else if (meltingBehaviour > 0 || block.isFlammable((IBlockAccess)player.worldObj, mop.blockX, mop.blockY, mop.blockZ, ForgeDirection.UP)) {
                        hardness = 0.25f;
                    }
                    if (lastX.get(playerProfile) == mop.blockX && lastY.get(playerProfile) == mop.blockY && lastZ.get(playerProfile) == mop.blockZ) {
                        float breakcount = ItemFocusLiquefaction.breakcount.get(playerProfile).floatValue();
                        if (player.worldObj.isRemote) {
                            if (breakcount > 0.0f) {
                                ThaumicHorizons.proxy.smeltFX(mop.blockX, mop.blockY, mop.blockZ, player.worldObj, 15, size > 2);
                            }
                            if (breakcount >= hardness) {
                                player.worldObj.playAuxSFX(2001, mop.blockX, mop.blockY, mop.blockZ, 0);
                                ItemFocusLiquefaction.breakcount.put(playerProfile, Float.valueOf(0.0f));
                            } else {
                                ItemFocusLiquefaction.breakcount.put(playerProfile, Float.valueOf(breakcount + speed));
                            }
                        } else if (breakcount >= hardness) {
                            this.processBlock(mop.blockX, mop.blockY, mop.blockZ, wand, stack, player, playerProfile);
                            if (size > 2) {
                                for (int x = -1; x < 2; ++x) {
                                    for (int y = -1; y < 2; ++y) {
                                        for (int z = -1; z < 2; ++z) {
                                            if (x == 0 && y == 0 && z == 0) continue;
                                            this.processBlock(mop.blockX + x, mop.blockY + y, mop.blockZ + z, wand, stack, player, playerProfile);
                                        }
                                    }
                                }
                            }
                        } else {
                            ItemFocusLiquefaction.breakcount.put(playerProfile, Float.valueOf(breakcount + speed));
                        }
                    } else {
                        lastX.put(playerProfile, mop.blockX);
                        lastY.put(playerProfile, mop.blockY);
                        lastZ.put(playerProfile, mop.blockZ);
                        breakcount.put(playerProfile, Float.valueOf(0.0f));
                    }
                }
            } else {
                lastX.put(playerProfile, Integer.MAX_VALUE);
                lastY.put(playerProfile, Integer.MAX_VALUE);
                lastZ.put(playerProfile, Integer.MAX_VALUE);
                breakcount.put(playerProfile, Float.valueOf(0.0f));
            }
        }
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer p, int count) {
        String pp = "SP|" + p.getCommandSenderName();
        if (!p.worldObj.isRemote) {
            pp = "MP|" + p.getCommandSenderName();
        }
        soundDelay.putIfAbsent(pp, 0L);
        breakcount.putIfAbsent(pp, Float.valueOf(0.0f));
        lastX.putIfAbsent(pp, 0);
        lastY.putIfAbsent(pp, 0);
        lastZ.putIfAbsent(pp, 0);
        beam.put(pp, null);
        lastX.put(pp, Integer.MAX_VALUE);
        lastY.put(pp, Integer.MAX_VALUE);
        lastZ.put(pp, Integer.MAX_VALUE);
        breakcount.put(pp, Float.valueOf(0.0f));
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack focusstack) {
        return ItemFocusBasic.WandFocusAnimation.CHARGE;
    }

    public int isMeltableBlock(Block block, int meta) {
        if (block == Blocks.stone) {
            return 6;
        }
        Material mat = block.getMaterial();
        if (mat == Material.tnt) {
            return 4;
        }
        if (mat == Material.grass) {
            return 3;
        }
        if (mat == Material.ice || mat == Material.packedIce) {
            return 2;
        }
        if (mat == Material.craftedSnow || mat == Material.leaves || mat == Material.plants || mat == Material.snow || mat == Material.vine || mat == Material.web) {
            return 1;
        }
        return 0;
    }

    public int getFocusColor(ItemStack focusstack) {
        return 0xFF0000;
    }

    public AspectList getVisCost(ItemStack focusstack) {
        return cost;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        switch (rank) {
            case 1: 
            case 2: 
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, nuggets};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, purity};
            }
        }
        return null;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return StatCollector.translateToLocal((String)"item.focusLiquefaction.name");
    }

    public static Entity getPointedEntity(World world, EntityLivingBase entityplayer, double range) {
        Entity pointedEntity = null;
        Vec3 vec3d = Vec3.createVectorHelper((double)entityplayer.posX, (double)(entityplayer.posY + (double)entityplayer.getEyeHeight()), (double)entityplayer.posZ);
        Vec3 vec3d2 = entityplayer.getLookVec();
        Vec3 vec3d3 = vec3d.addVector(vec3d2.xCoord * range, vec3d2.yCoord * range, vec3d2.zCoord * range);
        float f1 = 1.1f;
        List list = world.getEntitiesWithinAABBExcludingEntity((Entity)entityplayer, entityplayer.boundingBox.addCoord(vec3d2.xCoord * range, vec3d2.yCoord * range, vec3d2.zCoord * range).expand((double)1.1f, (double)1.1f, (double)1.1f));
        double d2 = 0.0;
        for (Object o : list) {
            double d3;
            Entity entity = (Entity)o;
            if (world.rayTraceBlocks(Vec3.createVectorHelper((double)entityplayer.posX, (double)(entityplayer.posY + (double)entityplayer.getEyeHeight()), (double)entityplayer.posZ), Vec3.createVectorHelper((double)entity.posX, (double)(entity.posY + (double)entity.getEyeHeight()), (double)entity.posZ), false) != null) continue;
            float f2 = Math.max(0.8f, entity.getCollisionBorderSize());
            AxisAlignedBB axisalignedbb = entity.boundingBox.expand((double)f2, (double)f2, (double)f2);
            MovingObjectPosition movingobjectposition = axisalignedbb.calculateIntercept(vec3d, vec3d3);
            if (axisalignedbb.isVecInside(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.distanceTo(movingobjectposition.hitVec)) < d2) && d2 != 0.0) continue;
            pointedEntity = entity;
            d2 = d3;
        }
        return pointedEntity;
    }

    void processBlock(int x, int y, int z, ItemWandCasting wand, ItemStack stack, EntityPlayer p, String pp) {
        BlockEvent.BreakEvent event;
        WorldSettings.GameType gt = WorldSettings.GameType.SURVIVAL;
        if (p.capabilities.allowEdit) {
            if (p.capabilities.isCreativeMode) {
                gt = WorldSettings.GameType.CREATIVE;
            }
        } else {
            gt = WorldSettings.GameType.ADVENTURE;
        }
        if ((event = ForgeHooks.onBlockBreakEvent((World)p.worldObj, (WorldSettings.GameType)gt, (EntityPlayerMP)((EntityPlayerMP)p), (int)x, (int)y, (int)z)).isCanceled()) {
            return;
        }
        Block bi = p.worldObj.getBlock(x, y, z);
        if (bi.getBlockHardness(p.worldObj, x, y, z) == -1.0f) {
            return;
        }
        int md = p.worldObj.getBlockMetadata(x, y, z);
        int meltable = this.isMeltableBlock(bi, md);
        boolean flammable = bi.isFlammable((IBlockAccess)p.worldObj, x, y, z, ForgeDirection.UNKNOWN);
        ItemStack result = FurnaceRecipes.smelting().getSmeltingResult(new ItemStack(bi, 1, md));
        if (result != null && wand.consumeAllVis(stack, p, this.getVisCost(stack), true, true)) {
            if (this.getUpgradeLevel(wand.getFocusItem(stack), purity) > 0 && Utils.findSpecialMiningResult((ItemStack)new ItemStack(bi, 1, md), (float)9999.0f, (Random)p.worldObj.rand) != null) {
                ItemStack pure = Utils.findSpecialMiningResult((ItemStack)new ItemStack(bi, 1, md), (float)9999.0f, (Random)p.worldObj.rand);
                if (FurnaceRecipes.smelting().getSmeltingResult(pure) != null) {
                    result = FurnaceRecipes.smelting().getSmeltingResult(pure);
                }
            }
            if (this.getUpgradeLevel(wand.getFocusItem(stack), nuggets) > 0 && ThaumcraftApi.getSmeltingBonus((ItemStack)new ItemStack(bi, 1, md)) != null) {
                ItemStack bonus = ThaumcraftApi.getSmeltingBonus((ItemStack)new ItemStack(bi, 1, md)).copy();
                for (int i = 0; i < this.getUpgradeLevel(wand.getFocusItem(stack), nuggets); ++i) {
                    if (!(p.worldObj.rand.nextFloat() < 0.45f)) continue;
                    ++bonus.stackSize;
                }
                if (bonus.stackSize > 0) {
                    EntityItem bonusEntity = new EntityItem(p.worldObj, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), bonus);
                    p.worldObj.spawnEntityInWorld((Entity)bonusEntity);
                }
            }
            if (result.getItem() instanceof ItemBlock) {
                p.worldObj.setBlock(x, y, z, Block.getBlockFromItem((Item)result.getItem()));
                p.worldObj.setBlockMetadataWithNotify(x, y, z, result.getItemDamage(), 3);
            } else {
                p.worldObj.setBlockToAir(x, y, z);
                EntityItem theItem = new EntityItem(p.worldObj, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
                theItem.setEntityItemStack(result.copy());
                p.worldObj.spawnEntityInWorld((Entity)theItem);
            }
        } else if (meltable > 0 && wand.consumeAllVis(stack, p, this.getVisCost(stack), true, true)) {
            if (meltable == 1) {
                p.worldObj.setBlockToAir(x, y, z);
            } else if (meltable == 2) {
                if (p.worldObj.provider.dimensionId != -1) {
                    p.worldObj.setBlock(x, y, z, Blocks.water, 0, 3);
                } else {
                    p.worldObj.setBlockToAir(x, y, z);
                }
            } else if (meltable == 3) {
                p.worldObj.setBlock(x, y, z, Blocks.dirt, 0, 3);
            } else if (meltable == 4) {
                Blocks.tnt.onBlockDestroyedByPlayer(p.worldObj, x, y, z, 1);
                p.worldObj.setBlockToAir(x, y, z);
            } else if (meltable == 6) {
                p.worldObj.setBlock(x, y, z, Blocks.lava, 0, 3);
            }
        } else if (flammable && wand.consumeAllVis(stack, p, this.getVisCost(stack), true, true)) {
            p.worldObj.setBlock(x, y, z, (Block)Blocks.fire);
        }
        lastX.put(pp, Integer.MAX_VALUE);
        lastY.put(pp, Integer.MAX_VALUE);
        lastZ.put(pp, Integer.MAX_VALUE);
        breakcount.put(pp, Float.valueOf(0.0f));
        p.worldObj.markBlockForUpdate(x, y, z);
    }
}

