/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items.lenses;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.items.lenses.ILens;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.text.DecimalFormat;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.research.IScanEventHandler;
import thaumcraft.api.research.ScanResult;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketScannedToServer;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemLensOrderEntropy
extends Item
implements ILens {
    ScanResult startScan = null;
    int count = 250;
    boolean isNew = true;
    IIcon icon;

    public ItemLensOrderEntropy() {
        this.setCreativeTab(ThaumicHorizons.tabTH);
    }

    @Override
    public String lensName() {
        return "LensOrderEntropy";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleRender(Minecraft mc, float partialTicks) {
        if (Minecraft.getMinecraft().thePlayer.worldObj.isRemote) {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            EntityClientPlayerMP p = Minecraft.getMinecraft().thePlayer;
            this.isNew = false;
            String text = "?";
            ScanResult scan = this.doScan(new ItemStack(ConfigItems.itemThaumometer), p.worldObj, (EntityPlayer)p, this.count);
            if (scan != null) {
                AspectList aspects = null;
                if (!this.isNew) {
                    aspects = ScanManager.getScanAspects((ScanResult)scan, (World)p.worldObj);
                }
                ItemStack stack = null;
                if (scan.id > 0) {
                    stack = new ItemStack(Item.getItemById((int)scan.id), 1, scan.meta);
                    if (stack.getItem() != null) {
                        try {
                            text = stack.getDisplayName();
                        }
                        catch (Exception exception) {}
                    } else if (stack.getItem() != null) {
                        try {
                            text = stack.getItem().getItemStackDisplayName(stack);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (scan.type == 2) {
                    text = !(scan.entity instanceof EntityItem) ? scan.entity.getCommandSenderName() : ((EntityItem)scan.entity).getEntityItem().getDisplayName();
                    x = scan.entity.posX;
                    y = scan.entity.posY;
                    z = scan.entity.posZ;
                } else {
                    MovingObjectPosition mop = EntityUtils.getMovingObjectPositionFromPlayer((World)p.worldObj, (EntityPlayer)p, (boolean)true);
                    if (mop != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
                        x = mop.blockX;
                        y = mop.blockY;
                        z = mop.blockZ;
                        TileEntity tile = p.worldObj.getTileEntity(mop.blockX, mop.blockY, mop.blockZ);
                        if (scan.type == 3 && scan.phenomena.startsWith("NODE") && tile instanceof INode) {
                            if (!this.isNew) {
                                aspects = ((INode)tile).getAspects();
                            }
                            text = p.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ) == ConfigBlocks.blockAiry ? StatCollector.translateToLocal((String)(p.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ).getUnlocalizedName() + "." + p.worldObj.getBlockMetadata(mop.blockX, mop.blockY, mop.blockZ) + ".name")) : StatCollector.translateToLocal((String)p.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ).getLocalizedName());
                            text = text + " (" + StatCollector.translateToLocal((String)("nodetype." + ((INode)tile).getNodeType() + ".name"));
                            if (((INode)tile).getNodeModifier() != null) {
                                text = text + ", " + StatCollector.translateToLocal((String)("nodemod." + ((INode)tile).getNodeModifier() + ".name"));
                            }
                            text = text + ")";
                        }
                    }
                }
                if (aspects != null || text.length() > 0) {
                    this.renderNameAndAspects(aspects, text);
                }
            }
            if (scan != null && scan.equals((Object)this.startScan) && this.isNew) {
                --this.count;
                this.renderNameAndAspects(null, text);
                if (this.count <= 5) {
                    this.startScan = null;
                    if (ScanManager.completeScan((EntityPlayer)p, (ScanResult)scan, (String)"@")) {
                        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketScannedToServer(scan, (EntityPlayer)p, "@"));
                    }
                    this.count = 250;
                }
                if (this.count % 20 == 0) {
                    p.worldObj.playSound(p.posX, p.posY, p.posZ, "thaumcraft:cameraticks", 0.2f, 0.45f + p.worldObj.rand.nextFloat() * 0.1f, false);
                }
            } else {
                this.startScan = scan;
                this.count = 250;
            }
        }
    }

    private void renderNameAndAspects(AspectList aspects, String text) {
        ScaledResolution sr = new ScaledResolution(Minecraft.getMinecraft(), Minecraft.getMinecraft().displayWidth, Minecraft.getMinecraft().displayHeight);
        int w = sr.getScaledWidth();
        int h = sr.getScaledHeight();
        if (aspects != null && aspects.size() > 0) {
            int num = 0;
            int yOff = 0;
            int thisRow = 0;
            int size = 18;
            thisRow = Math.min(aspects.size() - num, 5);
            for (Aspect asp : aspects.getAspects()) {
                yOff = num / 5 * 18;
                this.drawAspectTag(asp, aspects.getAmount(asp), w / 2 - 18 * thisRow / 2 + 18 * (num % 5), h / 2 + 16 + yOff, w);
                if (++num % 5 != 0) continue;
                thisRow = Math.min(aspects.size() - num, 5);
            }
        }
        if (text.length() > 0) {
            Minecraft.getMinecraft().ingameGUI.drawString(Minecraft.getMinecraft().fontRenderer, text, w / 2 - Minecraft.getMinecraft().fontRenderer.getStringWidth(text) / 2, h / 2 - 16, 0xFFFFFF);
        }
    }

    private ScanResult doScan(ItemStack stack, World world, EntityPlayer p, int count) {
        Entity pointedEntity = EntityUtils.getPointedEntity((World)p.worldObj, (Entity)p, (double)0.5, (double)10.0, (float)0.0f, (boolean)true);
        if (pointedEntity == null) {
            MovingObjectPosition mop = this.getMovingObjectPositionFromPlayer(p.worldObj, p, true);
            if (mop != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
                TileEntity tile = world.getTileEntity(mop.blockX, mop.blockY, mop.blockZ);
                if (tile instanceof INode) {
                    ScanResult sr = new ScanResult(3, 0, 0, null, "NODE" + ((INode)tile).getId());
                    if (ScanManager.isValidScanTarget((EntityPlayer)p, (ScanResult)sr, (String)"@")) {
                        Thaumcraft.proxy.blockRunes(world, (double)mop.blockX, (double)mop.blockY + 0.25, (double)mop.blockZ, 0.3f + world.rand.nextFloat() * 0.7f, 0.0f, 0.3f + world.rand.nextFloat() * 0.7f, 15, 0.03f);
                        this.isNew = true;
                        return sr;
                    }
                    return sr;
                }
                Block bi = world.getBlock(mop.blockX, mop.blockY, mop.blockZ);
                if (bi != Blocks.air) {
                    int md = bi.getDamageValue(world, mop.blockX, mop.blockY, mop.blockZ);
                    ItemStack is = bi.getPickBlock(mop, p.worldObj, mop.blockX, mop.blockY, mop.blockZ);
                    ScanResult sr2 = null;
                    try {
                        if (is == null) {
                            is = BlockUtils.createStackedBlock((Block)bi, (int)md);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        sr2 = is == null ? new ScanResult(1, Block.getIdFromBlock((Block)bi), md, null, "") : new ScanResult(1, Item.getIdFromItem((Item)is.getItem()), is.getItemDamage(), null, "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (ScanManager.isValidScanTarget((EntityPlayer)p, sr2, (String)"@")) {
                        Thaumcraft.proxy.blockRunes(world, (double)mop.blockX, (double)mop.blockY + 0.25, (double)mop.blockZ, 0.3f + world.rand.nextFloat() * 0.7f, 0.0f, 0.3f + world.rand.nextFloat() * 0.7f, 15, 0.03f);
                        this.isNew = true;
                        return sr2;
                    }
                    return sr2;
                }
            }
            for (IScanEventHandler seh : ThaumcraftApi.scanEventhandlers) {
                ScanResult scan = seh.scanPhenomena(stack, world, p);
                if (scan == null) continue;
                return scan;
            }
            return null;
        }
        ScanResult sr3 = new ScanResult(2, 0, 0, pointedEntity, "");
        if (ScanManager.isValidScanTarget((EntityPlayer)p, (ScanResult)sr3, (String)"@")) {
            Thaumcraft.proxy.blockRunes(world, pointedEntity.posX - 0.5, pointedEntity.posY + (double)(pointedEntity.getEyeHeight() / 2.0f), pointedEntity.posZ - 0.5, 0.3f + world.rand.nextFloat() * 0.7f, 0.0f, 0.3f + world.rand.nextFloat() * 0.7f, (int)(pointedEntity.height * 15.0f), 0.03f);
            this.isNew = true;
            return sr3;
        }
        return sr3;
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return "item.LensOrderEntropy";
    }

    public void drawAspectTag(Aspect aspect, int amount, int x, int y, int sw) {
        GL11.glPushMatrix();
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Minecraft mc = Minecraft.getMinecraft();
        Color color = new Color(aspect.getColor());
        mc.renderEngine.bindTexture(aspect.getImage());
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.5f);
        Tessellator var9 = Tessellator.instance;
        var9.startDrawingQuads();
        var9.setColorRGBA_F((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.5f);
        var9.addVertexWithUV((double)x + 0.0, (double)y + 16.0, 0.0, 0.0, 1.0);
        var9.addVertexWithUV((double)x + 16.0, (double)y + 16.0, 0.0, 1.0, 1.0);
        var9.addVertexWithUV((double)x + 16.0, (double)y + 0.0, 0.0, 1.0, 0.0);
        var9.addVertexWithUV((double)x + 0.0, (double)y + 0.0, 0.0, 0.0, 0.0);
        var9.draw();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DecimalFormat myFormatter = new DecimalFormat("#######.##");
        String am = myFormatter.format(amount);
        mc.fontRenderer.drawString(am, 24 + x * 2, 32 - mc.fontRenderer.FONT_HEIGHT + y * 2, 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumichorizons:lensorderentropy");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    @Override
    public void handleRemoval(EntityPlayer p) {
    }
}

