/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items.lenses;

import baubles.api.BaublesApi;
import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.items.lenses.ILens;
import com.kentington.thaumichorizons.common.items.lenses.ItemLensCase;
import java.util.HashMap;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.nodes.IRevealer;

public class LensManager {
    public static long nightVisionOffTime = 0L;

    public static void changeLens(ItemStack is, World w, EntityPlayer player, String lens) {
        IRevealer goggles = (IRevealer)is.getItem();
        TreeMap<String, Integer> lenses = new TreeMap<String, Integer>();
        HashMap<Integer, Integer> pouches = new HashMap<Integer, Integer>();
        int pouchcount = 0;
        ItemStack item = null;
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (int a = 0; a < 4; ++a) {
            if (baubles.getStackInSlot(a) == null || !(baubles.getStackInSlot(a).getItem() instanceof ItemLensCase)) continue;
            item = baubles.getStackInSlot(a);
            pouches.put(++pouchcount, a - 4);
            ItemStack[] inv = ((ItemLensCase)item.getItem()).getInventory(item);
            for (int q = 0; q < inv.length; ++q) {
                item = inv[q];
                if (item == null || !(item.getItem() instanceof ILens)) continue;
                lenses.put(((ILens)item.getItem()).lensName(), q + pouchcount * 1000);
            }
        }
        for (int newkey = 0; newkey < 36; ++newkey) {
            item = player.inventory.mainInventory[newkey];
            if (item != null && item.getItem() instanceof ILens) {
                lenses.put(((ILens)item.getItem()).lensName(), newkey);
            }
            if (item == null || !(item.getItem() instanceof ItemLensCase)) continue;
            pouches.put(++pouchcount, newkey);
            ItemStack[] pid = ((ItemLensCase)item.getItem()).getInventory(item);
            for (int pouchslot = 0; pouchslot < pid.length; ++pouchslot) {
                item = pid[pouchslot];
                if (item == null || !(item.getItem() instanceof ILens)) continue;
                lenses.put(((ILens)item.getItem()).lensName(), pouchslot + pouchcount * 1000);
            }
        }
        ItemStack oldLens = null;
        if (!lens.equals("REMOVE") && lenses.size() != 0) {
            if (lenses != null && lenses.size() > 0 && lens != null) {
                String var13 = lens;
                if (lenses.get(lens) == null) {
                    var13 = lenses.higherKey(lens);
                }
                if (var13 == null || lenses.get(var13) == null) {
                    var13 = (String)lenses.firstKey();
                }
                if ((Integer)lenses.get(var13) < 1000) {
                    item = player.inventory.mainInventory[(Integer)lenses.get(var13)].copy();
                } else {
                    int var14 = (Integer)lenses.get(var13) / 1000;
                    if (pouches.containsKey(var14)) {
                        int pouchslot = pouches.get(var14);
                        int lensSlot = (Integer)lenses.get(var13) - var14 * 1000;
                        ItemStack tmp = pouchslot >= 0 ? player.inventory.mainInventory[pouchslot].copy() : baubles.getStackInSlot(pouchslot + 4).copy();
                        item = LensManager.fetchLensFromPouch(player, lensSlot, tmp, pouchslot);
                    }
                }
                if (item == null) {
                    return;
                }
                if ((Integer)lenses.get(var13) < 1000) {
                    player.inventory.setInventorySlotContents(((Integer)lenses.get(var13)).intValue(), null);
                }
                w.playSoundAtEntity((Entity)player, "thaumcraft:cameraticks", 0.3f, 1.0f);
                String currentLens = "";
                if (is.stackTagCompound != null) {
                    currentLens = is.stackTagCompound.getString("Lens");
                }
                oldLens = LensManager.getLensItem(currentLens);
                if (!currentLens.equals("") && (LensManager.addLensToPouch(player, oldLens, pouches) || player.inventory.addItemStackToInventory(oldLens))) {
                    LensManager.setLensItem(is, item);
                } else if (currentLens.equals("")) {
                    LensManager.setLensItem(is, item);
                } else if (!LensManager.addLensToPouch(player, item, pouches)) {
                    player.inventory.addItemStackToInventory(item);
                }
            }
        } else {
            String currentLens2 = "";
            if (is.stackTagCompound != null) {
                currentLens2 = is.stackTagCompound.getString("Lens");
            }
            oldLens = LensManager.getLensItem(currentLens2);
            if (!currentLens2.equals("") && (LensManager.addLensToPouch(player, oldLens, pouches) || player.inventory.addItemStackToInventory(oldLens))) {
                LensManager.setLensItem(is, null);
                w.playSoundAtEntity((Entity)player, "thaumcraft:cameraticks", 0.3f, 0.9f);
            }
        }
        if (oldLens != null) {
            ((ILens)oldLens.getItem()).handleRemoval(player);
        }
    }

    private static ItemStack fetchLensFromPouch(EntityPlayer player, int lensid, ItemStack pouch, int pouchslot) {
        ItemStack lens = null;
        ItemStack[] inv = ((ItemLensCase)pouch.getItem()).getInventory(pouch);
        ItemStack contents = inv[lensid];
        if (contents != null && contents.getItem() instanceof ILens) {
            lens = contents.copy();
            inv[lensid] = null;
            ((ItemLensCase)pouch.getItem()).setInventory(pouch, inv);
            if (pouchslot >= 0) {
                player.inventory.setInventorySlotContents(pouchslot, pouch);
                player.inventory.markDirty();
            } else {
                IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
                baubles.setInventorySlotContents(pouchslot + 4, pouch);
                baubles.markDirty();
            }
        }
        return lens;
    }

    private static boolean addLensToPouch(EntityPlayer player, ItemStack lens, HashMap<Integer, Integer> pouches) {
        for (int value : pouches.values()) {
            IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
            int pouchslot = value;
            ItemStack pouch = pouchslot >= 0 ? player.inventory.mainInventory[pouchslot] : baubles.getStackInSlot(pouchslot + 4);
            ItemStack[] inv = ((ItemLensCase)pouch.getItem()).getInventory(pouch);
            for (int q = 0; q < inv.length; ++q) {
                ItemStack contents = inv[q];
                if (contents != null) continue;
                inv[q] = lens.copy();
                ((ItemLensCase)pouch.getItem()).setInventory(pouch, inv);
                if (pouchslot >= 0) {
                    player.inventory.setInventorySlotContents(pouchslot, pouch);
                    player.inventory.markDirty();
                } else {
                    baubles.setInventorySlotContents(pouchslot + 4, pouch);
                    baubles.markDirty();
                }
                player.inventory.markDirty();
                return true;
            }
        }
        return false;
    }

    public static ItemStack getLensItem(String lens) {
        if (LensManager.getLens(lens) != null) {
            return new ItemStack(LensManager.getLens(lens));
        }
        return null;
    }

    public static Item getLens(String lens) {
        if (lens.equals("LensFire")) {
            return ThaumicHorizons.itemLensFire;
        }
        if (lens.equals("LensWater")) {
            return ThaumicHorizons.itemLensWater;
        }
        if (lens.equals("LensEarth")) {
            return ThaumicHorizons.itemLensEarth;
        }
        if (lens.equals("LensAir")) {
            return ThaumicHorizons.itemLensAir;
        }
        if (lens.equals("LensOrderEntropy")) {
            return ThaumicHorizons.itemLensOrderEntropy;
        }
        return null;
    }

    public static void setLensItem(ItemStack goggles, ItemStack lens) {
        if (!goggles.hasTagCompound()) {
            goggles.stackTagCompound = new NBTTagCompound();
        }
        int lensIndex = goggles.stackTagCompound.getInteger("LensIndex");
        NBTTagList lore = null;
        if (goggles.stackTagCompound != null && goggles.stackTagCompound.getCompoundTag("display") != null) {
            lore = goggles.stackTagCompound.getCompoundTag("display").getTagList("Lore", 8);
        }
        if (lore == null || lore.tagCount() == 0) {
            if (goggles.stackTagCompound == null) {
                goggles.stackTagCompound = new NBTTagCompound();
            }
            if (goggles.stackTagCompound.getCompoundTag("display").hasNoTags()) {
                goggles.stackTagCompound.setTag("display", (NBTBase)new NBTTagCompound());
            }
            if (goggles.stackTagCompound.getCompoundTag("display").getTagList("Lore", 8).tagCount() == 0) {
                goggles.stackTagCompound.getCompoundTag("display").setTag("Lore", (NBTBase)new NBTTagList());
            }
            lore = goggles.stackTagCompound.getCompoundTag("display").getTagList("Lore", 8);
            lensIndex = 0;
        }
        if (lens == null) {
            goggles.stackTagCompound.removeTag("Lens");
            if (lensIndex >= 0 && lore.tagCount() > lensIndex) {
                lore.removeTag(lensIndex);
            }
            goggles.stackTagCompound.setInteger("LensIndex", -1);
        } else {
            goggles.stackTagCompound.removeTag("Lens");
            goggles.stackTagCompound.setString("Lens", ((ILens)lens.getItem()).lensName());
            if (lensIndex != -1 && lore.tagCount() > lensIndex) {
                lore.removeTag(lensIndex);
            }
            goggles.stackTagCompound.setInteger("LensIndex", lore.tagCount());
            lore.appendTag((NBTBase)new NBTTagString(StatCollector.translateToLocal((String)("item." + ((ILens)lens.getItem()).lensName() + ".name"))));
        }
    }
}

