/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.tiles;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.common.Thaumcraft;

public class TilePortalTH
extends TileThaumcraft {
    public int opencount = -1;
    private int count = 0;
    public int dimension = 0;
    public int pocket = -1;

    public boolean canUpdate() {
        return true;
    }

    public double getMaxRenderDistanceSquared() {
        return 9216.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.getBoundingBox((double)(this.xCoord - 1), (double)(this.yCoord - 1), (double)(this.zCoord - 1), (double)(this.xCoord + 2), (double)(this.yCoord + 2), (double)(this.zCoord + 2));
    }

    public void updateEntity() {
        List ents;
        ++this.count;
        if (this.worldObj.isRemote && (this.count % 250 == 0 || this.count == 0)) {
            this.worldObj.playSound((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "thaumcraft:evilportal", 1.0f, 1.0f, false);
        }
        if (this.worldObj.isRemote && this.opencount < 30) {
            ++this.opencount;
        }
        if (!this.worldObj.isRemote && this.count % 5 == 0 && (ents = this.worldObj.getEntitiesWithinAABB(EntityPlayerMP.class, AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).expand(0.5, 1.0, 0.5))).size() > 0) {
            for (Object e : ents) {
                EntityPlayerMP player = (EntityPlayerMP)e;
                if (player.ridingEntity != null || player.riddenByEntity != null) continue;
                MinecraftServer mServer = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (player.timeUntilPortal > 0) continue;
                player.timeUntilPortal = 50;
                int n = player.dimension;
            }
        }
        if (this.count > 250) {
            this.worldObj.playSound((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "thaumcraft:craftfail", 1.0f, 1.0f, false);
            Thaumcraft.proxy.burst(this.getWorldObj(), (double)((float)this.xCoord + 0.5f), (double)((float)this.yCoord + 0.5f), (double)((float)this.zCoord + 0.5f), 3.0f);
            this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.setInteger("dimension", this.dimension);
        nbttagcompound.setInteger("count", this.count);
        nbttagcompound.setInteger("pocket", this.pocket);
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.dimension = nbttagcompound.getInteger("dimension");
        this.count = nbttagcompound.getInteger("count");
        this.pocket = nbttagcompound.getInteger("pocket");
    }
}

