/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.tiles;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntityGolemTH;
import com.kentington.thaumichorizons.common.lib.PocketPlaneData;
import com.kentington.thaumichorizons.common.lib.PocketPlaneThread;
import com.kentington.thaumichorizons.common.lib.VortexTeleporter;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockAiry;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.items.wands.ItemWandCasting;

public class TileVortex
extends TileThaumcraft
implements IWandable,
IAspectContainer {
    final int MAX_COUNT = 2400;
    public int count;
    public int beams;
    public int dimensionID;
    public int returnID;
    public AspectList aspects = new AspectList();
    boolean ateDevices = false;
    public boolean collapsing = false;
    public boolean createdDimension = false;
    public boolean generating = false;
    public boolean cheat = false;
    public ArrayList<ItemStack> items = new ArrayList();
    Thread ppThread = null;
    private boolean soundStarted = false;

    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj != null && this.worldObj.isRemote && !this.soundStarted) {
            ThaumicHorizons.proxy.playVortexSound(this);
            this.soundStarted = true;
        }
        if (this.generating) {
            this.worldObj.createExplosion(null, (double)((float)this.xCoord + this.worldObj.rand.nextFloat()), (double)((float)this.yCoord + this.worldObj.rand.nextFloat()), (double)((float)this.zCoord + this.worldObj.rand.nextFloat()), 1.0f, false);
            if (this.ppThread == null) {
                this.createDimension(null);
                return;
            }
            if (!this.ppThread.isAlive()) {
                this.generating = false;
                this.createdDimension = true;
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        } else {
            if (this.collapsing) {
                ++this.count;
                if (this.count > 25) {
                    WorldServer wsd;
                    if (this.createdDimension && (wsd = DimensionManager.getWorld((int)ThaumicHorizons.dimensionPocketId)) != null) {
                        wsd.setBlockToAir(0, 129, this.dimensionID * 256);
                    }
                    this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
                    if (this.worldObj.isRemote) {
                        Thaumcraft.proxy.burst(this.worldObj, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 4.0f);
                    }
                    BlockAiry.explodify((World)this.worldObj, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord);
                }
                return;
            }
            if (this.count < 50) {
                ++this.count;
            } else {
                List ents;
                if (!this.ateDevices) {
                    if (!this.cheat && this.worldObj.provider.dimensionId != ThaumicHorizons.dimensionPocketId) {
                        for (int dx = -2; dx <= 2; ++dx) {
                            for (int dy = -2; dy <= 2; ++dy) {
                                for (int dz = -2; dz <= 2; ++dz) {
                                    if (dx == 0 && dy == 0 && dz == 0) continue;
                                    this.worldObj.setBlockToAir(this.xCoord + dx, this.yCoord + dy, this.zCoord + dz);
                                    if (!this.worldObj.isRemote) continue;
                                    Thaumcraft.proxy.burst(this.worldObj, (double)(this.xCoord + dx), (double)(this.yCoord + dy), (double)(this.zCoord + dz), 4.0f);
                                }
                            }
                        }
                    }
                    this.ateDevices = true;
                }
                if (this.beams < 6 && !this.cheat && this.worldObj.provider.dimensionId != ThaumicHorizons.dimensionPocketId) {
                    this.handleHungryNode();
                } else if (!this.createdDimension && !this.generating) {
                    this.handlePocketPlaneStuff();
                }
                if (!this.cheat) {
                    this.count += 6 - this.beams;
                }
                if (this.count > 2400 && !this.cheat && this.worldObj.provider.dimensionId != ThaumicHorizons.dimensionPocketId) {
                    this.collapsing = true;
                    this.count = 0;
                }
                if (this.createdDimension && (ents = this.worldObj.getEntitiesWithinAABB(EntityPlayerMP.class, AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)))).size() > 0) {
                    for (Object e : ents) {
                        EntityPlayerMP player = (EntityPlayerMP)e;
                        if (player.ridingEntity != null || player.riddenByEntity != null) continue;
                        MinecraftServer mServer = FMLCommonHandler.instance().getMinecraftServerInstance();
                        if (player.timeUntilPortal > 0) {
                            player.timeUntilPortal = 10;
                            continue;
                        }
                        if (player.dimension != ThaumicHorizons.dimensionPocketId) {
                            player.timeUntilPortal = 10;
                            player.mcServer.getConfigurationManager().transferPlayerToDimension(player, ThaumicHorizons.dimensionPocketId, (Teleporter)new VortexTeleporter(mServer.worldServerForDimension(ThaumicHorizons.dimensionPocketId), this.dimensionID));
                            continue;
                        }
                        player.timeUntilPortal = 10;
                        player.mcServer.getConfigurationManager().transferPlayerToDimension(player, this.returnID, (Teleporter)new VortexTeleporter(mServer.worldServerForDimension(this.returnID), this.dimensionID));
                    }
                }
            }
        }
    }

    void handlePocketPlaneStuff() {
        List ents = this.worldObj.getEntitiesWithinAABB(Entity.class, AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).expand(1.0, 1.0, 1.0));
        if (ents != null && ents.size() > 0) {
            for (Object ent : ents) {
                Entity eo = (Entity)ent;
                if (!(eo instanceof EntityItem)) continue;
                EntityItem item = (EntityItem)eo;
                if (ThaumicHorizons.enablePocket && item.getEntityItem().getItem() == ConfigItems.itemEldritchObject && item.getEntityItem().getItemDamage() == 3) {
                    this.createDimension(item);
                    item.setDead();
                    continue;
                }
                this.handleVoidCrafting(item);
            }
        }
    }

    void handleVoidCrafting(EntityItem item) {
        if (item.getEntityItem().getItem() == ConfigItems.itemResource && item.getEntityItem().getItemDamage() == 16) {
            this.items.add(new ItemStack(ThaumicHorizons.itemVoidPutty, item.getEntityItem().stackSize));
            item.setDead();
        } else if (item.getEntityItem().getItem() == ConfigItems.itemResource && item.getEntityItem().getItemDamage() == 14) {
            for (int i = 0; i < item.getEntityItem().stackSize; ++i) {
                this.spawnWisps();
            }
            item.setDead();
        } else if (item.getEntityItem().getItem() == ThaumicHorizons.itemCrystalWand) {
            ItemStack theWand = new ItemStack(ThaumicHorizons.itemWandCastingDisposable);
            ((ItemWandCasting)theWand.getItem()).setRod(theWand, ThaumicHorizons.ROD_CRYSTAL);
            ((ItemWandCasting)theWand.getItem()).setCap(theWand, ThaumicHorizons.CAP_CRYSTAL);
            ((ItemWandCasting)theWand.getItem()).storeVis(theWand, Aspect.EARTH, 25000);
            ((ItemWandCasting)theWand.getItem()).storeVis(theWand, Aspect.AIR, 25000);
            ((ItemWandCasting)theWand.getItem()).storeVis(theWand, Aspect.FIRE, 25000);
            ((ItemWandCasting)theWand.getItem()).storeVis(theWand, Aspect.WATER, 25000);
            ((ItemWandCasting)theWand.getItem()).storeVis(theWand, Aspect.ORDER, 25000);
            ((ItemWandCasting)theWand.getItem()).storeVis(theWand, Aspect.ENTROPY, 25000);
            this.items.add(theWand);
            item.setDead();
        } else if (item.getEntityItem().getItem() == ThaumicHorizons.itemGolemPowder && item.func_145800_j() != null) {
            if (!this.worldObj.isRemote) {
                for (int i = 0; i < item.getEntityItem().stackSize; ++i) {
                    EntityGolemTH golem = new EntityGolemTH(this.worldObj);
                    golem.setOwner(item.func_145800_j());
                    golem.loadGolem((double)this.xCoord + 0.5, this.yCoord, (double)this.zCoord + 0.5, null, 0, -420, false, false, false);
                    this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "thaumcraft:wand", 1.0f, 1.0f);
                    golem.setHomeArea((int)golem.posX, (int)golem.posY, (int)golem.posZ, 32);
                    this.worldObj.spawnEntityInWorld((Entity)golem);
                    this.worldObj.setEntityState((Entity)golem, (byte)7);
                }
            }
            item.setDead();
        }
    }

    void spawnWisps() {
        if (this.worldObj.isRemote) {
            return;
        }
        int wisps = this.worldObj.rand.nextInt(4) + 1;
        for (int i = 0; i < wisps; ++i) {
            EntityWisp wisp = new EntityWisp(this.worldObj);
            wisp.setPosition((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
            if (this.aspects.size() > 0 && this.aspects.getAspects()[0] != null) {
                wisp.setType(this.aspects.getAspects()[this.worldObj.rand.nextInt(this.aspects.size())].getTag());
            }
            this.worldObj.spawnEntityInWorld((Entity)wisp);
        }
    }

    void createDimension(EntityItem pearl) {
        MinecraftServer server = MinecraftServer.getServer();
        if (server == null) {
            return;
        }
        PocketPlaneData data = new PocketPlaneData();
        String name = "";
        if (pearl != null && pearl.getEntityItem().hasTagCompound()) {
            name = pearl.getEntityItem().getDisplayName();
        } else if (pearl != null) {
            name = pearl.func_145800_j() + StatCollector.translateToLocal((String)"thaumichorizons.pocketplane");
        }
        data.name = name;
        this.dimensionID = PocketPlaneData.pocketPlaneMAXID;
        if (DimensionManager.getWorld((int)ThaumicHorizons.dimensionPocketId) == null) {
            DimensionManager.initDimension((int)ThaumicHorizons.dimensionPocketId);
        }
        this.generating = true;
        if (!this.worldObj.isRemote) {
            this.returnID = this.worldObj.provider.dimensionId;
            this.ppThread = new Thread(new PocketPlaneThread(data, this.aspects, (World)MinecraftServer.getServer().worldServerForDimension(ThaumicHorizons.dimensionPocketId), this.xCoord, this.yCoord, this.zCoord, this.returnID));
            this.ppThread.run();
        }
        this.markDirty();
    }

    void handleHungryNode() {
        List ents;
        if (this.worldObj.isRemote && this.beams < 6) {
            for (int a = 0; a < Thaumcraft.proxy.particleCount(1); ++a) {
                Vec3 v2;
                Vec3 v1;
                MovingObjectPosition mop;
                int tz;
                int tx = this.xCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16);
                int ty = this.yCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16);
                if (ty > this.worldObj.getHeightValue(tx, tz = this.zCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16))) {
                    ty = this.worldObj.getHeightValue(tx, tz);
                }
                if ((mop = ThaumcraftApiHelper.rayTraceIgnoringSource((World)this.worldObj, (Vec3)(v1 = Vec3.createVectorHelper((double)((double)this.xCoord + 0.5), (double)((double)this.yCoord + 0.5), (double)((double)this.zCoord + 0.5))), (Vec3)(v2 = Vec3.createVectorHelper((double)((double)tx + 0.5), (double)((double)ty + 0.5), (double)((double)tz + 0.5))), (boolean)true, (boolean)false, (boolean)false)) == null || !(this.getDistanceFrom(mop.blockX, mop.blockY, mop.blockZ) < 256.0)) continue;
                tx = mop.blockX;
                ty = mop.blockY;
                tz = mop.blockZ;
                Block bi = this.worldObj.getBlock(tx, ty, tz);
                int md = this.worldObj.getBlockMetadata(tx, ty, tz);
                if (bi.isAir((IBlockAccess)this.worldObj, tx, ty, tz)) continue;
                Thaumcraft.proxy.hungryNodeFX(this.worldObj, tx, ty, tz, this.xCoord, this.yCoord, this.zCoord, bi, md);
            }
        }
        if ((ents = this.worldObj.getEntitiesWithinAABB(Entity.class, AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).expand(15.0, 15.0, 15.0))) != null && ents.size() > 0) {
            for (Object ent : ents) {
                double d;
                Entity eo = (Entity)ent;
                if (eo instanceof EntityPlayer && ((EntityPlayer)eo).capabilities.disableDamage) continue;
                if (eo.isEntityAlive() && !eo.isEntityInvulnerable() && (d = this.getDistanceTo(eo.posX, eo.posY, eo.posZ)) < 2.0) {
                    if (eo instanceof EntityFallingBlock) {
                        eo.setDead();
                    } else {
                        eo.attackEntityFrom(DamageSource.outOfWorld, 3.0f - (float)this.beams / 2.0f);
                    }
                }
                double var3 = ((double)this.xCoord + 0.5 - eo.posX) / 15.0;
                double var4 = ((double)this.yCoord + 0.5 - eo.posY) / 15.0;
                double var5 = ((double)this.zCoord + 0.5 - eo.posZ) / 15.0;
                double var6 = Math.sqrt(var3 * var3 + var4 * var4 + var5 * var5);
                double var7 = 1.0 - var6;
                double modifier = 2.0 - (double)this.beams / 3.0;
                if (var7 <= 0.0) continue;
                var7 *= var7;
                eo.motionX += var3 / var6 * var7 * 0.15 * modifier;
                eo.motionY += var4 / var6 * var7 * 0.25 * modifier;
                eo.motionZ += var5 / var6 * var7 * 0.15 * modifier;
            }
        }
        for (int i = 0; i < 3; ++i) {
            float h;
            Vec3 v4;
            Vec3 v3;
            MovingObjectPosition mop2;
            int tz2;
            if (this.worldObj.isRemote || this.beams > 0 && this.worldObj.rand.nextInt(this.beams) != 0) continue;
            int tx2 = this.xCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16);
            int ty2 = this.yCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16);
            if (ty2 > this.worldObj.getHeightValue(tx2, tz2 = this.zCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16))) {
                ty2 = this.worldObj.getHeightValue(tx2, tz2);
            }
            if ((mop2 = ThaumcraftApiHelper.rayTraceIgnoringSource((World)this.worldObj, (Vec3)(v3 = Vec3.createVectorHelper((double)((double)this.xCoord + 0.5), (double)((double)this.yCoord + 0.5), (double)((double)this.zCoord + 0.5))), (Vec3)(v4 = Vec3.createVectorHelper((double)((double)tx2 + 0.5), (double)((double)ty2 + 0.5), (double)((double)tz2 + 0.5))), (boolean)true, (boolean)false, (boolean)false)) == null || !(this.getDistanceFrom(mop2.blockX, mop2.blockY, mop2.blockZ) < 256.0)) continue;
            tx2 = mop2.blockX;
            ty2 = mop2.blockY;
            tz2 = mop2.blockZ;
            Block bi2 = this.worldObj.getBlock(tx2, ty2, tz2);
            int md2 = this.worldObj.getBlockMetadata(tx2, ty2, tz2);
            if (bi2.isAir((IBlockAccess)this.worldObj, tx2, ty2, tz2) || !((h = bi2.getBlockHardness(this.worldObj, tx2, ty2, tz2)) >= 0.0f) || !(h < 10.0f)) continue;
            this.worldObj.func_147480_a(tx2, ty2, tz2, true);
        }
    }

    public double getDistanceTo(double par1, double par3, double par5) {
        double var7 = (double)this.xCoord + 0.5 - par1;
        double var8 = (double)this.yCoord + 0.5 - par3;
        double var9 = (double)this.zCoord + 0.5 - par5;
        return var7 * var7 + var8 * var8 + var9 * var9;
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.setInteger("count", this.count);
        nbttagcompound.setInteger("beams", this.beams);
        nbttagcompound.setInteger("dimensionID", this.dimensionID);
        nbttagcompound.setInteger("returnID", this.returnID);
        nbttagcompound.setBoolean("ateDevices", this.ateDevices);
        nbttagcompound.setBoolean("collapsing", this.collapsing);
        nbttagcompound.setBoolean("createdDimension", this.createdDimension);
        nbttagcompound.setBoolean("isGenerating", this.generating);
        nbttagcompound.setBoolean("cheat", this.cheat);
        NBTTagList tlist = new NBTTagList();
        nbttagcompound.setTag("aspects", (NBTBase)tlist);
        for (Aspect aspect : this.aspects.getAspects()) {
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.setString("key", aspect.getTag());
            f.setInteger("amount", this.aspects.getAmount(aspect));
            tlist.appendTag((NBTBase)f);
        }
        NBTTagList itemz = new NBTTagList();
        for (ItemStack item : this.items) {
            NBTTagCompound itemTag = new NBTTagCompound();
            item.writeToNBT(itemTag);
            itemz.appendTag((NBTBase)itemTag);
        }
        nbttagcompound.setTag("items", (NBTBase)itemz);
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.count = nbttagcompound.getInteger("count");
        this.beams = nbttagcompound.getInteger("beams");
        this.dimensionID = nbttagcompound.getInteger("dimensionID");
        this.returnID = nbttagcompound.getInteger("returnID");
        this.ateDevices = nbttagcompound.getBoolean("ateDevices");
        this.collapsing = nbttagcompound.getBoolean("collapsing");
        this.createdDimension = nbttagcompound.getBoolean("createdDimension");
        this.generating = nbttagcompound.getBoolean("isGenerating");
        this.cheat = nbttagcompound.getBoolean("cheat");
        AspectList al = new AspectList();
        NBTTagList tlist = nbttagcompound.getTagList("aspects", 10);
        for (int j = 0; j < tlist.tagCount(); ++j) {
            NBTTagCompound rs = tlist.getCompoundTagAt(j);
            if (!rs.hasKey("key")) continue;
            al.add(Aspect.getAspect((String)rs.getString("key")), rs.getInteger("amount"));
        }
        this.aspects = al.copy();
        this.items.clear();
        NBTTagList itemz = nbttagcompound.getTagList("items", 10);
        for (int i = 0; i < itemz.tagCount(); ++i) {
            ItemStack item = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemz.getCompoundTagAt(i));
            this.items.add(item);
        }
    }

    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        if (!this.worldObj.isRemote && this.items.size() > 0) {
            ItemStack item = this.items.get(0);
            EntityItem key = new EntityItem(this.worldObj);
            key.setEntityItemStack(item);
            key.setPosition((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
            this.worldObj.spawnEntityInWorld((Entity)key);
            this.items.remove(0);
            player.worldObj.playSound((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:wand", 0.5f, 0.9f + player.worldObj.rand.nextFloat() * 0.2f, false);
            player.swingItem();
            this.markDirty();
        }
        player.worldObj.playSound((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:wand", 0.5f, 0.9f + player.worldObj.rand.nextFloat() * 0.2f, false);
        player.swingItem();
        this.markDirty();
        return 0;
    }

    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        return null;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }

    public AspectList getAspects() {
        if (this.aspects.getAspects()[0] != null) {
            return this.aspects;
        }
        return new AspectList();
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        return 0;
    }

    public void invalidate() {
        super.invalidate();
        this.stopSound();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.stopSound();
    }

    private void stopSound() {
        if (this.worldObj != null && this.worldObj.isRemote) {
            ThaumicHorizons.proxy.stopVortexSound(this);
        }
        this.soundStarted = false;
    }
}

