/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntityItemInvulnerable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.damagesource.DamageSourceThaumcraft;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.ItemCrystalEssence;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.utils.BlockUtils;

public class ItemFocusDisintegration
extends ItemFocusBasic {
    public static FocusUpgradeType enervation = new FocusUpgradeType(FocusUpgradeType.types.length, new ResourceLocation("thaumichorizons", "textures/foci/enervation.png"), "focus.upgrade.enervation.name", "focus.upgrade.enervation.text", new AspectList().add(Aspect.DEATH, 8));
    private static final AspectList cost = new AspectList().add(Aspect.FIRE, 30).add(Aspect.ENTROPY, 30).add(Aspect.EARTH, 30);
    private static final AspectList costCritter = new AspectList().add(Aspect.FIRE, 12).add(Aspect.ENTROPY, 12).add(Aspect.EARTH, 12);
    static HashMap<String, Long> soundDelay = new HashMap();
    static HashMap<String, Object> beam = new HashMap();
    static HashMap<String, Float> breakcount = new HashMap();
    static HashMap<String, Integer> lastX = new HashMap();
    static HashMap<String, Integer> lastY = new HashMap();
    static HashMap<String, Integer> lastZ = new HashMap();

    public ItemFocusDisintegration() {
        this.setCreativeTab(ThaumicHorizons.tabTH);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumichorizons:focus_disintegration");
    }

    public String getSortingHelper(ItemStack itemstack) {
        return "DS" + super.getSortingHelper(itemstack);
    }

    public int getFocusColor() {
        return 7930047;
    }

    public boolean isVisCostPerTick() {
        return false;
    }

    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer p, MovingObjectPosition mop) {
        p.setItemInUse(itemstack, Integer.MAX_VALUE);
        return itemstack;
    }

    public void onUsingFocusTick(ItemStack stack, EntityPlayer p, int count) {
        ItemWandCasting wand = (ItemWandCasting)stack.getItem();
        int size = 2 + wand.getFocusEnlarge(stack) * 8;
        if (!wand.consumeAllVis(stack, p, this.getVisCost(stack), false, true)) {
            p.stopUsingItem();
        } else {
            String pp = "SP|" + p.getCommandSenderName();
            if (!p.worldObj.isRemote) {
                pp = "MP|" + p.getCommandSenderName();
            }
            soundDelay.putIfAbsent(pp, 0L);
            breakcount.putIfAbsent(pp, Float.valueOf(0.0f));
            lastX.putIfAbsent(pp, 0);
            lastY.putIfAbsent(pp, 0);
            lastZ.putIfAbsent(pp, 0);
            MovingObjectPosition mop = BlockUtils.getTargetBlock((World)p.worldObj, (Entity)p, (boolean)true);
            Entity ent = ItemFocusDisintegration.getPointedEntity(p.worldObj, (EntityLivingBase)p, 10.0);
            Vec3 v = p.getLookVec();
            double tx = p.posX + v.xCoord * 10.0;
            double ty = p.posY + v.yCoord * 10.0;
            double tz = p.posZ + v.zCoord * 10.0;
            int impact = 0;
            if ((ent == null || ent instanceof EntityItem && (this.getAspects(((EntityItem)ent).getEntityItem().getItem(), ((EntityItem)ent).getEntityItem().getItemDamage()) == null || this.getAspects(((EntityItem)ent).getEntityItem().getItem(), ((EntityItem)ent).getEntityItem().getItemDamage()).size() == 0)) && mop != null) {
                tx = mop.hitVec.xCoord;
                ty = mop.hitVec.yCoord;
                tz = mop.hitVec.zCoord;
                impact = 5;
                if (!p.worldObj.isRemote && soundDelay.get(pp) < System.currentTimeMillis()) {
                    p.worldObj.playSoundEffect(tx, ty, tz, "thaumcraft:zap", 0.3f, 1.0f);
                    soundDelay.put(pp, System.currentTimeMillis() + 100L);
                }
            } else if (ent != null) {
                tx = ent.posX;
                ty = ent.posY;
                tz = ent.posZ;
                impact = 5;
                if (!p.worldObj.isRemote && soundDelay.get(pp) < System.currentTimeMillis()) {
                    p.worldObj.playSoundEffect(tx, ty, tz, "thaumcraft:zap", 0.3f, 1.0f);
                    soundDelay.put(pp, System.currentTimeMillis() + 100L);
                }
            }
            if (p.worldObj.isRemote) {
                beam.put(pp, Thaumcraft.proxy.beamCont(p.worldObj, p, tx, ty, tz, 0, 7930047, false, impact > 0 ? (float)size : 0.0f, beam.get(pp), 5));
            }
            if (!(ent != null && (ent instanceof EntityLiving || ent instanceof EntityItem && ((EntityItem)ent).getEntityItem().getItem() != ConfigItems.itemCrystalEssence && this.getAspects(((EntityItem)ent).getEntityItem().getItem(), ((EntityItem)ent).getEntityItem().getItemDamage()) != null && this.getAspects(((EntityItem)ent).getEntityItem().getItem(), ((EntityItem)ent).getEntityItem().getItemDamage()).size() != 0) || mop == null || mop.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK)) {
                Block bi = p.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ);
                int md = p.worldObj.getBlockMetadata(mop.blockX, mop.blockY, mop.blockZ);
                if (Item.getItemFromBlock((Block)bi) != null && this.getAspects(Item.getItemFromBlock((Block)bi), md) != null) {
                    int pot = wand.getFocusPotency(stack);
                    float speed = 0.05f + (float)pot * 0.015f;
                    float hardness = bi.getBlockHardness(p.worldObj, mop.blockX, mop.blockY, mop.blockZ);
                    if (hardness == -1.0f) {
                        return;
                    }
                    if (lastX.get(pp) == mop.blockX && lastY.get(pp) == mop.blockY && lastZ.get(pp) == mop.blockZ) {
                        float bc = breakcount.get(pp).floatValue();
                        if (p.worldObj.isRemote && bc > 0.0f && bi != null) {
                            int gt = (int)(bc / hardness * 9.0f);
                            ThaumicHorizons.proxy.disintegrateFX(mop.blockX, mop.blockY, mop.blockZ, p, 15, size > 2);
                        }
                        if (p.worldObj.isRemote) {
                            if (bc >= hardness) {
                                p.worldObj.playAuxSFX(2001, mop.blockX, mop.blockY, mop.blockZ, 0);
                                breakcount.put(pp, Float.valueOf(0.0f));
                            } else {
                                breakcount.put(pp, Float.valueOf(bc + speed));
                            }
                        } else if (bc >= hardness) {
                            this.processBlock(mop.blockX, mop.blockY, mop.blockZ, wand, stack, p, pp);
                            if (size > 2) {
                                for (int x = -1; x < 2; ++x) {
                                    for (int y = -1; y < 2; ++y) {
                                        for (int z = -1; z < 2; ++z) {
                                            if (x == 0 && y == 0 && z == 0) continue;
                                            this.processBlock(mop.blockX + x, mop.blockY + y, mop.blockZ + z, wand, stack, p, pp);
                                        }
                                    }
                                }
                            }
                        } else {
                            breakcount.put(pp, Float.valueOf(bc + speed));
                        }
                    } else {
                        lastX.put(pp, mop.blockX);
                        lastY.put(pp, mop.blockY);
                        lastZ.put(pp, mop.blockZ);
                        breakcount.put(pp, Float.valueOf(0.0f));
                    }
                }
            } else if (ent instanceof EntityLiving && wand.consumeAllVis(stack, p, costCritter, true, true)) {
                if (this.getUpgradeLevel(wand.getFocusItem(stack), enervation) > 0) {
                    ((EntityLiving)ent).addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 40, 0));
                }
                ThaumicHorizons.proxy.disintegrateFX(ent.posX - 0.5, ent.posY, ent.posZ - 0.5, p, 5, false);
                ent.attackEntityFrom(DamageSourceThaumcraft.dissolve, 0.5f + 0.25f * (float)wand.getFocusPotency(stack) + 0.5f * (float)this.getUpgradeLevel(wand.getFocusItem(stack), enervation));
            } else if (ent instanceof EntityItem && this.getAspects(((EntityItem)ent).getEntityItem().getItem(), ((EntityItem)ent).getEntityItem().getItemDamage()) != null && this.getAspects(((EntityItem)ent).getEntityItem().getItem(), ((EntityItem)ent).getEntityItem().getItemDamage()).size() > 0) {
                int num = ((EntityItem)ent).getEntityItem().stackSize;
                if (wand.consumeAllVis(stack, p, this.getVisCost(stack), true, true)) {
                    ThaumicHorizons.proxy.disintegrateFX(ent.posX - 0.5, ent.posY, ent.posZ - 0.5, p, 5 * num, false);
                    AspectList aspects = this.getAspects(((EntityItem)ent).getEntityItem().getItem(), ((EntityItem)ent).getEntityItem().getItemDamage());
                    if (aspects != null && !p.worldObj.isRemote) {
                        if (!p.worldObj.isRemote) {
                            for (Aspect asp : aspects.getAspects()) {
                                stack = new ItemStack(ConfigItems.itemCrystalEssence, aspects.getAmount(asp) * num);
                                ((ItemCrystalEssence)stack.getItem()).setAspects(stack, new AspectList().add(asp, 1));
                                p.worldObj.spawnEntityInWorld((Entity)new EntityItemInvulnerable(p.worldObj, ent.posX, ent.posY, ent.posZ, stack));
                            }
                        } else {
                            ThaumicHorizons.proxy.disintegrateExplodeFX(p.worldObj, ent.posX, ent.posY, ent.posZ);
                        }
                    }
                }
                ent.setDead();
            } else {
                lastX.put(pp, Integer.MAX_VALUE);
                lastY.put(pp, Integer.MAX_VALUE);
                lastZ.put(pp, Integer.MAX_VALUE);
                breakcount.put(pp, Float.valueOf(0.0f));
            }
        }
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer p, int count) {
        String pp = "R" + p.getCommandSenderName();
        if (!p.worldObj.isRemote) {
            pp = "S" + p.getCommandSenderName();
        }
        soundDelay.putIfAbsent(pp, 0L);
        breakcount.putIfAbsent(pp, Float.valueOf(0.0f));
        lastX.putIfAbsent(pp, 0);
        lastY.putIfAbsent(pp, 0);
        lastZ.putIfAbsent(pp, 0);
        beam.put(pp, null);
        lastX.put(pp, Integer.MAX_VALUE);
        lastY.put(pp, Integer.MAX_VALUE);
        lastZ.put(pp, Integer.MAX_VALUE);
        breakcount.put(pp, Float.valueOf(0.0f));
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack focusstack) {
        return ItemFocusBasic.WandFocusAnimation.CHARGE;
    }

    public int getFocusColor(ItemStack focusstack) {
        return 7930047;
    }

    public AspectList getVisCost(ItemStack focusstack) {
        return cost;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        switch (rank) {
            case 1: 
            case 2: 
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, enervation};
            }
        }
        return null;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return StatCollector.translateToLocal((String)"item.focusDisintegration.name");
    }

    public static Entity getPointedEntity(World world, EntityLivingBase entityplayer, double range) {
        Entity pointedEntity = null;
        Vec3 vec3d = Vec3.createVectorHelper((double)entityplayer.posX, (double)(entityplayer.posY + (double)entityplayer.getEyeHeight()), (double)entityplayer.posZ);
        Vec3 vec3d2 = entityplayer.getLookVec();
        Vec3 vec3d3 = vec3d.addVector(vec3d2.xCoord * range, vec3d2.yCoord * range, vec3d2.zCoord * range);
        float f1 = 1.1f;
        List list = world.getEntitiesWithinAABBExcludingEntity((Entity)entityplayer, entityplayer.boundingBox.addCoord(vec3d2.xCoord * range, vec3d2.yCoord * range, vec3d2.zCoord * range).expand((double)1.1f, (double)1.1f, (double)1.1f));
        double d2 = 0.0;
        for (Object o : list) {
            double d3;
            Entity entity = (Entity)o;
            if (entity instanceof EntityItem && ((EntityItem)entity).getEntityItem().getItem() == ConfigItems.itemCrystalEssence || world.rayTraceBlocks(Vec3.createVectorHelper((double)entityplayer.posX, (double)(entityplayer.posY + (double)entityplayer.getEyeHeight()), (double)entityplayer.posZ), Vec3.createVectorHelper((double)entity.posX, (double)(entity.posY + (double)entity.getEyeHeight()), (double)entity.posZ), false) != null) continue;
            float f2 = Math.max(0.8f, entity.getCollisionBorderSize());
            AxisAlignedBB axisalignedbb = entity.boundingBox.expand((double)f2, (double)f2, (double)f2);
            MovingObjectPosition movingobjectposition = axisalignedbb.calculateIntercept(vec3d, vec3d3);
            if (axisalignedbb.isVecInside(vec3d)) {
                if (!(0.0 < d2) && d2 != 0.0) continue;
                pointedEntity = entity;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3d.distanceTo(movingobjectposition.hitVec)) < d2) && d2 != 0.0) continue;
            pointedEntity = entity;
            d2 = d3;
        }
        return pointedEntity;
    }

    void processBlock(int x, int y, int z, ItemWandCasting wand, ItemStack stack, EntityPlayer p, String pp) {
        Block bi;
        WorldSettings.GameType gt = WorldSettings.GameType.SURVIVAL;
        if (p.capabilities.allowEdit) {
            if (p.capabilities.isCreativeMode) {
                gt = WorldSettings.GameType.CREATIVE;
            }
        } else {
            gt = WorldSettings.GameType.ADVENTURE;
        }
        if ((bi = p.worldObj.getBlock(x, y, z)).getBlockHardness(p.worldObj, x, y, z) == -1.0f) {
            return;
        }
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)p.worldObj, (WorldSettings.GameType)gt, (EntityPlayerMP)((EntityPlayerMP)p), (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        int md = p.worldObj.getBlockMetadata(x, y, z);
        if (Item.getItemFromBlock((Block)bi) != null && this.getAspects(Item.getItemFromBlock((Block)bi), md) != null && this.getAspects(Item.getItemFromBlock((Block)bi), md).size() > 0 && wand.consumeAllVis(stack, p, this.getVisCost(stack), true, true)) {
            AspectList aspects = this.getAspects(Item.getItemFromBlock((Block)p.worldObj.getBlock(x, y, z)), p.worldObj.getBlockMetadata(x, y, z));
            if (aspects != null) {
                for (Aspect asp : aspects.getAspects()) {
                    stack = new ItemStack(ConfigItems.itemCrystalEssence, aspects.getAmount(asp));
                    ((ItemCrystalEssence)stack.getItem()).setAspects(stack, new AspectList().add(asp, 1));
                    p.worldObj.spawnEntityInWorld((Entity)new EntityItemInvulnerable(p.worldObj, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
                }
                ThaumicHorizons.proxy.disintegrateExplodeFX(p.worldObj, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            }
            p.worldObj.setBlockToAir(x, y, z);
        }
        lastX.put(pp, Integer.MAX_VALUE);
        lastY.put(pp, Integer.MAX_VALUE);
        lastZ.put(pp, Integer.MAX_VALUE);
        breakcount.put(pp, Float.valueOf(0.0f));
        p.worldObj.markBlockForUpdate(x, y, z);
    }

    private AspectList getAspects(Item block, int meta) {
        ItemStack tmpStack = new ItemStack(block, 1, meta);
        AspectList tmp = ThaumcraftCraftingManager.getObjectTags((ItemStack)tmpStack);
        if ((tmp = ThaumcraftCraftingManager.getBonusTags((ItemStack)tmpStack, (AspectList)tmp)) == null || tmp.size() == 0) {
            tmp = (AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(block, Short.MAX_VALUE));
            if (meta == Short.MAX_VALUE && tmp == null) {
                int index = 0;
                do {
                    tmp = (AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(block, index));
                } while (++index < 16 && tmp == null);
            }
        }
        return tmp;
    }
}

