/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntityGolemTH;
import com.kentington.thaumichorizons.common.items.ItemFocusAnimation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;

public class ItemGolemPowder
extends Item {
    @SideOnly(value=Side.CLIENT)
    public IIcon icon;

    public ItemGolemPowder() {
        this.setMaxStackSize(64);
        this.setCreativeTab(ThaumicHorizons.tabTH);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumichorizons:golempowder");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return "item.golemPowder";
    }

    public boolean onItemUse(ItemStack p_77648_1_, EntityPlayer player, World world, int p_77648_4_, int p_77648_5_, int p_77648_6_, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        Block blocky = world.getBlock(p_77648_4_, p_77648_5_, p_77648_6_);
        int md = world.getBlockMetadata(p_77648_4_, p_77648_5_, p_77648_6_);
        if (!player.canPlayerEdit(p_77648_4_, p_77648_5_, p_77648_6_, p_77648_7_, p_77648_1_)) {
            return false;
        }
        if (world.isRemote) {
            return true;
        }
        if (!blocky.hasTileEntity(md) && !blocky.isAir((IBlockAccess)world, p_77648_4_, p_77648_5_, p_77648_6_) && (blocky.isOpaqueCube() || ItemFocusAnimation.isWhitelisted(blocky, md)) && blocky.getBlockHardness(world, p_77648_4_, p_77648_5_, p_77648_6_) != -1.0f) {
            WorldSettings.GameType gt = WorldSettings.GameType.SURVIVAL;
            if (player.capabilities.allowEdit) {
                if (player.capabilities.isCreativeMode) {
                    gt = WorldSettings.GameType.CREATIVE;
                }
            } else {
                gt = WorldSettings.GameType.ADVENTURE;
            }
            if (!world.isRemote) {
                EntityGolemTH golem = new EntityGolemTH(world);
                golem.loadGolem((double)p_77648_4_ + 0.5, p_77648_5_, (double)p_77648_6_ + 0.5, blocky, md, 1200, false, false, false);
                BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)player.worldObj, (WorldSettings.GameType)gt, (EntityPlayerMP)((EntityPlayerMP)player), (int)p_77648_4_, (int)p_77648_5_, (int)p_77648_6_);
                if (event.isCanceled()) {
                    golem.setDead();
                    return false;
                }
                world.setBlockToAir(p_77648_4_, p_77648_5_, p_77648_6_);
                world.playSoundEffect((double)p_77648_4_ + 0.5, (double)p_77648_5_ + 0.5, (double)p_77648_6_ + 0.5, "thaumcraft:wand", 1.0f, 1.0f);
                golem.setHomeArea((int)golem.posX, (int)golem.posY, (int)golem.posZ, 32);
                golem.setOwner(player.getCommandSenderName());
                world.spawnEntityInWorld((Entity)golem);
                world.setEntityState((Entity)golem, (byte)7);
            } else {
                Minecraft.getMinecraft().effectRenderer.addBlockDestroyEffects(p_77648_4_, p_77648_5_, p_77648_6_, blocky, md);
                player.swingItem();
            }
            return true;
        }
        return false;
    }
}

