/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items.lenses;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.items.lenses.ILens;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class ItemLensAir
extends Item
implements ILens {
    ResourceLocation tex = new ResourceLocation("thaumichorizons", "textures/fx/ripple.png");
    ResourceLocation tex2 = new ResourceLocation("thaumichorizons", "textures/fx/vortex.png");
    IIcon icon;

    public ItemLensAir() {
        this.setCreativeTab(ThaumicHorizons.tabTH);
    }

    @Override
    public String lensName() {
        return "LensAir";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleRender(Minecraft mc, float partialTicks) {
        if (mc.gameSettings.thirdPersonView > 0) {
            return;
        }
        EntityClientPlayerMP player = mc.thePlayer;
        List critters = player.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)mc.thePlayer, AxisAlignedBB.getBoundingBox((double)(player.posX - 24.0), (double)(player.posY - 24.0), (double)(player.posZ - 24.0), (double)(player.posX + 24.0), (double)(player.posY + 24.0), (double)(player.posZ + 24.0)));
        for (Entity ent : critters) {
            Vec3 position2;
            Vec3 position;
            if (!(ent instanceof EntityLivingBase)) continue;
            Vec3 look = player.getLookVec();
            if (look.yCoord == -1.0) {
                look.xCoord = -0.1 * Math.sin(Math.toRadians(player.rotationYaw));
                look.yCoord = -0.999;
                look.zCoord = 0.1 * Math.cos(Math.toRadians(player.rotationYaw));
            } else if (look.yCoord == 1.0) {
                look.xCoord = -0.1 * Math.sin(Math.toRadians(player.rotationYaw));
                look.yCoord = 0.999;
                look.zCoord = 0.1 * Math.cos(Math.toRadians(player.rotationYaw));
            }
            Vec3 playerPos = position = player.getPosition(partialTicks);
            position.yCoord += (double)(player.yOffset - player.height + player.getEyeHeight());
            Vec3 entityPos = position2 = ((EntityLivingBase)ent).getPosition(partialTicks);
            position2.yCoord += (double)(ent.yOffset + ent.height / 2.0f);
            Vec3 pos = entityPos.subtract(playerPos);
            double scale = pos.lengthVector();
            double dot = pos.dotProduct(look);
            if (dot >= 0.0) continue;
            Vec3 proj = Vec3.createVectorHelper((double)(look.xCoord * dot), (double)(look.yCoord * dot), (double)(look.zCoord * dot));
            Vec3 rej = Vec3.createVectorHelper((double)(pos.xCoord - proj.xCoord), (double)(pos.yCoord - proj.yCoord), (double)(pos.zCoord - proj.zCoord));
            Vec3 right = look.crossProduct(Vec3.createVectorHelper((double)1.0E-4, (double)-1.0, (double)1.0E-4));
            right = right.normalize();
            Vec3 up = right.crossProduct(look);
            up = up.normalize();
            double vert = rej.dotProduct(up);
            double horiz = rej.dotProduct(right);
            ScaledResolution var5 = new ScaledResolution(mc, mc.displayWidth, mc.displayHeight);
            int var6 = var5.getScaledWidth();
            int var7 = var5.getScaledHeight();
            float minScreen = Math.min(var6, var7);
            double hScale = proj.lengthVector() * Math.tan(Math.toRadians(mc.gameSettings.fovSetting) / 2.0) * 2.0;
            horiz /= hScale;
            vert = vert / hScale / (double)var7 * (double)var6;
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)518, (float)0.005f);
            float minEnt = Math.min(ent.width, ent.height);
            double size = (double)minEnt * ((double)minScreen / scale);
            double xCenter = (double)var6 * (1.0 + horiz) / 2.0;
            double yCenter = (double)var7 * (1.0 - vert) / 2.0;
            Tessellator t = Tessellator.instance;
            if (((EntityLivingBase)ent).getCreatureAttribute() != EnumCreatureAttribute.UNDEAD) {
                FMLClientHandler.instance().getClient().renderEngine.bindTexture(this.tex);
                float sizeOffset = ent.ticksExisted % 16;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.3f - (float)scale / 80.0f));
                int numRipples = (int)(48.0 / scale + 1.0);
                if (numRipples > 4) {
                    numRipples = 4;
                }
                for (int i = 0; i < numRipples; ++i) {
                    double ripSize = size * (double)(((float)(i * 16 / (numRipples + 1)) + sizeOffset) % 16.0f) / 12.0;
                    t.startDrawingQuads();
                    t.addVertexWithUV(xCenter - ripSize, yCenter + ripSize, 1.0, 0.0, 1.0);
                    t.addVertexWithUV(xCenter + ripSize, yCenter + ripSize, 1.0, 1.0, 1.0);
                    t.addVertexWithUV(xCenter + ripSize, yCenter - ripSize, 1.0, 1.0, 0.0);
                    t.addVertexWithUV(xCenter - ripSize, yCenter - ripSize, 1.0, 0.0, 0.0);
                    t.draw();
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.1f - (float)scale / 240.0f));
                size *= 2.0;
                FMLClientHandler.instance().getClient().renderEngine.bindTexture(this.tex2);
                double angle = Math.toRadians(ent.ticksExisted % 360);
                double sin = Math.sin(angle);
                double cos = Math.cos(angle);
                GL11.glPushMatrix();
                t.startDrawingQuads();
                t.addVertexWithUV(xCenter - size * sin, yCenter + size * cos, 1.0, 0.0, 0.0);
                t.addVertexWithUV(xCenter + size * cos, yCenter + size * sin, 1.0, 1.0, 0.0);
                t.addVertexWithUV(xCenter + size * sin, yCenter - size * cos, 1.0, 1.0, 1.0);
                t.addVertexWithUV(xCenter - size * cos, yCenter - size * sin, 1.0, 0.0, 1.0);
                t.draw();
                GL11.glPopMatrix();
                double sin2 = Math.sin(-angle);
                double cos2 = Math.cos(-angle);
                GL11.glPushMatrix();
                t.startDrawingQuads();
                t.addVertexWithUV(xCenter - size * sin2 / 2.0, yCenter + size * cos2 / 2.0, 1.0, 0.0, 0.0);
                t.addVertexWithUV(xCenter + size * cos2 / 2.0, yCenter + size * sin2 / 2.0, 1.0, 1.0, 0.0);
                t.addVertexWithUV(xCenter + size * sin2 / 2.0, yCenter - size * cos2 / 2.0, 1.0, 1.0, 1.0);
                t.addVertexWithUV(xCenter - size * cos2 / 2.0, yCenter - size * sin2 / 2.0, 1.0, 0.0, 1.0);
                t.draw();
                GL11.glPopMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return "item.LensAir";
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumichorizons:lensair");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    @Override
    public void handleRemoval(EntityPlayer p) {
    }
}

