/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items.lenses;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.items.lenses.ILens;
import com.kentington.thaumichorizons.common.items.lenses.LensManager;
import com.kentington.thaumichorizons.common.lib.networking.PacketHandler;
import com.kentington.thaumichorizons.common.lib.networking.PacketRemoveNightvision;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;

public class ItemLensFire
extends Item
implements ILens {
    IIcon icon;

    public ItemLensFire() {
        this.setCreativeTab(ThaumicHorizons.tabTH);
    }

    @Override
    public String lensName() {
        return "LensFire";
    }

    @Override
    public void handleRender(Minecraft mc, float partialTicks) {
        boolean inWater = mc.thePlayer.isInsideOfMaterial(Material.water);
        PotionEffect effect = mc.thePlayer.getActivePotionEffect(Potion.nightVision);
        if (!inWater) {
            if ((effect == null || ItemLensFire.isEffectGrantedByLens(effect) && effect.getDuration() < 242) && Minecraft.getSystemTime() > LensManager.nightVisionOffTime) {
                LensManager.nightVisionOffTime = Minecraft.getSystemTime();
                mc.thePlayer.addPotionEffect((PotionEffect)new IlluminePotionEffect(Potion.nightVision.id, 255, -1, true));
            }
        } else if (ItemLensFire.isEffectGrantedByLens(effect)) {
            mc.thePlayer.removePotionEffect(Potion.nightVision.id);
        }
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return "item.LensFire";
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumichorizons:lensfire");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    @Override
    public void handleRemoval(EntityPlayer p) {
        if (ItemLensFire.isEffectGrantedByLens(p.getActivePotionEffect(Potion.nightVision))) {
            p.removePotionEffect(Potion.nightVision.id);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketRemoveNightvision(), (EntityPlayerMP)p);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEffectGrantedByLens(PotionEffect effect) {
        if (!(effect instanceof IlluminePotionEffect)) return false;
        IlluminePotionEffect illumineEffect = (IlluminePotionEffect)effect;
        if (!illumineEffect.isGrantedByLens) return false;
        return true;
    }

    private static class IlluminePotionEffect
    extends PotionEffect {
        public boolean isGrantedByLens = true;

        public IlluminePotionEffect(int potionID, int duration, int amplifier, boolean isAmbient) {
            super(potionID, duration, amplifier, isAmbient);
        }

        public void combine(PotionEffect effect) {
            super.combine(effect);
            this.isGrantedByLens = effect instanceof IlluminePotionEffect;
        }
    }
}

