/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.lib;

import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntityGolemTH;
import com.kentington.thaumichorizons.common.entities.EntityMeatSlime;
import com.kentington.thaumichorizons.common.entities.EntityMercurialSlime;
import com.kentington.thaumichorizons.common.entities.EntityNightmare;
import com.kentington.thaumichorizons.common.entities.EntityVoltSlime;
import com.kentington.thaumichorizons.common.entities.ai.EntityAIAttackOnCollideTH;
import com.kentington.thaumichorizons.common.entities.ai.EntityAIFollowOwnerTH;
import com.kentington.thaumichorizons.common.entities.ai.EntityAIHurtByTargetTH;
import com.kentington.thaumichorizons.common.entities.ai.EntityAIOwnerHurtByTargetTH;
import com.kentington.thaumichorizons.common.entities.ai.EntityAIOwnerHurtTargetTH;
import com.kentington.thaumichorizons.common.entities.ai.EntityAISitTH;
import com.kentington.thaumichorizons.common.entities.ai.EntityAIWanderTH;
import com.kentington.thaumichorizons.common.items.ItemAmuletMirror;
import com.kentington.thaumichorizons.common.items.ItemFocusContainment;
import com.kentington.thaumichorizons.common.lib.EntityInfusionProperties;
import com.kentington.thaumichorizons.common.lib.networking.PacketFXContainment;
import com.kentington.thaumichorizons.common.lib.networking.PacketHandler;
import com.kentington.thaumichorizons.common.lib.networking.PacketNoMoreItems;
import com.kentington.thaumichorizons.common.lib.networking.PacketPlayerInfusionSync;
import com.kentington.thaumichorizons.common.tiles.TileSoulBeacon;
import com.kentington.thaumichorizons.common.tiles.TileVat;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.damagesource.DamageSourceThaumcraft;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.EntityAspectOrb;
import thaumcraft.common.entities.EntityFollowingItem;
import thaumcraft.common.entities.EntityPermanentItem;
import thaumcraft.common.items.relics.ItemHandMirror;
import thaumcraft.common.lib.network.fx.PacketFXShield;
import thaumcraft.common.lib.utils.EntityUtils;

public class EventHandlerEntity {
    @SideOnly(value=Side.CLIENT)
    public static int clientNightmareID;
    @SideOnly(value=Side.CLIENT)
    public static int clientPlayerID;

    @SubscribeEvent
    public void ConstructEntity(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase && event.entity.getExtendedProperties("CreatureInfusion") == null) {
            EntityInfusionProperties prop = new EntityInfusionProperties();
            prop.entity = event.entity;
            event.entity.registerExtendedProperties("CreatureInfusion", (IExtendedEntityProperties)prop);
        }
    }

    @SubscribeEvent
    public void EntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityLivingBase) {
            this.applyInfusions((EntityLivingBase)event.entity);
        }
        if (event.world.isRemote && event.entity instanceof EntityNightmare && event.entity.getEntityId() == clientNightmareID) {
            event.entity.worldObj.getEntityByID((int)EventHandlerEntity.clientPlayerID).ridingEntity = event.entity;
            event.entity.riddenByEntity = event.entity.worldObj.getEntityByID(clientPlayerID);
            clientNightmareID = -2;
            clientPlayerID = -2;
        }
    }

    @SubscribeEvent
    public void Respawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.worldObj.isRemote) {
            this.applyInfusions((EntityLivingBase)event.player);
        }
    }

    public void applyInfusions(EntityLivingBase entity) {
        EntityInfusionProperties infusionProperties = (EntityInfusionProperties)entity.getExtendedProperties("CreatureInfusion");
        if (entity instanceof EntityPlayer) {
            int[] infusions;
            for (int infusion : infusions = infusionProperties.getPlayerInfusions()) {
                if (infusion == 0 || infusion != 8 || entity.worldObj.isRemote) continue;
                this.warpTumor((EntityPlayer)entity, ThaumicHorizons.warpedTumorValue - infusionProperties.tumorWarpPermanent - infusionProperties.tumorWarp - infusionProperties.tumorWarpTemp);
            }
            this.applyPlayerPotionInfusions((EntityPlayer)entity, infusions, infusionProperties.toggleInvisible);
            if (!entity.worldObj.isRemote) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketPlayerInfusionSync(entity.getCommandSenderName(), infusions, infusionProperties.toggleClimb, infusionProperties.toggleInvisible));
            }
        } else {
            int[] infusions = infusionProperties.getInfusions();
            for (int i = 0; i < 12; ++i) {
                PotionEffect effect;
                if (infusions[i] == 0) continue;
                if (infusions[i] == 1) {
                    effect = new PotionEffect(Potion.jump.id, Integer.MAX_VALUE, 0, true);
                    effect.setCurativeItems(new ArrayList());
                    entity.addPotionEffect(effect);
                    continue;
                }
                if (infusions[i] == 3) {
                    effect = new PotionEffect(Potion.regeneration.id, Integer.MAX_VALUE, 0, true);
                    effect.setCurativeItems(new ArrayList());
                    entity.addPotionEffect(effect);
                    continue;
                }
                if (infusions[i] == 4) {
                    effect = new PotionEffect(Potion.resistance.id, Integer.MAX_VALUE, 0, true);
                    effect.setCurativeItems(new ArrayList());
                    entity.addPotionEffect(effect);
                    ThaumicHorizons.instance.renderEventHandler.thingsThatSparkle.add(entity);
                    continue;
                }
                if (infusions[i] == 8 && !entity.getEntityData().hasKey("runicCharge")) {
                    entity.getEntityData().setInteger("runicCharge", 6);
                    continue;
                }
                if (infusions[i] != 7) continue;
                this.applyNewAI((EntityLiving)entity);
            }
        }
    }

    public void applyPlayerPotionInfusions(EntityPlayer entity, int[] infusions, boolean toggled) {
        for (int infusion : infusions) {
            PotionEffect effect;
            if (infusion == 1) {
                effect = new PotionEffect(Potion.jump.id, Integer.MAX_VALUE, 0, true);
                effect.setCurativeItems(new ArrayList());
                entity.addPotionEffect(effect);
                effect = new PotionEffect(Potion.moveSpeed.id, Integer.MAX_VALUE, 0, true);
                effect.setCurativeItems(new ArrayList());
                entity.addPotionEffect(effect);
                continue;
            }
            if (infusion == 3) {
                effect = new PotionEffect(Potion.regeneration.id, Integer.MAX_VALUE, 0, true);
                effect.setCurativeItems(new ArrayList());
                entity.addPotionEffect(effect);
                continue;
            }
            if (infusion == 4) {
                effect = new PotionEffect(Potion.resistance.id, Integer.MAX_VALUE, 0, true);
                effect.setCurativeItems(new ArrayList());
                entity.addPotionEffect(effect);
                continue;
            }
            if (infusion != 10 || toggled) continue;
            effect = new PotionEffect(Potion.invisibility.id, Integer.MAX_VALUE, 0, true);
            effect.setCurativeItems(new ArrayList());
            entity.addPotionEffect(effect);
            entity.setInvisible(true);
        }
    }

    public void warpTumor(EntityPlayer entity, int capacity) {
        if (capacity <= 0) {
            return;
        }
        int warpPermanent = Thaumcraft.proxy.getPlayerKnowledge().getWarpPerm(entity.getCommandSenderName());
        int warp = Thaumcraft.proxy.getPlayerKnowledge().getWarpSticky(entity.getCommandSenderName());
        int tempWarp = Thaumcraft.proxy.getPlayerKnowledge().getWarpTemp(entity.getCommandSenderName());
        if (warpPermanent > capacity) {
            Thaumcraft.proxy.getPlayerKnowledge().addWarpPerm(entity.getCommandSenderName(), -capacity);
            EntityInfusionProperties entityInfusionProperties = (EntityInfusionProperties)entity.getExtendedProperties("CreatureInfusion");
            entityInfusionProperties.tumorWarpPermanent += capacity;
            capacity = 0;
        } else {
            Thaumcraft.proxy.getPlayerKnowledge().addWarpPerm(entity.getCommandSenderName(), -warpPermanent);
            EntityInfusionProperties entityInfusionProperties2 = (EntityInfusionProperties)entity.getExtendedProperties("CreatureInfusion");
            entityInfusionProperties2.tumorWarpPermanent += warpPermanent;
            if (warp > (capacity -= warpPermanent)) {
                Thaumcraft.proxy.getPlayerKnowledge().addWarpSticky(entity.getCommandSenderName(), -capacity);
                EntityInfusionProperties entityInfusionProperties3 = (EntityInfusionProperties)entity.getExtendedProperties("CreatureInfusion");
                entityInfusionProperties3.tumorWarp += capacity;
                capacity = 0;
            } else {
                Thaumcraft.proxy.getPlayerKnowledge().addWarpSticky(entity.getCommandSenderName(), -warp);
                EntityInfusionProperties entityInfusionProperties4 = (EntityInfusionProperties)entity.getExtendedProperties("CreatureInfusion");
                entityInfusionProperties4.tumorWarp += warp;
                if (tempWarp > (capacity -= warp)) {
                    Thaumcraft.proxy.getPlayerKnowledge().addWarpTemp(entity.getCommandSenderName(), -capacity);
                    EntityInfusionProperties entityInfusionProperties5 = (EntityInfusionProperties)entity.getExtendedProperties("CreatureInfusion");
                    entityInfusionProperties5.tumorWarpTemp += capacity;
                    capacity = 0;
                } else {
                    capacity -= tempWarp;
                    Thaumcraft.proxy.getPlayerKnowledge().addWarpTemp(entity.getCommandSenderName(), -tempWarp);
                    EntityInfusionProperties entityInfusionProperties6 = (EntityInfusionProperties)entity.getExtendedProperties("CreatureInfusion");
                    entityInfusionProperties6.tumorWarpTemp += tempWarp;
                }
            }
        }
    }

    public void applyNewAI(EntityLiving entity) {
        this.removeTasks(entity.tasks);
        this.removeTasks(entity.targetTasks);
        entity.tasks.addTask(1, (EntityAIBase)new EntityAISwimming(entity));
        entity.tasks.addTask(2, (EntityAIBase)new EntityAISitTH(entity));
        entity.tasks.addTask(3, (EntityAIBase)new EntityAILeapAtTarget(entity, 0.4f));
        entity.tasks.addTask(4, (EntityAIBase)new EntityAIAttackOnCollideTH(entity, 1.0, true));
        entity.tasks.addTask(5, (EntityAIBase)new EntityAIFollowOwnerTH(entity, 1.0, 10.0f, 2.0f));
        if (entity instanceof EntityAnimal) {
            entity.tasks.addTask(6, (EntityAIBase)new EntityAIMate((EntityAnimal)entity, 1.0));
        }
        entity.tasks.addTask(7, (EntityAIBase)new EntityAIWanderTH(entity, 1.0));
        entity.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest(entity, EntityPlayer.class, 8.0f));
        entity.tasks.addTask(9, (EntityAIBase)new EntityAILookIdle(entity));
        entity.targetTasks.addTask(1, (EntityAIBase)new EntityAIOwnerHurtByTargetTH(entity));
        entity.targetTasks.addTask(2, (EntityAIBase)new EntityAIOwnerHurtTargetTH(entity));
        entity.targetTasks.addTask(3, (EntityAIBase)new EntityAIHurtByTargetTH(entity, true));
    }

    private void removeTasks(EntityAITasks entityAITasks) {
        ArrayList taskEntries = new ArrayList(entityAITasks.taskEntries);
        for (Object task : taskEntries) {
            EntityAITasks.EntityAITaskEntry taskEntry = (EntityAITasks.EntityAITaskEntry)task;
            entityAITasks.removeTask(taskEntry.action);
        }
    }

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent event) {
        ArrayList stuff2;
        EntityLivingBase target;
        int boost2;
        EntityLivingBase player2;
        ArrayList stuff;
        boolean runic;
        Entity entity = event.entity;
        if (entity instanceof EntityPlayer) {
            EntityInfusionProperties prop;
            EntityPlayer player = (EntityPlayer)entity;
            String pp = "R" + player.getDisplayName();
            if (ItemFocusContainment.hitCritters.containsKey(pp)) {
                ItemFocusContainment.contain.put(pp, Float.valueOf(ItemFocusContainment.contain.get(pp).floatValue() - 1.0f));
                if (ItemFocusContainment.contain.get(pp).floatValue() > 0.0f) {
                    Entity ent = ItemFocusContainment.hitCritters.get(pp);
                    ThaumicHorizons.proxy.containmentFX(ent.posX, ent.posY, ent.posZ, player, ent, (int)(ItemFocusContainment.contain.get(pp).floatValue() / ((EntityLiving)ent).getHealth()) / 3 + 1);
                } else {
                    ItemFocusContainment.contain.remove(pp);
                    ItemFocusContainment.hitCritters.remove(pp);
                }
            }
            if ((prop = (EntityInfusionProperties)player.getExtendedProperties("CreatureInfusion")).hasPlayerInfusion(5) && (player.getActivePotionEffect(Potion.poison) != null || player.getActivePotionEffect(Potion.wither) != null || player.getActivePotionEffect(Potion.potionTypes[Config.potionInfVisExhaustID]) != null || player.getActivePotionEffect(Potion.potionTypes[Config.potionVisExhaustID]) != null || player.getActivePotionEffect(Potion.potionTypes[Config.potionThaumarhiaID]) != null || player.getActivePotionEffect(Potion.potionTypes[Config.potionTaintPoisonID]) != null)) {
                Collection activePotionEffects = event.entityLiving.getActivePotionEffects();
                ArrayList<PotionEffect> toAdd = new ArrayList<PotionEffect>();
                for (Object activePotionEffect : activePotionEffects) {
                    PotionEffect effect = (PotionEffect)activePotionEffect;
                    if (effect.getPotionID() == Potion.poison.id || effect.getPotionID() == Potion.wither.id || effect.getPotionID() == Config.potionInfVisExhaustID || effect.getPotionID() == Config.potionTaintPoisonID || effect.getPotionID() == Config.potionVisExhaustID || effect.getPotionID() == Config.potionThaumarhiaID) {
                        int id = effect.getPotionID();
                        boolean amplifier = false;
                        int duration = effect.getDuration() - 1;
                        toAdd.add(new PotionEffect(id, duration, 0, false));
                        continue;
                    }
                    toAdd.add(effect);
                }
                event.entityLiving.clearActivePotions();
                for (PotionEffect effect : toAdd) {
                    event.entityLiving.addPotionEffect(effect);
                }
            }
            if (prop.hasPlayerInfusion(6) && event.entity.ticksExisted % 200 == 0 && player.worldObj.isDaytime() && player.worldObj.canBlockSeeTheSky(MathHelper.floor_double((double)player.posX), MathHelper.floor_double((double)player.posY), MathHelper.floor_double((double)player.posZ))) {
                player.getFoodStats().addStats(1, 0.0f);
            }
            if (prop.hasPlayerInfusion(7) && player.isInWater()) {
                player.setAir(300);
            }
            if (event.entityLiving.ticksExisted % 30 == 0) {
                if (prop.hasPlayerInfusion(8) && !event.entityLiving.worldObj.isRemote) {
                    this.warpTumor((EntityPlayer)event.entityLiving, ThaumicHorizons.warpedTumorValue - prop.tumorWarpPermanent - prop.tumorWarp - prop.tumorWarpTemp);
                }
                this.applyPlayerPotionInfusions(player, prop.playerInfusions, prop.toggleInvisible);
            }
            if (prop.hasPlayerInfusion(9) && !prop.toggleClimb) {
                if (event.entityLiving.isCollidedHorizontally) {
                    event.entityLiving.motionY = 0.2;
                    if (event.entityLiving.isSneaking()) {
                        event.entityLiving.motionY = 0.0;
                    }
                    event.entity.fallDistance = 0.0f;
                } else {
                    List listy = event.entityLiving.worldObj.func_147461_a(AxisAlignedBB.getBoundingBox((double)(event.entityLiving.posX - (double)event.entityLiving.width / 1.5), (double)event.entityLiving.posY, (double)(event.entityLiving.posZ - (double)event.entityLiving.width / 1.5), (double)(event.entityLiving.posX + (double)event.entityLiving.width / 1.5), (double)(event.entityLiving.posY + (double)event.entityLiving.height * 0.9), (double)(event.entityLiving.posZ + (double)event.entityLiving.width / 1.5)));
                    if (listy.size() > 0) {
                        event.entityLiving.motionY = event.entityLiving.isSneaking() ? 0.0 : -0.15;
                        event.entity.fallDistance = 0.0f;
                    }
                }
            }
        }
        if (event.entityLiving.ticksExisted % 30 == 0) {
            boolean shock = ((EntityInfusionProperties)event.entityLiving.getExtendedProperties("CreatureInfusion")).hasInfusion(6);
            if (shock && event.entityLiving.getAITarget() != null) {
                event.entityLiving.getAITarget().attackEntityFrom(DamageSource.magic, 1.0f);
                Thaumcraft.proxy.arcLightning(event.entityLiving.worldObj, event.entityLiving.posX, event.entityLiving.posY + (double)(event.entityLiving.height / 2.0f), event.entityLiving.posZ, event.entityLiving.getAITarget().posX, event.entityLiving.getAITarget().posY + (double)(event.entityLiving.getAITarget().height / 2.0f), event.entityLiving.getAITarget().posZ, 0.2f, 0.8f, 0.8f, 1.0f);
                event.entityLiving.worldObj.playSoundAtEntity((Entity)event.entityLiving, "thaumcraft:zap", 1.0f, 1.0f + (event.entityLiving.worldObj.rand.nextFloat() - event.entityLiving.worldObj.rand.nextFloat()) * 0.2f);
            } else if (shock && event.entityLiving instanceof EntityLiving && ((EntityLiving)event.entityLiving).getAttackTarget() != null) {
                ((EntityLiving)event.entityLiving).getAttackTarget().attackEntityFrom(DamageSource.magic, 1.0f);
                Thaumcraft.proxy.arcLightning(event.entityLiving.worldObj, event.entityLiving.posX, event.entityLiving.posY + (double)(event.entityLiving.height / 2.0f), event.entityLiving.posZ, ((EntityLiving)event.entityLiving).getAttackTarget().posX, ((EntityLiving)event.entityLiving).getAttackTarget().posY + (double)(((EntityLiving)event.entityLiving).getAttackTarget().height / 2.0f), ((EntityLiving)event.entityLiving).getAttackTarget().posZ, 0.2f, 0.8f, 0.8f, 1.0f);
                event.entityLiving.worldObj.playSoundAtEntity((Entity)event.entityLiving, "thaumcraft:zap", 1.0f, 1.0f + (event.entityLiving.worldObj.rand.nextFloat() - event.entityLiving.worldObj.rand.nextFloat()) * 0.2f);
            }
        }
        if (event.entityLiving instanceof EntityVoltSlime && event.entityLiving.ticksExisted % 2 == 0 && event.entityLiving.getAITarget() != null) {
            event.entityLiving.getAITarget().attackEntityFrom(DamageSource.magic, 0.5f);
            Thaumcraft.proxy.arcLightning(event.entityLiving.worldObj, event.entityLiving.posX, event.entityLiving.posY + (double)(event.entityLiving.height / 2.0f), event.entityLiving.posZ, event.entityLiving.getAITarget().posX, event.entityLiving.getAITarget().posY + (double)(event.entityLiving.getAITarget().height / 2.0f), event.entityLiving.getAITarget().posZ, 0.2f, 0.8f, 0.8f, 1.0f);
            event.entityLiving.worldObj.playSoundAtEntity((Entity)event.entityLiving, "thaumcraft:zap", 1.0f, 1.0f + (event.entityLiving.worldObj.rand.nextFloat() - event.entityLiving.worldObj.rand.nextFloat()) * 0.2f);
        }
        if (event.entityLiving.ticksExisted % 100 == 0 && (runic = ((EntityInfusionProperties)event.entityLiving.getExtendedProperties("CreatureInfusion")).hasInfusion(8))) {
            int charge = event.entityLiving.getEntityData().getInteger("runicCharge") + 1;
            if (charge > 6) {
                charge = 6;
            }
            event.entityLiving.getEntityData().setInteger("runicCharge", charge);
        }
        if (((EntityLivingBase)event.entity).isPotionActive(ThaumicHorizons.potionShockID) && (stuff = EntityUtils.getEntitiesInRange((World)player2.worldObj, (double)player2.posX, (double)player2.posY, (double)player2.posZ, (Entity)(player2 = (EntityLivingBase)event.entity), EntityLivingBase.class, (double)10.0)) != null && stuff.size() > 0) {
            int boost = player2.getActivePotionEffect(Potion.potionTypes[ThaumicHorizons.potionShockID]).getAmplifier();
            for (Entity e : stuff) {
                int r = player2.worldObj.rand.nextInt(1000);
                if (r >= 20 * (1 + boost) || e.isDead || !(e instanceof EntityLivingBase)) continue;
                if (player2 instanceof EntityPlayer) {
                    e.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)((EntityPlayer)player2)), 1.0f);
                } else {
                    e.attackEntityFrom(DamageSource.magic, 1.0f);
                }
                Thaumcraft.proxy.arcLightning(player2.worldObj, player2.posX, player2.posY + (double)(player2.height / 2.0f), player2.posZ, e.posX, e.posY + (double)(e.height / 2.0f), e.posZ, 0.2f, 0.8f, 0.8f, 1.0f);
                player2.worldObj.playSoundAtEntity((Entity)player2, "thaumcraft:zap", 1.0f, 1.0f + (player2.worldObj.rand.nextFloat() - player2.worldObj.rand.nextFloat()) * 0.2f);
            }
        }
        if (((EntityLivingBase)event.entity).isPotionActive(ThaumicHorizons.potionVisRegenID) && event.entity.ticksExisted % (20 - 3 * (boost2 = (target = (EntityLivingBase)event.entity).getActivePotionEffect(Potion.potionTypes[ThaumicHorizons.potionVisRegenID]).getAmplifier())) == 0) {
            Aspect aspect = null;
            switch (target.worldObj.rand.nextInt(6)) {
                case 0: {
                    aspect = Aspect.AIR;
                    break;
                }
                case 1: {
                    aspect = Aspect.EARTH;
                    break;
                }
                case 2: {
                    aspect = Aspect.FIRE;
                    break;
                }
                case 3: {
                    aspect = Aspect.WATER;
                    break;
                }
                case 4: {
                    aspect = Aspect.ORDER;
                    break;
                }
                case 5: {
                    aspect = Aspect.ENTROPY;
                }
            }
            if (aspect != null) {
                EntityAspectOrb orb = new EntityAspectOrb(target.worldObj, target.posX, target.posY, target.posZ, aspect, 1);
                target.worldObj.spawnEntityInWorld((Entity)orb);
            }
        }
        if (((EntityLivingBase)event.entity).isPotionActive(ThaumicHorizons.potionVacuumID) && (stuff2 = EntityUtils.getEntitiesInRange((World)player2.worldObj, (double)player2.posX, (double)player2.posY, (double)player2.posZ, (Entity)(player2 = (EntityLivingBase)event.entity), EntityItem.class, (double)(10.0 + (double)(2 * (boost2 = player2.getActivePotionEffect(Potion.potionTypes[ThaumicHorizons.potionVacuumID]).getAmplifier()))))) != null && stuff2.size() > 0) {
            for (Entity e : stuff2) {
                if (e instanceof EntityFollowingItem && ((EntityFollowingItem)e).target != null || e.isDead || !(e instanceof EntityItem)) continue;
                double d6 = e.posX - player2.posX;
                double d7 = e.posY - player2.posY + (double)(player2.height / 2.0f);
                double d8 = e.posZ - player2.posZ;
                double d9 = MathHelper.sqrt_double((double)(d6 * d6 + d7 * d7 + d8 * d8));
                double d10 = 0.1;
                e.motionX -= (d6 /= d9) * 0.1;
                e.motionY -= (d7 /= d9) * 0.1;
                e.motionZ -= (d8 /= d9) * 0.1;
                if (e.motionX > 0.35) {
                    e.motionX = 0.35;
                }
                if (e.motionX < -0.35) {
                    e.motionX = -0.35;
                }
                if (e.motionY > 0.35) {
                    e.motionY = 0.35;
                }
                if (e.motionY < -0.35) {
                    e.motionY = -0.35;
                }
                if (e.motionZ > 0.35) {
                    e.motionZ = 0.35;
                }
                if (e.motionZ < -0.35) {
                    e.motionZ = -0.35;
                }
                Thaumcraft.proxy.spark((float)e.posX + (player2.worldObj.rand.nextFloat() - player2.worldObj.rand.nextFloat()) * 0.125f, (float)e.posY + (player2.worldObj.rand.nextFloat() - player2.worldObj.rand.nextFloat()) * 0.125f, (float)e.posZ + (player2.worldObj.rand.nextFloat() - player2.worldObj.rand.nextFloat()) * 0.125f, 1.0f, 0.25f, 0.25f, 0.25f, 1.0f);
            }
        }
        if (((EntityLivingBase)event.entity).isPotionActive(ThaumicHorizons.potionSynthesisID) && event.entity.ticksExisted % (15 - 2 * (boost2 = (player2 = (EntityLivingBase)event.entity).getActivePotionEffect(Potion.potionTypes[ThaumicHorizons.potionSynthesisID]).getAmplifier())) == 0 && player2.worldObj.isDaytime() && player2.worldObj.canBlockSeeTheSky(MathHelper.floor_double((double)player2.posX), MathHelper.floor_double((double)player2.posY), MathHelper.floor_double((double)player2.posZ))) {
            player2.heal(0.5f);
            if (player2 instanceof EntityPlayer) {
                ((EntityPlayer)player2).getFoodStats().addStats(1, 0.5f);
            }
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        if (!event.entityLiving.worldObj.isRemote) {
            EntityInfusionProperties prop;
            if (event.entityLiving instanceof EntityMeatSlime && ((EntityMeatSlime)event.entityLiving).getSlimeSize() == 1) {
                switch (event.entityLiving.worldObj.rand.nextInt(5)) {
                    case 0: {
                        event.entityLiving.entityDropItem(new ItemStack(Items.beef), 0.0f);
                        break;
                    }
                    case 1: {
                        event.entityLiving.entityDropItem(new ItemStack(Items.porkchop), 0.0f);
                        break;
                    }
                    case 2: {
                        event.entityLiving.entityDropItem(new ItemStack(Items.chicken), 0.0f);
                        break;
                    }
                    case 3: {
                        event.entityLiving.entityDropItem(new ItemStack(Items.fish), 0.0f);
                        break;
                    }
                    default: {
                        event.entityLiving.entityDropItem(new ItemStack(Items.rotten_flesh), 0.0f);
                        break;
                    }
                }
            } else if (event.entityLiving instanceof EntityMercurialSlime && ((EntityMercurialSlime)event.entityLiving).getSlimeSize() == 1) {
                event.entityLiving.entityDropItem(new ItemStack(ConfigItems.itemResource, 1, 3), 0.0f);
            } else if (event.entityLiving instanceof EntityPlayer && (prop = (EntityInfusionProperties)event.entity.getExtendedProperties("CreatureInfusion")) != null) {
                if (prop.tumorWarpPermanent > 0 || prop.tumorWarp > 0 || prop.tumorWarpTemp > 0) {
                    Thaumcraft.proxy.getPlayerKnowledge().addWarpPerm(event.entity.getCommandSenderName(), prop.tumorWarpPermanent);
                    Thaumcraft.proxy.getPlayerKnowledge().addWarpSticky(event.entity.getCommandSenderName(), prop.tumorWarp);
                    Thaumcraft.proxy.getPlayerKnowledge().addWarpTemp(event.entity.getCommandSenderName(), prop.tumorWarpTemp);
                }
                prop.resetPlayerInfusions();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
        Entity entity;
        EntityInfusionProperties prop = (EntityInfusionProperties)event.entity.getExtendedProperties("CreatureInfusion");
        if (prop.hasPlayerInfusion(5) && event.source == DamageSourceThaumcraft.taint) {
            event.setCanceled(true);
            event.ammount = 0.0f;
            return;
        }
        if (!event.entity.worldObj.isRemote && (entity = event.entity) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (event.entityLiving.getHealth() - event.ammount <= 0.0f) {
                if (prop.tumorWarpPermanent > 0 || prop.tumorWarp > 0 || prop.tumorWarpTemp > 0) {
                    Thaumcraft.proxy.getPlayerKnowledge().addWarpPerm(event.entity.getCommandSenderName(), prop.tumorWarpPermanent);
                    Thaumcraft.proxy.getPlayerKnowledge().addWarpSticky(event.entity.getCommandSenderName(), prop.tumorWarp);
                    Thaumcraft.proxy.getPlayerKnowledge().addWarpTemp(event.entity.getCommandSenderName(), prop.tumorWarpTemp);
                }
                prop.resetPlayerInfusions();
                ItemStack amulet = null;
                for (ItemStack bauble : PlayerHandler.getPlayerBaubles((EntityPlayer)player).stackList) {
                    if (bauble == null || !(bauble.getItem() instanceof ItemAmuletMirror)) continue;
                    amulet = bauble;
                    break;
                }
                if (amulet != null) {
                    int i;
                    boolean transportedSomething = false;
                    for (i = 0; i < player.inventory.armorInventory.length; ++i) {
                        ItemStack item = player.inventory.armorInventory[i];
                        if (item == null || !ItemHandMirror.transport((ItemStack)amulet, (ItemStack)item, (EntityPlayer)player, (World)player.worldObj)) continue;
                        transportedSomething = true;
                        player.inventory.armorInventory[i] = null;
                    }
                    for (i = 0; i < player.inventory.mainInventory.length; ++i) {
                        ItemStack item = player.inventory.mainInventory[i];
                        if (item == null || !ItemHandMirror.transport((ItemStack)amulet, (ItemStack)item, (EntityPlayer)player, (World)player.worldObj)) continue;
                        transportedSomething = true;
                        player.inventory.mainInventory[i] = null;
                    }
                    InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
                    int amuletIndex = 0;
                    for (int i2 = 0; i2 < baubles.stackList.length; ++i2) {
                        ItemStack item = baubles.stackList[i2];
                        if (item == amulet) {
                            amuletIndex = i2;
                            continue;
                        }
                        if (item == null || !ItemHandMirror.transport((ItemStack)amulet, (ItemStack)item, (EntityPlayer)player, (World)player.worldObj)) continue;
                        transportedSomething = true;
                        baubles.stackList[i2] = null;
                    }
                    PlayerHandler.setPlayerBaubles((EntityPlayer)player, (InventoryBaubles)baubles);
                    if (transportedSomething) {
                        baubles.stackList[amuletIndex] = null;
                        PlayerHandler.setPlayerBaubles((EntityPlayer)player, (InventoryBaubles)baubles);
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXContainment(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ), new NetworkRegistry.TargetPoint(player.worldObj.provider.dimensionId, player.posX, player.posY, player.posZ, 32.0));
                        player.worldObj.playSoundEffect(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ, "thaumcraft:craftfail", 1.0f, 1.0f);
                        player.inventory.markDirty();
                        ItemStack droppedPearl = new ItemStack(ConfigItems.itemEldritchObject, 1, 3);
                        EntityPermanentItem drop = new EntityPermanentItem(player.worldObj, player.posX, player.posY, player.posZ, droppedPearl);
                        player.worldObj.spawnEntityInWorld((Entity)drop);
                    }
                }
                if (player.getEntityData().getBoolean("soulBeacon")) {
                    TileEntity tileEntity;
                    int z;
                    int y;
                    int dim = player.getEntityData().getInteger("soulBeaconDim");
                    WorldServer beaconWorld = MinecraftServer.getServer().worldServerForDimension(dim);
                    World playerWorld = player.worldObj;
                    int x = player.getEntityData().getIntArray("soulBeaconCoords")[0];
                    if (beaconWorld.getTileEntity(x, y = player.getEntityData().getIntArray("soulBeaconCoords")[1], z = player.getEntityData().getIntArray("soulBeaconCoords")[2]) instanceof TileSoulBeacon && (tileEntity = beaconWorld.getTileEntity(x, y - 1, z)) instanceof TileVat) {
                        TileVat vat = (TileVat)tileEntity;
                        if (vat.mode == 4) {
                            event.setCanceled(true);
                            event.ammount = 0.0f;
                            playerWorld.createExplosion(null, player.posX, player.posY + (double)player.getEyeHeight(), player.posZ, 0.0f, false);
                            for (int i = 0; i < 25; ++i) {
                                int zz;
                                int yy;
                                int xx = (int)player.posX + playerWorld.rand.nextInt(8) - playerWorld.rand.nextInt(8);
                                if (!playerWorld.isAirBlock(xx, yy = (int)player.posY + playerWorld.rand.nextInt(8) - playerWorld.rand.nextInt(8), zz = (int)player.posZ + playerWorld.rand.nextInt(8) - playerWorld.rand.nextInt(8))) continue;
                                if (yy <= (int)player.posY + 1) {
                                    playerWorld.setBlock(xx, yy, zz, ConfigBlocks.blockFluxGoo, 8, 3);
                                    continue;
                                }
                                playerWorld.setBlock(xx, yy, zz, ConfigBlocks.blockFluxGas, 8, 3);
                            }
                            player.inventory.dropAllItems();
                            for (ItemStack bauble : PlayerHandler.getPlayerBaubles((EntityPlayer)player).stackList) {
                                if (bauble == null) continue;
                                player.func_146097_a(bauble, true, false);
                            }
                            PlayerHandler.clearPlayerBaubles((EntityPlayer)player);
                            player.inventory.markDirty();
                            PacketHandler.INSTANCE.sendTo((IMessage)new PacketNoMoreItems(), (EntityPlayerMP)player);
                            player.curePotionEffects(new ItemStack(Items.milk_bucket));
                            player.heal(Float.MAX_VALUE);
                            if (dim != player.worldObj.provider.dimensionId) {
                                player.travelToDimension(dim);
                            }
                            player.setPositionAndUpdate((double)x + 0.5, (double)y - 2.5, (double)z + 0.5);
                            Thaumcraft.proxy.blockSparkle((World)beaconWorld, x, y - 2, z, 0xFFFFFF, 20);
                            Thaumcraft.proxy.blockSparkle((World)beaconWorld, x, y - 3, z, 0xFFFFFF, 20);
                            beaconWorld.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:whispers", 1.0f, beaconWorld.rand.nextFloat());
                            this.applyPlayerInfusions(player, vat);
                            vat.selfInfusions = new int[12];
                            vat.mode = 0;
                            vat.setEntityContained((EntityLivingBase)player);
                            beaconWorld.getTileEntity(x, y - 1, z).markDirty();
                            player.worldObj.markBlockForUpdate(x, y - 1, z);
                        }
                    }
                }
            }
        }
    }

    void applyPlayerInfusions(EntityPlayer player, TileVat tile) {
        EntityInfusionProperties prop = (EntityInfusionProperties)player.getExtendedProperties("CreatureInfusion");
        for (int i = 0; i < tile.selfInfusions.length; ++i) {
            if (tile.selfInfusions[i] == 0) continue;
            prop.addPlayerInfusion(tile.selfInfusions[i]);
        }
        this.applyInfusions((EntityLivingBase)player);
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        boolean poison;
        if (event.source.getEntity() != null && event.source.getEntity() instanceof EntityLivingBase && (poison = ((EntityInfusionProperties)event.entityLiving.getExtendedProperties("CreatureInfusion")).hasInfusion(9))) {
            event.entityLiving.addPotionEffect(new PotionEffect(Potion.poison.id, 40, 0, false));
        }
        if (!event.source.isProjectile()) {
            return;
        }
        boolean ender = ((EntityInfusionProperties)event.entityLiving.getExtendedProperties("CreatureInfusion")).hasInfusion(5);
        if (!ender) {
            return;
        }
        event.setCanceled(true);
        this.teleport(event.entityLiving);
    }

    public void teleport(EntityLivingBase entity) {
        int k;
        int j;
        EnderTeleportEvent event = new EnderTeleportEvent(entity, entity.posX + (entity.worldObj.rand.nextDouble() - 0.5) * 64.0, entity.posY + (double)(entity.worldObj.rand.nextInt(64) - 32), entity.posZ + (entity.worldObj.rand.nextDouble() - 0.5) * 64.0, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        double d3 = entity.posX;
        double d4 = entity.posY;
        double d5 = entity.posZ;
        entity.posX = event.targetX;
        entity.posY = event.targetY;
        entity.posZ = event.targetZ;
        boolean flag = false;
        int i = MathHelper.floor_double((double)entity.posX);
        if (entity.worldObj.blockExists(i, j = MathHelper.floor_double((double)entity.posY), k = MathHelper.floor_double((double)entity.posZ))) {
            boolean flag2 = false;
            while (!flag2 && j > 0) {
                Block block = entity.worldObj.getBlock(i, j - 1, k);
                if (block.getMaterial().blocksMovement()) {
                    flag2 = true;
                    continue;
                }
                entity.posY -= 1.0;
                --j;
            }
            if (flag2) {
                entity.setPosition(entity.posX, entity.posY, entity.posZ);
                if (entity.worldObj.getCollidingBoundingBoxes((Entity)entity, entity.boundingBox).isEmpty() && !entity.worldObj.isAnyLiquid(entity.boundingBox)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.setPosition(d3, d4, d5);
            return;
        }
        int short1 = 128;
        for (int l = 0; l < 128; ++l) {
            double d6 = (double)l / 127.0;
            float f = (entity.worldObj.rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (entity.worldObj.rand.nextFloat() - 0.5f) * 0.2f;
            float f3 = (entity.worldObj.rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (entity.posX - d3) * d6 + (entity.worldObj.rand.nextDouble() - 0.5) * (double)entity.width * 2.0;
            double d8 = d4 + (entity.posY - d4) * d6 + entity.worldObj.rand.nextDouble() * (double)entity.height;
            double d9 = d5 + (entity.posZ - d5) * d6 + (entity.worldObj.rand.nextDouble() - 0.5) * (double)entity.width * 2.0;
            entity.worldObj.spawnParticle("portal", d7, d8, d9, (double)f, (double)f2, (double)f3);
        }
        entity.worldObj.playSoundEffect(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        entity.playSound("mob.endermen.portal", 1.0f, 1.0f);
    }

    @SubscribeEvent
    public void entityHurt(LivingHurtEvent event) {
        boolean runic = ((EntityInfusionProperties)event.entityLiving.getExtendedProperties("CreatureInfusion")).hasInfusion(8);
        if (runic) {
            int charge = event.entityLiving.getEntityData().getInteger("runicCharge");
            if (charge <= 0 || event.source == DamageSource.drown || event.source == DamageSource.wither || event.source == DamageSource.outOfWorld || event.source == DamageSource.starve) {
                return;
            }
            int target = -1;
            if (event.source.getEntity() != null) {
                target = event.source.getEntity().getEntityId();
            }
            if (event.source == DamageSource.fall) {
                target = -2;
            }
            if (event.source == DamageSource.fallingBlock) {
                target = -3;
            }
            thaumcraft.common.lib.network.PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXShield(event.entity.getEntityId(), target), new NetworkRegistry.TargetPoint(event.entity.worldObj.provider.dimensionId, event.entity.posX, event.entity.posY, event.entity.posZ, 64.0));
            if ((float)charge > event.ammount) {
                charge -= (int)event.ammount;
                event.ammount = 0.0f;
            } else {
                event.ammount -= (float)charge;
                charge = 0;
            }
            event.entityLiving.getEntityData().setInteger("runicCharge", charge);
        }
    }

    @SubscribeEvent
    public void golemDies(LivingDeathEvent event) {
        if (event.entity instanceof EntityGolemTH) {
            ((EntityGolemTH)event.entity).die();
        }
    }

    @SubscribeEvent
    public void sitStay(EntityInteractEvent event) {
        if (event.target.getExtendedProperties("CreatureInfusion") != null) {
            EntityInfusionProperties prop = (EntityInfusionProperties)event.target.getExtendedProperties("CreatureInfusion");
            if (prop.hasInfusion(10) && event.entityPlayer.getHeldItem() != null && event.entityPlayer.getHeldItem().getItem() == ConfigItems.itemWandCasting) {
                ItemStack jar = new ItemStack(ThaumicHorizons.blockJar);
                NBTTagCompound entityData = new NBTTagCompound();
                entityData.setString("id", EntityList.getEntityString((Entity)event.target));
                event.target.writeToNBT(entityData);
                jar.setTagCompound(entityData);
                jar.getTagCompound().setString("jarredCritterName", event.target.getCommandSenderName());
                jar.getTagCompound().setBoolean("isSoul", false);
                event.target.entityDropItem(jar, 1.0f);
                if (!event.target.worldObj.isRemote) {
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXContainment(event.target.posX, event.target.posY + (double)(event.target.height / 2.0f), event.target.posZ), new NetworkRegistry.TargetPoint(event.target.worldObj.provider.dimensionId, event.target.posX, event.target.posY + (double)(event.target.height / 2.0f), event.target.posZ, 32.0));
                }
                event.target.worldObj.removeEntity(event.target);
            } else if (prop.hasInfusion(7) && event.entityPlayer.getCommandSenderName().equals(prop.getOwner())) {
                prop.setSitting(!prop.isSitting());
                if (event.target.worldObj.isRemote) {
                    if (prop.isSitting()) {
                        event.entityPlayer.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GRAY + event.target.getCommandSenderName() + " is waiting."));
                    } else {
                        event.entityPlayer.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GRAY + event.target.getCommandSenderName() + " will follow you."));
                    }
                }
            }
        }
    }
}

