/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.tiles;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.tiles.ISoulReceiver;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.utils.InventoryUtils;

public class TileSoulforge
extends TileThaumcraft
implements ISoulReceiver,
IEssentiaTransport,
IAspectContainer {
    int progress = 0;
    static final int PROGRESS_MAX = 9600;
    public int souls = 0;
    int essentia = 0;
    static final int ESSENTIA_MAX = 4000;
    public float rota;
    public int forging = 3;

    public boolean activate(World world, EntityPlayer player) {
        if (player.getHeldItem() == null || player.getHeldItem().getItemDamage() != 0 || player.getHeldItem().getItem() != Item.getItemFromBlock((Block)ConfigBlocks.blockJar)) {
            return false;
        }
        if (this.souls > 0) {
            ItemStack soul = new ItemStack(ThaumicHorizons.blockJar);
            soul.setTagCompound(new NBTTagCompound());
            soul.getTagCompound().setBoolean("isSoul", true);
            Integer[] newVillagerTypes = new Integer[VillagerRegistry.getRegisteredVillagers().size()];
            int pointer = 0;
            Iterator iterator = VillagerRegistry.getRegisteredVillagers().iterator();
            while (iterator.hasNext()) {
                int villagerType = (Integer)iterator.next();
                newVillagerTypes[pointer] = villagerType;
                ++pointer;
            }
            Integer[] villagerTypes = new Integer[newVillagerTypes.length + 5];
            for (int i = 0; i < 5; ++i) {
                villagerTypes[i] = i;
            }
            System.arraycopy(newVillagerTypes, 0, villagerTypes, 5, newVillagerTypes.length);
            int which = world.rand.nextInt(villagerTypes.length);
            soul.getTagCompound().setInteger("villagerType", villagerTypes[which].intValue());
            EntityVillager dummyVillager = new EntityVillager(this.worldObj);
            dummyVillager.setProfession(villagerTypes[which].intValue());
            soul.getTagCompound().setString("jarredCritterName", dummyVillager.getCommandSenderName());
            player.inventory.decrStackSize(InventoryUtils.isPlayerCarrying((EntityPlayer)player, (ItemStack)new ItemStack(ConfigBlocks.blockJar, 1, 0)), 1);
            if (!player.inventory.addItemStackToInventory(soul)) {
                player.entityDropItem(soul, 1.0f);
            }
            --this.souls;
            return true;
        }
        return false;
    }

    @Override
    public void addSoulBits(int bits) {
        this.progress += bits;
        this.essentia -= bits;
        if (this.progress >= 9600) {
            this.progress -= 9600;
            ++this.souls;
        }
        this.forging = 3;
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public boolean canAcceptSouls() {
        return this.essentia > 0 && this.souls < 16;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.essentia < 3000) {
            this.drawEssentia();
        }
        if (this.forging > 0) {
            this.rota += 1.0f;
            if (this.rota > 360.0f) {
                this.rota -= 360.0f;
            }
            --this.forging;
        }
    }

    public boolean isUseableByPlayer(EntityPlayer p_70300_1_) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this && p_70300_1_.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    void drawEssentia() {
        ForgeDirection dir = ForgeDirection.UP;
        TileEntity te = ThaumcraftApiHelper.getConnectableTile((World)this.worldObj, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord, (ForgeDirection)dir);
        if (te != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            ForgeDirection opposite = ForgeDirection.DOWN;
            if (!ic.canOutputTo(opposite)) {
                return;
            }
            Aspect ta = null;
            if (ic.getEssentiaAmount(opposite) > 0 && ic.getSuctionAmount(opposite) < this.getSuctionAmount(dir) && this.getSuctionAmount(dir) >= ic.getMinimumSuction()) {
                ta = ic.getEssentiaType(opposite);
            }
            if (ta != null && ta.getTag().equals(Aspect.MIND.getTag()) && ic.takeEssentia(ta, 1, opposite) == 1) {
                this.addEssentia(ta, 1, dir);
            }
        }
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setInteger("souls", this.souls);
        nbttagcompound.setInteger("progress", this.progress);
        nbttagcompound.setInteger("essentia", this.essentia);
        nbttagcompound.setInteger("forging", this.forging);
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.souls = nbttagcompound.getInteger("souls");
        this.progress = nbttagcompound.getInteger("progress");
        this.essentia = nbttagcompound.getInteger("essentia");
        this.forging = nbttagcompound.getInteger("forging");
    }

    public AspectList getAspects() {
        if (this.essentia <= 0) {
            return null;
        }
        return new AspectList().add(Aspect.MIND, (int)Math.ceil((float)this.essentia / 1000.0f));
    }

    public void setAspects(AspectList aspects) {
        this.essentia = aspects.getAmount(Aspect.MIND) * 1000;
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return tag.getTag().equals(Aspect.MIND.getTag()) && this.essentia / 1000 >= amount;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        if (tag.getTag().equals(Aspect.MIND.getTag())) {
            return this.essentia / 1000;
        }
        return 0;
    }

    public boolean isConnectable(ForgeDirection face) {
        return face == ForgeDirection.UP;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return face == ForgeDirection.UP;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return Aspect.MIND;
    }

    public int getSuctionAmount(ForgeDirection face) {
        return this.essentia < 3000 ? 128 : 0;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (this.essentia < 3000) {
            this.essentia += 1000;
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return 1;
        }
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return Aspect.MIND;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return this.essentia / 1000;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return false;
    }
}

