/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.tiles;

import com.kentington.thaumichorizons.client.fx.FXSonic;
import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.tiles.TileVortex;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.Thaumcraft;

public class TileVortexStabilizer
extends TileThaumcraft
implements IWandable {
    public boolean hasTarget;
    public int prevType;
    public int xTarget = Integer.MAX_VALUE;
    public int yTarget = Integer.MAX_VALUE;
    public int zTarget = Integer.MAX_VALUE;
    public TileEntity target = null;
    public int direction;
    boolean fireOnce = false;
    public boolean redstoned;
    public ForgeDirection dir;
    public Object theBeam = null;
    public Entity[] sonicFX = null;

    public void updateEntity() {
        super.updateEntity();
        if (!this.fireOnce) {
            ThaumicHorizons.blockVortexStabilizer.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord, this.zCoord, ThaumicHorizons.blockVortexStabilizer);
            this.direction = (byte)this.getBlockMetadata();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.dir = ForgeDirection.getOrientation((int)this.direction);
            if (this.target == null) {
                this.target = this.worldObj.getTileEntity(this.xTarget, this.yTarget, this.zTarget);
            }
            this.fireOnce = true;
        }
        if (this.worldObj.getWorldTime() % 5L == 0L) {
            MovingObjectPosition mop = null;
            if (this.redstoned) {
                mop = this.worldObj.rayTraceBlocks(Vec3.createVectorHelper((double)((double)(this.xCoord + this.dir.offsetX) + 0.75), (double)((double)(this.yCoord + this.dir.offsetY) + 0.75), (double)((double)(this.zCoord + this.dir.offsetZ) + 0.75)), Vec3.createVectorHelper((double)((double)(this.xCoord + this.dir.offsetX * 10) + 0.5), (double)((double)(this.yCoord + this.dir.offsetY * 10) + 0.5), (double)((double)(this.zCoord + this.dir.offsetZ * 10) + 0.5)));
            }
            if (mop != null) {
                if (mop.blockX != this.xTarget || mop.blockY != this.yTarget || mop.blockZ != this.zTarget) {
                    if (this.hasTarget) {
                        this.reHungrifyTarget();
                        this.hasTarget = false;
                    } else if (!this.hasTarget && this.worldObj.getTileEntity(mop.blockX, mop.blockY, mop.blockZ) instanceof INode) {
                        this.hasTarget = true;
                        this.target = this.worldObj.getTileEntity(mop.blockX, mop.blockY, mop.blockZ);
                        this.prevType = ((INode)this.worldObj.getTileEntity(mop.blockX, mop.blockY, mop.blockZ)).getNodeType().ordinal();
                        this.deHungrifyTarget();
                    } else if (!this.hasTarget && this.worldObj.getTileEntity(mop.blockX, mop.blockY, mop.blockZ) instanceof TileVortex) {
                        this.hasTarget = true;
                        this.target = this.worldObj.getTileEntity(mop.blockX, mop.blockY, mop.blockZ);
                        this.deHungrifyTarget();
                    }
                    this.xTarget = mop.blockX;
                    this.yTarget = mop.blockY;
                    this.zTarget = mop.blockZ;
                    this.markDirty();
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
            } else {
                if (this.hasTarget) {
                    this.reHungrifyTarget();
                    this.hasTarget = false;
                    this.markDirty();
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
                this.xTarget = this.xCoord + this.dir.offsetX * 10;
                this.yTarget = this.yCoord + this.dir.offsetY * 10;
                this.zTarget = this.zCoord + this.dir.offsetZ * 10;
                this.target = null;
            }
        }
        if (this.worldObj.isRemote && this.redstoned && ThaumicHorizons.proxy.readyToRender() && this.xTarget != Integer.MAX_VALUE && this.yTarget != Integer.MAX_VALUE && this.zTarget != Integer.MAX_VALUE) {
            if (this.sonicFX == null) {
                this.sonicFX = new Entity[3];
            }
            for (int i = 0; i < 3; ++i) {
                if (this.sonicFX[i] != null && !this.sonicFX[i].isDead) continue;
                this.sonicFX[i] = new FXSonic(Thaumcraft.proxy.getClientWorld(), (double)this.xTarget + 0.5, (double)this.yTarget + 0.5, (double)this.zTarget + 0.5, 10, this.direction);
                ThaumicHorizons.proxy.addEffect(this.sonicFX[i]);
                break;
            }
            this.theBeam = Thaumcraft.proxy.beamBore(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, (double)this.xTarget + 0.5 - (double)this.dir.offsetX, (double)this.yTarget + 0.5 - (double)this.dir.offsetY, (double)this.zTarget + 0.5 - (double)this.dir.offsetZ, 1, 33023, false, 2.0f, this.theBeam, 1);
        } else if (this.sonicFX != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.sonicFX[i] == null) continue;
                this.sonicFX[i].setDead();
                this.sonicFX[i] = null;
            }
        }
    }

    public void reHungrifyTarget() {
        if (this.target instanceof INode) {
            ((INode)this.target).setNodeType(NodeType.values()[this.prevType]);
        } else {
            TileEntity tileEntity = this.target;
            if (tileEntity instanceof TileVortex) {
                TileVortex tileVortex = (TileVortex)tileEntity;
                --tileVortex.beams;
            }
        }
        if (this.target != null) {
            this.target.markDirty();
            this.worldObj.markBlockForUpdate(this.target.xCoord, this.target.yCoord, this.target.zCoord);
        }
    }

    void deHungrifyTarget() {
        if (this.target instanceof INode) {
            ((INode)this.target).setNodeType(NodeType.NORMAL);
        } else {
            TileEntity tileEntity = this.target;
            if (tileEntity instanceof TileVortex) {
                TileVortex tileVortex = (TileVortex)tileEntity;
                ++tileVortex.beams;
            }
        }
        if (this.target != null) {
            this.target.markDirty();
            this.worldObj.markBlockForUpdate(this.target.xCoord, this.target.yCoord, this.target.zCoord);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.setInteger("xT", this.xTarget);
        nbttagcompound.setInteger("yT", this.yTarget);
        nbttagcompound.setInteger("zT", this.zTarget);
        nbttagcompound.setInteger("direction", this.direction);
        nbttagcompound.setBoolean("hasTarget", this.hasTarget);
        nbttagcompound.setBoolean("active", this.redstoned);
        nbttagcompound.setInteger("prevType", this.prevType);
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.xTarget = nbttagcompound.getInteger("xT");
        this.yTarget = nbttagcompound.getInteger("yT");
        this.zTarget = nbttagcompound.getInteger("zT");
        this.direction = nbttagcompound.getInteger("direction");
        this.hasTarget = nbttagcompound.getBoolean("hasTarget");
        this.redstoned = nbttagcompound.getBoolean("active");
        this.prevType = nbttagcompound.getInteger("prevType");
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        this.dir = ForgeDirection.getOrientation((int)side);
        this.direction = side;
        world.setBlockMetadataWithNotify(x, y, z, this.direction, 3);
        player.worldObj.playSound((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:tool", 0.5f, 0.9f + player.worldObj.rand.nextFloat() * 0.2f, false);
        player.swingItem();
        this.markDirty();
        return 0;
    }

    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        return null;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }
}

