/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica;

import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1142;
import net.minecraft.class_5455;
import work.lclpnet.kibu.config.ConfigManager;
import work.lclpnet.notica.NoticaInit;
import work.lclpnet.notica.config.NoticaClientConfig;
import work.lclpnet.notica.event.ClientDisconnectCallback;
import work.lclpnet.notica.event.ClientJoinGameCallback;
import work.lclpnet.notica.event.SongVolumeChangedCallback;
import work.lclpnet.notica.impl.ClientInstrumentSoundProvider;
import work.lclpnet.notica.impl.ClientMusicBackend;
import work.lclpnet.notica.impl.ClientSongRepository;
import work.lclpnet.notica.mixin.client.MinecraftClientAccessor;
import work.lclpnet.notica.networking.NoticaClientNetworking;
import work.lclpnet.notica.type.NoticaMusicTracker;
import work.lclpnet.notica.util.PlayerConfigEntry;

@Environment(value=EnvType.CLIENT)
public class NoticaClientInit
implements ClientModInitializer {
    private static volatile ConfigManager<NoticaClientConfig> _configManager = null;

    public void onInitializeClient() {
        ConfigManager<NoticaClientConfig> configManager = this.loadConfig();
        _configManager = configManager;
        ClientSongRepository songRepo = new ClientSongRepository();
        ClientInstrumentSoundProvider soundProvider = new ClientInstrumentSoundProvider();
        PlayerConfigEntry playerConfig = new PlayerConfigEntry();
        playerConfig.setExtendedRangeSupported(true);
        ClientMusicBackend musicBackend = new ClientMusicBackend(songRepo, soundProvider, playerConfig, configManager, NoticaInit.LOGGER);
        new NoticaClientNetworking(songRepo, musicBackend, playerConfig, NoticaInit.LOGGER).register();
        ClientJoinGameCallback.EVENT.register(networkHandler -> soundProvider.setRegistryManager((class_5455)networkHandler.method_29091()));
        ClientDisconnectCallback.EVENT.register(() -> {
            musicBackend.stopAll();
            soundProvider.setRegistryManager(null);
        });
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            class_1142 musicTracker = ((MinecraftClientAccessor)client).getMusicTracker();
            ((NoticaMusicTracker)musicTracker).notica$setMusicInhibitor(musicBackend::isSongPlaying);
        });
        SongVolumeChangedCallback.EVENT.register(musicBackend::reload);
    }

    private ConfigManager<NoticaClientConfig> loadConfig() {
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("notica").resolve("client.toml");
        ConfigManager configManager = new ConfigManager(configPath, (Object)new NoticaClientConfig());
        configManager.load();
        return configManager;
    }

    public static Optional<ConfigManager<NoticaClientConfig>> configManager() {
        return Optional.ofNullable(_configManager);
    }
}

