/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.api;

import java.util.Objects;
import work.lclpnet.kibu.hook.Hook;
import work.lclpnet.kibu.hook.HookFactory;
import work.lclpnet.notica.api.AggregatingPlayer;
import work.lclpnet.notica.api.NotePlayer;
import work.lclpnet.notica.api.SongPlayback;
import work.lclpnet.notica.api.data.Layer;
import work.lclpnet.notica.api.data.LoopConfig;
import work.lclpnet.notica.api.data.LoopOverride;
import work.lclpnet.notica.api.data.Note;
import work.lclpnet.notica.api.data.Song;

public class IndividualSongPlayback
implements Runnable,
SongPlayback {
    private final Song song;
    private final NotePlayer notePlayer;
    private final int durationTicks;
    private final LoopConfig loopConfig;
    private boolean started = false;
    private int tick = 0;
    private double tempoNs;
    private double expectedNextNs = 0.0;
    private volatile Hook<Runnable> onComplete = null;
    private volatile Thread thread = null;
    private volatile boolean stopped = false;

    public IndividualSongPlayback(Song song, NotePlayer notePlayer) {
        this(song, notePlayer, LoopOverride.DEFAULT);
    }

    public IndividualSongPlayback(Song song, NotePlayer notePlayer, LoopOverride loopOverride) {
        this.song = Objects.requireNonNull(song, "Song must not be null");
        this.notePlayer = Objects.requireNonNull(notePlayer, "NotePlayer must not be null");
        this.durationTicks = song.durationTicks();
        this.loopConfig = loopOverride.override(song.loopConfig());
        this.updateTempo(song.tempo().tempoAt(0));
    }

    private void updateTempo(float ticksPerSecond) {
        this.tempoNs = 1.0E9 / (double)ticksPerSecond;
    }

    @Override
    public synchronized void start(int startTick) {
        if (this.started) {
            return;
        }
        this.started = true;
        this.tick = startTick;
        this.thread = new Thread((Runnable)this, "Song Player");
        this.thread.start();
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.stopped = true;
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    @Override
    public void run() {
        int endTick;
        int loopAmount = this.loopConfig.loopCount();
        boolean shouldLoop = this.loopConfig.enabled();
        if (shouldLoop) {
            int interval = Math.max(2, Math.min(8, this.song.signature())) * 4;
            endTick = this.durationTicks + interval - this.durationTicks % interval;
        } else {
            endTick = this.durationTicks + 1;
        }
        while (this.started && this.tick < endTick) {
            long delayNs;
            boolean infinite;
            int t;
            ++this.tick;
            for (Layer layer : this.song.layers()) {
                Note note = layer.notes().get(t);
                if (note == null) continue;
                this.notePlayer.playNote(this.song, layer, note);
            }
            NotePlayer notePlayer = this.notePlayer;
            if (notePlayer instanceof AggregatingPlayer) {
                AggregatingPlayer aggregatingPlayer = (AggregatingPlayer)((Object)notePlayer);
                aggregatingPlayer.finishAggregation();
            }
            if (shouldLoop && this.tick == endTick && ((infinite = this.loopConfig.infinite()) || loopAmount > 0)) {
                if (!infinite) {
                    --loopAmount;
                }
                this.tick = this.loopConfig.loopStartTick();
            }
            if (this.song.tempo().changeAt(t)) {
                this.updateTempo(this.song.tempo().tempoAt(t));
            }
            long after = System.nanoTime();
            if (this.expectedNextNs > 0.0) {
                delayNs = (long)((double)after - this.expectedNextNs);
            } else {
                delayNs = 0L;
                this.expectedNextNs = after;
            }
            this.expectedNextNs += this.tempoNs;
            double waitExact = this.tempoNs - (double)delayNs;
            long waitMs = Math.round(waitExact * 1.0E-6);
            int waitNs = (int)Math.round(waitExact - (double)waitMs * 1000000.0);
            waitNs = Math.max(0, Math.min(999999, waitNs));
            if (waitMs <= 0L) continue;
            try {
                Thread.sleep(waitMs, waitNs);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.onComplete != null) {
            ((Runnable)this.onComplete.invoker()).run();
        }
    }

    @Override
    public void whenDone(Runnable action) {
        this.getOrCreateHook().register((Object)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hook<Runnable> getOrCreateHook() {
        if (this.onComplete != null) {
            return this.onComplete;
        }
        IndividualSongPlayback individualSongPlayback = this;
        synchronized (individualSongPlayback) {
            if (this.onComplete != null) {
                return this.onComplete;
            }
            this.onComplete = IndividualSongPlayback.runnableHook();
        }
        return this.onComplete;
    }

    public static Hook<Runnable> runnableHook() {
        return HookFactory.createArrayBacked(Runnable.class, hooks -> () -> {
            for (Runnable hook : hooks) {
                hook.run();
            }
        });
    }

    @Override
    public synchronized boolean wasStoppedManually() {
        return this.stopped;
    }

    @Override
    public synchronized void seekTo(int ticks, boolean absolute) {
        this.tick = ticks = Math.max(0, absolute ? ticks : this.tick + ticks);
        this.expectedNextNs = 0.0;
        this.updateTempo(this.song.tempo().tempoAt(ticks));
    }
}

