/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.api.data;

import java.util.Optional;
import work.lclpnet.notica.api.data.LoopConfig;
import work.lclpnet.notica.impl.data.ImmutableLoopConfig;

public record LoopOverride(Optional<Boolean> enabled, Optional<Integer> loopCount, Optional<Integer> loopStartTick) {
    public static LoopOverride DEFAULT = new LoopOverride(Optional.empty(), Optional.empty(), Optional.empty());

    public LoopOverride withEnabled(boolean enabled) {
        return new LoopOverride(Optional.of(enabled), this.loopCount, this.loopStartTick);
    }

    public LoopOverride withStartTick(int startTick) {
        return new LoopOverride(this.enabled, this.loopCount, Optional.of(startTick));
    }

    public LoopOverride withLoopCount(int loopCount) {
        return new LoopOverride(this.enabled, Optional.of(loopCount), this.loopStartTick);
    }

    public ImmutableLoopConfig override(LoopConfig base) {
        return new ImmutableLoopConfig(this.enabled.orElseGet(base::enabled), this.loopCount.orElseGet(base::loopCount), this.loopStartTick.orElseGet(base::loopStartTick));
    }
}

