/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.api.data;

import java.util.OptionalInt;
import work.lclpnet.notica.api.Index;
import work.lclpnet.notica.api.data.Instruments;
import work.lclpnet.notica.api.data.Layer;
import work.lclpnet.notica.api.data.LoopConfig;
import work.lclpnet.notica.api.data.SongMeta;
import work.lclpnet.notica.api.data.SongTempo;

public interface Song {
    public int durationTicks();

    public SongTempo tempo();

    public SongMeta metaData();

    public LoopConfig loopConfig();

    public Index<? extends Layer> layers();

    public Instruments instruments();

    public boolean stereo();

    public byte signature();

    default public float durationSeconds() {
        return this.tempo().durationSeconds(0, this.durationTicks());
    }

    default public int paddedDurationTicks() {
        int ticks = this.durationTicks();
        int interval = Math.max(2, Math.min(this.signature(), 8)) * 4;
        return ticks + interval - ticks % interval;
    }

    default public float paddedDurationSeconds() {
        return this.tempo().durationSeconds(0, this.paddedDurationTicks());
    }

    default public OptionalInt lastNoteTick() {
        return this.layers().stream().flatMapToInt(l -> l.notes().maxIndex().stream()).max();
    }
}

