/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import work.lclpnet.kibu.translate.Translations;
import work.lclpnet.kibu.translate.text.FormatWrapper;
import work.lclpnet.kibu.translate.text.RootText;
import work.lclpnet.kibu.translate.text.TextTranslatable;
import work.lclpnet.notica.Notica;
import work.lclpnet.notica.NoticaInit;
import work.lclpnet.notica.api.CheckedSong;
import work.lclpnet.notica.api.PlaybackOptions;
import work.lclpnet.notica.api.PlaybackVariant;
import work.lclpnet.notica.api.SongHandle;
import work.lclpnet.notica.api.StereoMode;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.api.data.SongMeta;
import work.lclpnet.notica.impl.NoticaImpl;
import work.lclpnet.notica.util.NoticaServerPackManager;
import work.lclpnet.notica.util.PlayerConfigContainer;
import work.lclpnet.notica.util.ServerSongLoader;
import work.lclpnet.notica.util.SongUtils;

public class MusicCommand {
    public static final Pattern TIME_SEGMENT = Pattern.compile("((?:[+-]\\s*)?\\d+)\\s*(sec|min|ticks|[smt])");
    public static final Pattern TIME_PATTERN = Pattern.compile("^(?:%s)+$".formatted(TIME_SEGMENT.pattern()));
    public static final float DEFAULT_VOLUME = 0.5f;
    private final Path songDirectory;
    private final Translations translations;
    private final NoticaServerPackManager serverPackManager;
    private final Logger logger;
    private final SimpleCommandExceptionType errorNoPermissionPlayOther;
    private final SimpleCommandExceptionType errorNoPermissionStopOther;

    public MusicCommand(Path songDirectory, Translations translations, NoticaServerPackManager serverPackManager, Logger logger) {
        this.songDirectory = songDirectory;
        this.translations = translations;
        this.serverPackManager = serverPackManager;
        this.logger = logger;
        this.errorNoPermissionPlayOther = new SimpleCommandExceptionType((Message)class_2561.method_48321((String)"notica.music.play.no_permission_other", (String)"You don't have permission to play music to other players"));
        this.errorNoPermissionStopOther = new SimpleCommandExceptionType((Message)class_2561.method_48321((String)"notica.music.stop.no_permission_other", (String)"You don't have permission to stop music for other players"));
    }

    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(this.command());
    }

    private LiteralArgumentBuilder<class_2168> command() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"music").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"play").requires(Permissions.require((String)NoticaInit.permission("command.music.play"), (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"song", (ArgumentType)StringArgumentType.string()).suggests(this::availableSongFiles).executes(this::playSongAutoSelf)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"listeners", (ArgumentType)class_2186.method_9308()).executes(this::playSongAuto)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"volume", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(this::playSongVolume)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"individual").executes(ctx -> this.playSongVariant((CommandContext<class_2168>)ctx, PlaybackVariant.INDIVIDUAL))).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(ctx -> this.playSongId((CommandContext<class_2168>)ctx, PlaybackVariant.INDIVIDUAL, StereoMode.SPATIAL))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"streamed").executes(ctx -> this.playSongVariant((CommandContext<class_2168>)ctx, PlaybackVariant.STREAMED))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"spatial").executes(ctx -> this.playSongStereo((CommandContext<class_2168>)ctx, StereoMode.SPATIAL))).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(ctx -> this.playSongId((CommandContext<class_2168>)ctx, PlaybackVariant.STREAMED, StereoMode.SPATIAL))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"equal_power").executes(ctx -> this.playSongStereo((CommandContext<class_2168>)ctx, StereoMode.EQUAL_POWER))).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(ctx -> this.playSongId((CommandContext<class_2168>)ctx, PlaybackVariant.STREAMED, StereoMode.EQUAL_POWER)))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stop").requires(Permissions.require((String)NoticaInit.permission("command.music.stop"), (int)2))).executes(this::stopAllSelf)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"listeners", (ArgumentType)class_2186.method_9308()).executes(this::stopAll)).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(this::commonPlayingSongIds).executes(this::stopSong))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"extended_range").requires(this::extendedRangePredicate)).then(class_2170.method_9244((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(this::changeExtendedRange)))).then(class_2170.method_9247((String)"volume").then(class_2170.method_9244((String)"percent", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)100.0f)).executes(this::changeVolume))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"seek").requires(Permissions.require((String)NoticaInit.permission("command.music.seek"), (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"time", (ArgumentType)StringArgumentType.string()).suggests(this::suggestTimes).executes(this::seekAutoSelf)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"listeners", (ArgumentType)class_2186.method_9308()).executes(this::seekAuto)).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).suggests(this::commonPlayingSongIds).executes(this::seekId)))));
    }

    private int playSongAutoSelf(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_9207();
        String songFile = StringArgumentType.getString(ctx, (String)"song");
        Path path = this.songDirectory.resolve(songFile);
        class_2960 id = SongUtils.createSongId(path);
        this.stopAllSongs((class_2168)ctx.getSource(), List.of(player));
        return this.playSong(source, List.of(player), path, id, new PlaybackOptions(0.5f));
    }

    private int playSongAuto(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Collection listeners = class_2186.method_9312(ctx, (String)"listeners");
        String songFile = StringArgumentType.getString(ctx, (String)"song");
        Path path = this.songDirectory.resolve(songFile);
        class_2960 id = SongUtils.createSongId(path);
        this.stopAllSongs((class_2168)ctx.getSource(), listeners);
        return this.playSong((class_2168)ctx.getSource(), listeners, path, id, new PlaybackOptions(0.5f));
    }

    private int playSongVolume(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Collection listeners = class_2186.method_9312(ctx, (String)"listeners");
        String songFile = StringArgumentType.getString(ctx, (String)"song");
        float volume = FloatArgumentType.getFloat(ctx, (String)"volume");
        Path path = this.songDirectory.resolve(songFile);
        class_2960 id = SongUtils.createSongId(path);
        this.stopAllSongs((class_2168)ctx.getSource(), listeners);
        return this.playSong((class_2168)ctx.getSource(), listeners, path, id, new PlaybackOptions(volume));
    }

    private int playSongVariant(CommandContext<class_2168> ctx, PlaybackVariant variant) throws CommandSyntaxException {
        Collection listeners = class_2186.method_9312(ctx, (String)"listeners");
        String songFile = StringArgumentType.getString(ctx, (String)"song");
        float volume = FloatArgumentType.getFloat(ctx, (String)"volume");
        Path path = this.songDirectory.resolve(songFile);
        class_2960 id = SongUtils.createSongId(path);
        this.stopAllSongs((class_2168)ctx.getSource(), listeners);
        return this.playSong((class_2168)ctx.getSource(), listeners, path, id, new PlaybackOptions(volume, variant, StereoMode.SPATIAL));
    }

    private int playSongStereo(CommandContext<class_2168> ctx, StereoMode stereoMode) throws CommandSyntaxException {
        Collection listeners = class_2186.method_9312(ctx, (String)"listeners");
        String songFile = StringArgumentType.getString(ctx, (String)"song");
        float volume = FloatArgumentType.getFloat(ctx, (String)"volume");
        Path path = this.songDirectory.resolve(songFile);
        class_2960 id = SongUtils.createSongId(path);
        this.stopAllSongs((class_2168)ctx.getSource(), listeners);
        return this.playSong((class_2168)ctx.getSource(), listeners, path, id, new PlaybackOptions(volume, PlaybackVariant.STREAMED, stereoMode));
    }

    private int playSongId(CommandContext<class_2168> ctx, PlaybackVariant variant, StereoMode stereoMode) throws CommandSyntaxException {
        Collection listeners = class_2186.method_9312(ctx, (String)"listeners");
        String songFile = StringArgumentType.getString(ctx, (String)"song");
        float volume = FloatArgumentType.getFloat(ctx, (String)"volume");
        class_2960 id = class_2232.method_9443(ctx, (String)"id");
        Path path = this.songDirectory.resolve(songFile);
        return this.playSong((class_2168)ctx.getSource(), listeners, path, id, new PlaybackOptions(volume, variant, stereoMode));
    }

    private int changeExtendedRange(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        boolean enabled = BoolArgumentType.getBool(ctx, (String)"enabled");
        if (enabled && !this.serverPackManager.hasServerPackInstalled(player)) {
            RootText msg = this.translations.translateText(player, "notica.music.server_pack_requesting", new Object[0]).formatted(class_124.field_1080);
            player.method_64398((class_2561)msg);
            this.serverPackManager.sendServerPack(player);
            return 1;
        }
        NoticaImpl instance = NoticaImpl.getInstance(player.method_51469().method_8503());
        PlayerConfigContainer configs = instance.getPlayerConfigs();
        configs.get(player).setExtendedRangeSupported(enabled);
        String key = enabled ? "notica.music.extended_octaves.enabled" : "notica.music.extended_octaves.disabled";
        class_124 color = enabled ? class_124.field_1060 : class_124.field_1061;
        RootText msg = this.translations.translateText(player, key, new Object[0]).formatted(color);
        player.method_64398((class_2561)msg);
        return 2;
    }

    private int changeVolume(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        float percent = FloatArgumentType.getFloat(ctx, (String)"percent");
        NoticaImpl instance = NoticaImpl.getInstance(player.method_51469().method_8503());
        PlayerConfigContainer configs = instance.getPlayerConfigs();
        configs.get(player).setVolume(percent / 100.0f);
        configs.saveConfig(player);
        instance.syncPlayerConfig(player);
        RootText msg = this.translations.translateText(player, "notica.music.volume.changed", new Object[]{FormatWrapper.styled((Object)"%.0f%%".formatted(Float.valueOf(percent)), (class_124[])new class_124[]{class_124.field_1054})}).formatted(class_124.field_1060);
        player.method_64398((class_2561)msg);
        return 1;
    }

    private boolean involvesOther(class_2168 source, Collection<? extends class_3222> players) {
        class_3222 executor = source.method_44023();
        if (executor == null) {
            return !players.isEmpty();
        }
        return players.stream().anyMatch(player -> !executor.equals(player));
    }

    private int playSong(class_2168 source, Collection<? extends class_3222> listeners, Path path, class_2960 id, PlaybackOptions options) throws CommandSyntaxException {
        if (this.involvesOther(source, listeners) && !Permissions.check((class_2172)source, (String)NoticaInit.permission("command.music.play.other"), (int)2)) {
            throw this.errorNoPermissionPlayOther.create();
        }
        Path relativePath = this.songDirectory.relativize(path);
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            CheckedSong checkedSong;
            block8: {
                InputStream in = Files.newInputStream(path, new OpenOption[0]);
                try {
                    checkedSong = ServerSongLoader.load(in, id);
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                }
                in.close();
            }
            return checkedSong;
        }).exceptionally(error -> {
            CompletionException c;
            RootText msg = error instanceof CompletionException && (c = (CompletionException)error).getCause() instanceof NoSuchFileException ? this.translations.translateText(source, "notica.music.play.not_found", new Object[]{FormatWrapper.styled((Object)relativePath, (class_124[])new class_124[]{class_124.field_1054})}) : this.translations.translateText(source, "notica.music.play.error", new Object[0]);
            msg.formatted(class_124.field_1061);
            source.method_45068((class_2561)msg);
            this.logger.error("Failed to load song file", error);
            return null;
        })).thenAccept(song -> {
            if (song == null) {
                return;
            }
            class_2561 msg = this.getPlayingMessage(source, relativePath, (CheckedSong)song);
            source.method_45068(msg);
            Notica api = Notica.getInstance(source.method_9211());
            api.playSong((CheckedSong)song, options, 0, listeners);
        });
        return 1;
    }

    private class_2561 getPlayingMessage(class_2168 source, Path relativePath, CheckedSong checkedSong) {
        SongMeta meta = checkedSong.song().metaData();
        String name = meta.name().isBlank() ? relativePath.toString() : meta.name();
        class_5250 nameText = class_2561.method_43470((String)name).method_27692(class_124.field_1054);
        if (!meta.description().isBlank()) {
            class_5250 hoverText = class_2561.method_43470((String)meta.description()).method_27692(class_124.field_1060);
            nameText.method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)hoverText)));
        }
        if (meta.author().isBlank() && meta.originalAuthor().isBlank()) {
            return this.translations.translateText(source, "notica.music.play", new Object[]{nameText}).formatted(class_124.field_1060);
        }
        if (!meta.author().isBlank() && !meta.originalAuthor().isBlank()) {
            return this.translations.translateText(source, "notica.music.play_author_original", new Object[]{nameText, FormatWrapper.styled((Object)meta.author(), (class_124[])new class_124[]{class_124.field_1075}), this.translations.translateText(source, "notica.music.original_author", new Object[]{meta.originalAuthor()}).formatted(class_124.field_1080)}).formatted(class_124.field_1060);
        }
        String author = meta.author().isBlank() ? meta.originalAuthor() : meta.author();
        return this.translations.translateText(source, "notica.music.play_author", new Object[]{nameText, FormatWrapper.styled((Object)author, (class_124[])new class_124[]{class_124.field_1075})}).formatted(class_124.field_1060);
    }

    private int stopAllSelf(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        int stopped = this.stopAllSongs((class_2168)ctx.getSource(), List.of(player));
        RootText msg = stopped == 0 ? this.translations.translateText(player, "notica.music.none_playing", new Object[0]).formatted(class_124.field_1061) : this.translations.translateText(player, "notica.music.stopped.all", new Object[0]).formatted(class_124.field_1060);
        player.method_64398((class_2561)msg);
        return stopped;
    }

    private int stopAll(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Collection listeners = class_2186.method_9312(ctx, (String)"listeners");
        class_2168 source = (class_2168)ctx.getSource();
        if (this.involvesOther(source, listeners) && !Permissions.check((class_2172)source, (String)NoticaInit.permission("command.music.stop.other"), (int)2)) {
            throw this.errorNoPermissionStopOther.create();
        }
        int stopped = this.stopAllSongs(source, listeners);
        boolean empty = stopped == 0;
        RootText msg = empty ? this.translations.translateText(source, "notica.music.none_playing", new Object[0]).formatted(class_124.field_1061) : this.translations.translateText(source, "notica.music.stopped.all", new Object[0]).formatted(class_124.field_1060);
        source.method_45068((class_2561)msg);
        return empty ? 0 : 1;
    }

    private int stopAllSongs(class_2168 source, Collection<class_3222> listeners) {
        Notica api = Notica.getInstance(source.method_9211());
        int stopped = 0;
        for (class_3222 listener : listeners) {
            for (SongHandle handle : api.getPlayingSongs(listener)) {
                ++stopped;
                handle.remove(listener);
            }
        }
        return stopped;
    }

    private int stopSong(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        RootText msg;
        Collection listeners = class_2186.method_9312(ctx, (String)"listeners");
        class_2960 id = class_2232.method_9443(ctx, (String)"id");
        class_2168 source = (class_2168)ctx.getSource();
        if (this.involvesOther(source, listeners) && !Permissions.check((class_2172)source, (String)NoticaInit.permission("command.music.stop.other"), (int)2)) {
            throw this.errorNoPermissionStopOther.create();
        }
        Notica api = Notica.getInstance(source.method_9211());
        int stopped = 0;
        for (class_3222 listener : listeners) {
            Optional<SongHandle> optHandle = api.getPlayingSong(listener, id);
            if (optHandle.isEmpty()) continue;
            ++stopped;
            optHandle.get().remove(listener);
        }
        if (stopped == 0) {
            msg = this.translations.translateText(source, "notica.music.not_playing", new Object[]{FormatWrapper.styled((Object)id, (class_124[])new class_124[]{class_124.field_1054})}).formatted(class_124.field_1061);
            source.method_45068((class_2561)msg);
            return 0;
        }
        msg = this.translations.translateText(source, "notica.music.stopped", new Object[]{FormatWrapper.styled((Object)id, (class_124[])new class_124[]{class_124.field_1054})}).formatted(class_124.field_1060);
        source.method_45068((class_2561)msg);
        return 1;
    }

    private int seekAutoSelf(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2168 source;
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        String time = StringArgumentType.getString(ctx, (String)"time");
        TimeOffsets timeOffsets = this.parseOffsets(time, source = (class_2168)ctx.getSource());
        if (timeOffsets == null) {
            return 0;
        }
        Set<SongHandle> songHandles = Notica.getInstance(player.method_51469().method_8503()).getPlayingSongs(player);
        return this.seekAllWithOffsets(source, songHandles, timeOffsets);
    }

    private int seekAuto(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String time = StringArgumentType.getString(ctx, (String)"time");
        Collection players = class_2186.method_9312(ctx, (String)"listeners");
        class_2168 source = (class_2168)ctx.getSource();
        TimeOffsets timeOffsets = this.parseOffsets(time, source);
        if (timeOffsets == null) {
            return 0;
        }
        Notica api = Notica.getInstance(source.method_9211());
        Set<SongHandle> songHandles = players.stream().flatMap(player -> api.getPlayingSongs((class_3222)player).stream()).collect(Collectors.toSet());
        return this.seekAllWithOffsets(source, songHandles, timeOffsets);
    }

    private int seekId(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String time = StringArgumentType.getString(ctx, (String)"time");
        Collection players = class_2186.method_9312(ctx, (String)"listeners");
        class_2960 songId = class_2232.method_9443(ctx, (String)"id");
        class_2168 source = (class_2168)ctx.getSource();
        TimeOffsets timeOffsets = this.parseOffsets(time, source);
        if (timeOffsets == null) {
            return 0;
        }
        Notica api = Notica.getInstance(source.method_9211());
        Set<SongHandle> songHandles = players.stream().flatMap(player -> api.getPlayingSong((class_3222)player, songId).stream()).collect(Collectors.toSet());
        return this.seekAllWithOffsets(source, songHandles, timeOffsets);
    }

    private int seekAllWithOffsets(class_2168 source, Set<SongHandle> songHandles, TimeOffsets timeOffsets) {
        if (songHandles.isEmpty()) {
            source.method_45068((class_2561)this.translations.translateText(source, "notica.music.none_playing", new Object[0]).formatted(class_124.field_1061));
            return 0;
        }
        for (SongHandle handle : songHandles) {
            this.seekWithOffsets(handle, timeOffsets);
        }
        class_3222 player = source.method_44023();
        String language = player != null ? this.translations.getLanguage(player) : "en_us";
        FormatWrapper offsetsWrapped = FormatWrapper.styled((Object)timeOffsets.translatedText(this.translations).translateTo(language), (class_124[])new class_124[]{class_124.field_1054});
        String translationKey = timeOffsets.absolute ? "notica.music.seek.absolute" : "notica.music.seek.relative";
        source.method_45068((class_2561)this.translations.translateText(source, translationKey, new Object[]{offsetsWrapped}).formatted(class_124.field_1060));
        return 1;
    }

    @Nullable
    private TimeOffsets parseOffsets(String time, class_2168 source) {
        if (!TIME_PATTERN.matcher(time).matches()) {
            source.method_45068((class_2561)this.translations.translateText(source, "notica.music.seek.error_time", new Object[]{FormatWrapper.styled((Object)time, (class_124[])new class_124[]{class_124.field_1054})}).formatted(class_124.field_1061));
            return null;
        }
        Matcher matcher = TIME_SEGMENT.matcher(time);
        ArrayList<IntObjectPair<TimeUnit>> offsets = new ArrayList<IntObjectPair<TimeUnit>>();
        boolean firstMatch = true;
        boolean absolute = true;
        boolean zero = false;
        while (matcher.find()) {
            TimeUnit unit;
            int amount;
            String amountStr = matcher.group(1);
            String unitStr = matcher.group(2);
            if (firstMatch) {
                firstMatch = false;
                if (!(amountStr.isEmpty() || amountStr.charAt(0) != '+' && amountStr.charAt(0) != '-')) {
                    absolute = false;
                }
            }
            try {
                amount = Integer.parseInt(amountStr);
            }
            catch (NumberFormatException e) {
                source.method_45068((class_2561)this.translations.translateText(source, "notica.music.seek.error_time", new Object[]{FormatWrapper.styled((Object)amountStr, (class_124[])new class_124[]{class_124.field_1054})}).formatted(class_124.field_1061));
                this.logger.error("Failed to parse as integer: {}", (Object)amountStr, (Object)e);
                continue;
            }
            switch (unitStr) {
                case "sec": 
                case "s": {
                    TimeUnit timeUnit = TimeUnit.SECONDS;
                    break;
                }
                case "min": 
                case "m": {
                    TimeUnit timeUnit = TimeUnit.MINUTES;
                    break;
                }
                case "ticks": 
                case "t": {
                    TimeUnit timeUnit = TimeUnit.TICKS;
                    break;
                }
                default: {
                    TimeUnit timeUnit = unit = null;
                }
            }
            if (unit == null) {
                this.logger.error("Unknown time unit: {}", (Object)unitStr);
                continue;
            }
            if (amount == 0) {
                zero = true;
                continue;
            }
            offsets.add((IntObjectPair<TimeUnit>)IntObjectPair.of((int)amount, (Object)((Object)unit)));
        }
        if (!(!offsets.isEmpty() || absolute && zero)) {
            return null;
        }
        return new TimeOffsets(offsets, absolute);
    }

    private void seekWithOffsets(SongHandle handle, TimeOffsets timeOffsets) {
        Song song = handle.getSong();
        int ticks = 0;
        for (IntObjectPair<TimeUnit> offset : timeOffsets.offsets()) {
            int amount = offset.keyInt();
            int offsetTicks = switch (((TimeUnit)((Object)offset.value())).ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Math.abs(amount);
                case 1 -> song.tempo().durationTicks(ticks, amount);
                case 2 -> song.tempo().durationTicks(ticks, amount * 60);
            };
            ticks += Integer.signum(amount) * offsetTicks;
        }
        handle.seekTo(ticks, timeOffsets.absolute());
    }

    private CompletableFuture<Suggestions> availableSongFiles(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        return CompletableFuture.supplyAsync(() -> {
            try (Stream<Path> files = Files.walk(this.songDirectory, 8, new FileVisitOption[0]);){
                files.filter(path -> path.getFileName().toString().endsWith(".nbs") && Files.isRegularFile(path, new LinkOption[0])).map(this.songDirectory::relativize).map(Path::toString).map(MusicCommand::transformString).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            catch (IOException e) {
                this.logger.error("Failed to walk files in songs directory", (Throwable)e);
            }
            return builder.build();
        });
    }

    private CompletableFuture<Suggestions> commonPlayingSongIds(CommandContext<class_2168> ctx, SuggestionsBuilder builder) throws CommandSyntaxException {
        Collection listeners = class_2186.method_9312(ctx, (String)"listeners");
        Notica api = Notica.getInstance(((class_2168)ctx.getSource()).method_9211());
        api.getPlayingSongs().stream().filter(handle -> listeners.stream().allMatch(handle::isListener)).map(SongHandle::getSongId).map(class_2960::toString).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static String transformString(String s) {
        s = ((String)s).replace('\\', '/');
        boolean needsQuoting = false;
        int len = ((String)s).length();
        for (int i = 0; i < len; ++i) {
            char c = ((String)s).charAt(i);
            if (StringReader.isAllowedInUnquotedString((char)c)) continue;
            needsQuoting = true;
            break;
        }
        if (needsQuoting) {
            s = "\"" + (String)s + "\"";
        }
        return s;
    }

    private boolean extendedRangePredicate(class_2168 source) {
        if (!this.serverPackManager.isEnabled()) {
            return false;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return false;
        }
        NoticaImpl instance = NoticaImpl.getInstance(player.method_51469().method_8503());
        return !instance.hasModInstalled(player);
    }

    private CompletableFuture<Suggestions> suggestTimes(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        builder.suggest("+10s");
        builder.suggest("-10s");
        builder.suggest("15s");
        builder.suggest("1m5s");
        builder.suggest("50sec+3ticks");
        builder.suggest("1min-50ticks");
        return builder.buildFuture();
    }

    private record TimeOffsets(List<IntObjectPair<TimeUnit>> offsets, boolean absolute) {
        public TextTranslatable translatedText(Translations translations) {
            return lang -> {
                class_5250 acc = class_2561.method_43473();
                boolean first = true;
                for (IntObjectPair<TimeUnit> timeUnitIntObjectPair : this.offsets) {
                    int num = timeUnitIntObjectPair.keyInt();
                    char sign = num >= 0 ? (char)'+' : (char)'-';
                    String translationKey = switch (((TimeUnit)((Object)((Object)timeUnitIntObjectPair.value()))).ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> "notica.time.ticks";
                        case 1 -> "notica.time.seconds";
                        case 2 -> "notica.time.minutes";
                    };
                    Object msg = first ? "" : " ";
                    msg = (String)msg + (String)(!this.absolute || !first ? sign + " " : "");
                    msg = (String)msg + translations.translateText(lang, translationKey, new Object[]{Math.abs(num)}).getString();
                    acc = acc.method_27693((String)msg);
                    first = false;
                }
                return acc;
            };
        }
    }

    private static enum TimeUnit {
        TICKS,
        SECONDS,
        MINUTES;

    }
}

