/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.config;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import work.lclpnet.config.json.ConfigHandler;
import work.lclpnet.config.json.ConfigSerializer;
import work.lclpnet.config.json.FileConfigSerializer;
import work.lclpnet.config.json.JsonConfig;
import work.lclpnet.notica.config.ConfigAccess;
import work.lclpnet.notica.config.NoticaConfig;

public class ConfigManager
implements ConfigAccess {
    private final ConfigHandler<NoticaConfig> handler;

    public ConfigManager(Path configPath, Logger logger) {
        FileConfigSerializer serializer = new FileConfigSerializer(NoticaConfig.FACTORY, logger);
        this.handler = new ConfigHandler(configPath, (ConfigSerializer)serializer, logger);
        this.handler.setConfig((JsonConfig)new NoticaConfig());
    }

    @Override
    public NoticaConfig getConfig() {
        return (NoticaConfig)this.handler.getConfig();
    }

    public CompletableFuture<Void> init() {
        return CompletableFuture.runAsync(() -> this.handler.loadConfig());
    }
}

