/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.config;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import work.lclpnet.config.json.JsonConfig;
import work.lclpnet.config.json.JsonConfigFactory;

public class NoticaConfig
implements JsonConfig {
    @Nullable
    public URL extraNotesPackUrl = null;
    public static final JsonConfigFactory<NoticaConfig> FACTORY = new JsonConfigFactory<NoticaConfig>(){

        public NoticaConfig createDefaultConfig() {
            return new NoticaConfig();
        }

        public NoticaConfig createConfig(JSONObject json) {
            return new NoticaConfig(json);
        }
    };

    public NoticaConfig() {
        this.setDefaultUrl();
    }

    public NoticaConfig(JSONObject json) {
        this.setDefaultUrl();
        if (json.has("extra-notes-pack-url")) {
            String urlString = json.getString("extra-notes-pack-url");
            try {
                this.extraNotesPackUrl = URI.create(urlString).toURL();
            }
            catch (MalformedURLException e) {
                this.extraNotesPackUrl = null;
            }
        }
    }

    private void setDefaultUrl() {
        try {
            this.extraNotesPackUrl = URI.create("https://github.com/LCLPYT/notica/releases/download/1.0.0%2B1.20.4/extranotes.zip").toURL();
        }
        catch (MalformedURLException e) {
            this.extraNotesPackUrl = null;
        }
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("extra-notes-pack-url", this.extraNotesPackUrl == null ? JSONObject.NULL : this.extraNotesPackUrl.toString());
        return json;
    }
}

