/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import work.lclpnet.notica.api.AggregatingPlayer;
import work.lclpnet.notica.api.InstrumentSoundProvider;
import work.lclpnet.notica.api.NotePlayer;
import work.lclpnet.notica.api.PlayerConfig;
import work.lclpnet.notica.api.data.CustomInstrument;
import work.lclpnet.notica.api.data.Layer;
import work.lclpnet.notica.api.data.Note;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.impl.DirectSoundManager;
import work.lclpnet.notica.impl.NbsSoundInstance;
import work.lclpnet.notica.util.NoteHelper;

@Environment(value=EnvType.CLIENT)
public class ClientAggregatingNotePlayer
implements NotePlayer,
AggregatingPlayer {
    private static final int MAX_QUEUED_NOTES = 1024;
    private final InstrumentSoundProvider soundProvider;
    private final float volume;
    private final PlayerConfig playerConfig;
    private final DirectSoundManager directSoundManager;
    private final List<NbsSoundInstance> notes = new ArrayList<NbsSoundInstance>(16);
    private int deSyncedNotes = 0;

    public ClientAggregatingNotePlayer(InstrumentSoundProvider soundProvider, float volume, PlayerConfig playerConfig, DirectSoundManager directSoundManager) {
        this.soundProvider = soundProvider;
        this.volume = volume;
        this.playerConfig = playerConfig;
        this.directSoundManager = directSoundManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playNote(Song song, Layer layer, Note note) {
        byte key;
        class_3414 sound;
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        byte instrument = note.instrument();
        CustomInstrument custom = song.instruments().custom(instrument);
        if (custom != null) {
            sound = this.soundProvider.getCustomInstrumentSound(custom);
            key = (byte)(note.key() + custom.key() - 45);
        } else {
            sound = this.soundProvider.getVanillaInstrumentSound(instrument);
            key = note.key();
        }
        if (sound == null) {
            return;
        }
        float openAlPitch = NoteHelper.openAlPitch((short)(key * 100 + note.pitch()));
        float volume = (float)(layer.volume() * note.velocity()) * 1.0E-4f * this.volume * this.playerConfig.getVolume();
        float panning = NoteHelper.normalizePanning(layer.panning(), note.panning());
        if (volume <= 0.0f) {
            return;
        }
        NbsSoundInstance instance = new NbsSoundInstance(sound.comp_3319(), class_3419.field_15247, volume, openAlPitch, player.method_59922(), false, 0, class_1113.class_1114.field_5478, 2.0f * panning, 0.0, 0.0, true, this.directSoundManager);
        ClientAggregatingNotePlayer clientAggregatingNotePlayer = this;
        synchronized (clientAggregatingNotePlayer) {
            if (this.notes.size() < 1024) {
                this.notes.add(instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishAggregation() {
        int count;
        class_310 client = class_310.method_1551();
        class_1144 soundManager = client.method_1483();
        ClientAggregatingNotePlayer clientAggregatingNotePlayer = this;
        synchronized (clientAggregatingNotePlayer) {
            count = Math.max(0, this.notes.size() - this.deSyncedNotes);
            this.deSyncedNotes += count;
        }
        client.method_40000(() -> {
            ClientAggregatingNotePlayer clientAggregatingNotePlayer = this;
            synchronized (clientAggregatingNotePlayer) {
                List<NbsSoundInstance> range = this.notes.subList(0, count);
                range.forEach(arg_0 -> ((class_1144)soundManager).method_4873(arg_0));
                range.clear();
                this.deSyncedNotes -= count;
            }
        });
    }
}

