/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import work.lclpnet.notica.api.InstrumentSoundProvider;
import work.lclpnet.notica.api.data.CustomInstrument;
import work.lclpnet.notica.util.NoteHelper;

public class FabricInstrumentSoundProvider
implements InstrumentSoundProvider {
    public static final int HARP = 0;
    public static final int BASS = 1;
    public static final int BASEDRUM = 2;
    public static final int SNARE = 3;
    public static final int HAT = 4;
    public static final int GUITAR = 5;
    public static final int FLUTE = 6;
    public static final int BELL = 7;
    public static final int CHIME = 8;
    public static final int XYLOPHONE = 9;
    public static final int IRON_XYLOPHONE = 10;
    public static final int COW_BELL = 11;
    public static final int DIDGERIDOO = 12;
    public static final int BIT = 13;
    public static final int BANJO = 14;
    public static final int PLING = 15;
    private final class_2378<class_3414> soundRegistry;
    private final Map<CustomInstrument, class_3414> cache = new HashMap<CustomInstrument, class_3414>();
    private final Map<String, class_3414> extended = new HashMap<String, class_3414>();

    public FabricInstrumentSoundProvider(MinecraftServer server) {
        this((class_5455)server.method_30611());
    }

    public FabricInstrumentSoundProvider(class_5455 registryManager) {
        this((class_2378<class_3414>)registryManager.method_30530(class_7924.field_41225));
    }

    public FabricInstrumentSoundProvider(class_2378<class_3414> soundRegistry) {
        this.soundRegistry = soundRegistry;
    }

    @Override
    @Nullable
    public class_3414 getVanillaInstrumentSound(byte instrument) {
        return switch (instrument) {
            case 0 -> (class_3414)class_3417.field_15114.comp_349();
            case 1 -> (class_3414)class_3417.field_14624.comp_349();
            case 2 -> (class_3414)class_3417.field_15047.comp_349();
            case 3 -> (class_3414)class_3417.field_14708.comp_349();
            case 4 -> (class_3414)class_3417.field_15204.comp_349();
            case 5 -> (class_3414)class_3417.field_14903.comp_349();
            case 6 -> (class_3414)class_3417.field_14989.comp_349();
            case 7 -> (class_3414)class_3417.field_14793.comp_349();
            case 8 -> (class_3414)class_3417.field_14725.comp_349();
            case 9 -> (class_3414)class_3417.field_14776.comp_349();
            case 10 -> (class_3414)class_3417.field_18308.comp_349();
            case 11 -> (class_3414)class_3417.field_18309.comp_349();
            case 12 -> (class_3414)class_3417.field_18310.comp_349();
            case 13 -> (class_3414)class_3417.field_18311.comp_349();
            case 14 -> (class_3414)class_3417.field_18312.comp_349();
            case 15 -> (class_3414)class_3417.field_14622.comp_349();
            default -> null;
        };
    }

    @Override
    @Nullable
    public class_3414 getCustomInstrumentSound(CustomInstrument instrument) {
        class_3414 sound = this.cache.get(instrument);
        if (sound != null) {
            return sound;
        }
        sound = this.fetchCustomSound(instrument);
        if (sound != null) {
            this.cache.put(instrument, sound);
        }
        return sound;
    }

    @Override
    @NotNull
    public class_3414 getExtendedSound(@NotNull class_3414 sound, byte key, short pitch) {
        String name = NoteHelper.getExtendedSoundName(sound.comp_3319().toString(), key, pitch);
        class_3414 extendedSound = this.extended.get(name);
        if (extendedSound != null) {
            return extendedSound;
        }
        class_2960 id = class_2960.method_60654((String)name);
        extendedSound = sound.comp_3320().map(fixedRanged -> class_3414.method_47909((class_2960)id, (float)fixedRanged.floatValue())).orElseGet(() -> class_3414.method_47908((class_2960)id));
        this.extended.put(name, extendedSound);
        return extendedSound;
    }

    @Nullable
    private class_3414 fetchCustomSound(CustomInstrument instrument) {
        class_3414 sound;
        class_3414 sound2;
        String name = instrument.name();
        if ("Tempo Changer".equals(name)) {
            return null;
        }
        String file = instrument.soundFile();
        if (file.endsWith(".ogg")) {
            file = file.substring(0, file.length() - 4);
        }
        if (file.equalsIgnoreCase("pling")) {
            return (class_3414)class_3417.field_14622.comp_349();
        }
        class_2960 idFromFile = class_2960.method_12829((String)file);
        if (idFromFile != null && (sound2 = (class_3414)this.soundRegistry.method_63535(idFromFile)) != null) {
            return sound2;
        }
        class_2960 idFromName = class_2960.method_12829((String)name);
        if (idFromName != null && (sound = (class_3414)this.soundRegistry.method_63535(idFromName)) != null) {
            return sound;
        }
        if (idFromFile != null) {
            return class_3414.method_47908((class_2960)idFromFile);
        }
        if (idFromName != null) {
            return class_3414.method_47908((class_2960)idFromName);
        }
        return null;
    }
}

