/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import work.lclpnet.notica.api.Index;
import work.lclpnet.notica.api.IndexPointer;
import work.lclpnet.notica.impl.MutableIndexPointer;

public class FixedIndex<T>
implements Index<T> {
    private final int[] indexMapping;
    private final int[] reverseIndexMapping;
    private final List<T> items;
    private final int minIndex;
    private final int maxIndex;

    public FixedIndex(Map<Integer, ? extends T> map) {
        int minIndex = 0;
        int maxIndex = -1;
        for (Integer i : map.keySet()) {
            if (i == null) continue;
            if (i > maxIndex) {
                maxIndex = i;
            }
            if (i >= minIndex) continue;
            minIndex = i;
        }
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        int width = maxIndex - minIndex + 1;
        this.indexMapping = new int[width];
        this.reverseIndexMapping = new int[map.size()];
        int i = 0;
        for (int j = 0; j < width; ++j) {
            T value = map.get(j + minIndex);
            if (value == null) {
                this.indexMapping[j] = -1;
                continue;
            }
            this.reverseIndexMapping[i] = j;
            this.indexMapping[j] = i++;
        }
        this.items = map.entrySet().stream().filter(e -> e.getKey() != null).sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).toList();
    }

    @Override
    @Nullable
    public T get(int i) {
        int mappedIndex = this.mapIndex(i);
        if (mappedIndex == -1) {
            return null;
        }
        return this.items.get(mappedIndex);
    }

    @Override
    public OptionalInt index(T value) {
        int idx = this.items.indexOf(value);
        if (idx == -1) {
            return OptionalInt.empty();
        }
        if ((idx = this.unmapIndex(idx)) < this.minIndex) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(idx);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public Iterable<Integer> keysOrdered() {
        return () -> Arrays.stream(this.reverseIndexMapping).iterator();
    }

    @Override
    public Iterable<IndexPointer<T>> iterateOrdered() {
        return () -> new IndexIterator();
    }

    @Override
    public OptionalInt maxIndex() {
        return this.maxIndex >= 0 ? OptionalInt.of(this.maxIndex) : OptionalInt.empty();
    }

    private int mapIndex(int i) {
        if ((i -= this.minIndex) < 0 || i >= this.indexMapping.length) {
            return -1;
        }
        return this.indexMapping[i];
    }

    private int unmapIndex(int i) {
        i = i < 0 || i >= this.reverseIndexMapping.length ? -1 : this.reverseIndexMapping[i];
        return i + this.minIndex;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public String toString() {
        return "ListIndex(%s)".formatted(this.items.size());
    }

    private class IndexIterator
    implements Iterator<IndexPointer<T>> {
        private final MutableIndexPointer<T> pointer = new MutableIndexPointer();
        private boolean hasNext = false;
        private boolean done = false;
        private int nextIndex = 0;

        private IndexIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.hasNext) {
                this.advance();
            }
            return !this.done;
        }

        private void advance() {
            int index;
            if ((index = this.nextIndex++) >= FixedIndex.this.items.size()) {
                this.done = true;
                return;
            }
            int unmappedIndex = FixedIndex.this.unmapIndex(index);
            this.pointer.set(unmappedIndex, FixedIndex.this.items.get(index));
            this.hasNext = true;
        }

        @Override
        public IndexPointer<T> next() {
            this.hasNext = false;
            return this.pointer;
        }
    }
}

