/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import work.lclpnet.notica.api.Index;
import work.lclpnet.notica.api.IndexPointer;
import work.lclpnet.notica.impl.MutableIndexPointer;

public class MutableIndex<T>
implements Index<T> {
    private final Map<Integer, T> map = new HashMap<Integer, T>();
    private final Map<T, Integer> indexMap = new HashMap<T, Integer>();
    private int maxIndex = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T get(int i) {
        MutableIndex mutableIndex = this;
        synchronized (mutableIndex) {
            return this.map.get(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptionalInt index(T value) {
        Integer i;
        MutableIndex mutableIndex = this;
        synchronized (mutableIndex) {
            i = this.indexMap.get(value);
        }
        if (i == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        MutableIndex mutableIndex = this;
        synchronized (mutableIndex) {
            return this.map.size();
        }
    }

    @Override
    public Iterable<IndexPointer<T>> iterateOrdered() {
        final Iterator<T> parent = this.iterator();
        return () -> new Iterator<IndexPointer<T>>(){
            private final MutableIndexPointer<T> pointer = new MutableIndexPointer();

            @Override
            public boolean hasNext() {
                return parent.hasNext();
            }

            @Override
            public IndexPointer<T> next() {
                Object next = parent.next();
                int index = MutableIndex.this.indexMap.get(next);
                this.pointer.set(index, next);
                return this.pointer;
            }
        };
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).iterator();
    }

    @Override
    public OptionalInt maxIndex() {
        return this.maxIndex >= 0 ? OptionalInt.of(this.maxIndex) : OptionalInt.empty();
    }

    public synchronized void set(int i, T value) {
        if (value == null) {
            value = this.map.remove(i);
            if (value == null) {
                return;
            }
            this.indexMap.remove(value);
            this.maxIndex = this.map.keySet().stream().mapToInt(idx -> idx).max().orElse(-1);
            return;
        }
        T oldValue = this.map.put(i, value);
        if (oldValue != null) {
            this.indexMap.remove(oldValue);
        }
        this.indexMap.put(value, i);
        this.maxIndex = Math.max(this.maxIndex, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T computeIfAbsent(int i, Function<Integer, T> mappingFunction) {
        MutableIndex mutableIndex = this;
        synchronized (mutableIndex) {
            T val = this.map.get(i);
            if (val != null) {
                return val;
            }
            val = mappingFunction.apply(i);
            this.set(i, val);
            return val;
        }
    }
}

