/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import work.lclpnet.kibu.hook.Hook;
import work.lclpnet.kibu.hook.HookFactory;
import work.lclpnet.notica.api.CheckedSong;
import work.lclpnet.notica.api.IndividualSongPlayback;
import work.lclpnet.notica.api.InstrumentSoundProvider;
import work.lclpnet.notica.api.PlaybackOptions;
import work.lclpnet.notica.api.PlayerStoppedPlaybackListener;
import work.lclpnet.notica.api.SongHandle;
import work.lclpnet.notica.api.SongSlice;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.impl.ServerBasicNotePlayer;
import work.lclpnet.notica.impl.SongPlayerRef;
import work.lclpnet.notica.network.SongHeader;
import work.lclpnet.notica.network.SongPlayOptions;
import work.lclpnet.notica.network.SongSlicer;
import work.lclpnet.notica.network.packet.PlaySongS2CPacket;
import work.lclpnet.notica.network.packet.SongSeekS2CPacket;
import work.lclpnet.notica.network.packet.StopSongBidiPacket;

public class ServerSongHandle
implements SongHandle,
PlayerStoppedPlaybackListener {
    private final CheckedSong checkedSong;
    private final PlaybackOptions playbackOptions;
    private final int startTick;
    private final Map<UUID, SongPlayerRef> vanillaRefs = new HashMap<UUID, SongPlayerRef>();
    private final Map<UUID, SongPlayerRef> moddedRefs = new HashMap<UUID, SongPlayerRef>();
    private volatile boolean started = false;
    @Nullable
    private IndividualSongPlayback serverPlayback = null;
    @Nullable
    private ServerBasicNotePlayer serverNotePlayer = null;
    private final Hook<Runnable> onDestroy = HookFactory.createArrayBacked(Runnable.class, callbacks -> () -> {
        for (Runnable callback : callbacks) {
            callback.run();
        }
    });
    private boolean destroyed = false;

    public ServerSongHandle(CheckedSong checkedSong, PlaybackOptions playbackOptions, int startTick) {
        this.checkedSong = checkedSong;
        this.playbackOptions = playbackOptions;
        this.startTick = startTick;
    }

    public synchronized void start(Set<SongPlayerRef> vanillaPlayers, Set<SongPlayerRef> moddedPlayers, InstrumentSoundProvider soundProvider) {
        IndividualSongPlayback playback;
        if (this.started) {
            return;
        }
        this.started = true;
        this.moddedRefs.clear();
        for (SongPlayerRef playerRef : moddedPlayers) {
            class_3222 player = playerRef.getPlayer();
            this.sendPlayPacket(player);
            this.moddedRefs.put(player.method_5667(), playerRef);
        }
        this.vanillaRefs.clear();
        for (SongPlayerRef playerRef : vanillaPlayers) {
            UUID uuid = playerRef.getPlayer().method_5667();
            this.vanillaRefs.put(uuid, playerRef);
        }
        this.serverNotePlayer = new ServerBasicNotePlayer(vanillaPlayers, soundProvider, this.playbackOptions.volume());
        this.serverPlayback = playback = this.createServerPlayback();
        playback.start(this.startTick);
    }

    @NotNull
    private IndividualSongPlayback createServerPlayback() {
        IndividualSongPlayback playback = new IndividualSongPlayback(this.checkedSong.song(), this.serverNotePlayer, this.playbackOptions.loopOverride());
        playback.whenDone(() -> {
            this.vanillaRefs.clear();
            this.checkDestroyed();
            if (this.destroyed) {
                return;
            }
            Thread.startVirtualThread(() -> {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.stop();
            });
        });
        return playback;
    }

    private void sendPlayPacket(class_3222 player) {
        Song song = this.checkedSong.song();
        SongHeader header = new SongHeader(song);
        SongSlice slice = SongSlicer.sliceSeconds(song, this.startTick, 5);
        boolean finished = SongSlicer.isFinished(song, slice);
        SongPlayOptions options = new SongPlayOptions(this.checkedSong.id(), this.playbackOptions, this.startTick);
        PlaySongS2CPacket packet = new PlaySongS2CPacket(options, header, slice, finished, this.checkedSong.checksum());
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    private void sendStopPacket(class_3222 player) {
        StopSongBidiPacket packet = new StopSongBidiPacket(this.checkedSong.id());
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    private void sendSeekPacket(class_3222 player, int ticks, boolean absolute) {
        SongSeekS2CPacket packet = new SongSeekS2CPacket(this.checkedSong.id(), ticks, absolute);
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    @Override
    public class_2960 getSongId() {
        return this.checkedSong.id();
    }

    @Override
    public Song getSong() {
        return this.checkedSong.song();
    }

    @Override
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        for (SongPlayerRef playerRef : this.moddedRefs.values()) {
            this.sendStopPacket(playerRef.getPlayer());
        }
        this.moddedRefs.clear();
        if (this.serverPlayback != null) {
            this.serverPlayback.stop();
            this.serverPlayback = null;
        }
        this.vanillaRefs.clear();
        this.serverNotePlayer = null;
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        ServerSongHandle serverSongHandle = this;
        synchronized (serverSongHandle) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        ((Runnable)this.onDestroy.invoker()).run();
    }

    @Override
    public synchronized Set<class_3222> getListeners() {
        HashSet<class_3222> listeners = new HashSet<class_3222>();
        for (SongPlayerRef playerRef : this.moddedRefs.values()) {
            listeners.add(playerRef.getPlayer());
        }
        for (SongPlayerRef playerRef : this.vanillaRefs.values()) {
            listeners.add(playerRef.getPlayer());
        }
        return listeners;
    }

    @Override
    public synchronized boolean isListener(class_3222 player) {
        UUID uuid = player.method_5667();
        return this.moddedRefs.containsKey(uuid) || this.vanillaRefs.containsKey(uuid);
    }

    @Override
    public synchronized void remove(class_3222 player) {
        UUID uuid = player.method_5667();
        if (this.moddedRefs.remove(uuid) != null) {
            this.sendStopPacket(player);
            this.checkDestroyed();
            return;
        }
        SongPlayerRef playerRef = this.vanillaRefs.remove(uuid);
        if (playerRef == null) {
            return;
        }
        if (this.serverNotePlayer != null) {
            this.serverNotePlayer.removePlayer(playerRef);
        }
        if (this.vanillaRefs.isEmpty() && this.serverPlayback != null) {
            this.serverPlayback.stop();
            this.serverPlayback = null;
            this.serverNotePlayer = null;
        }
        this.checkDestroyed();
    }

    @Override
    public synchronized void onDestroy(Runnable action) {
        this.onDestroy.register((Object)action);
    }

    @Override
    public synchronized void onStoppedPlayback(class_3222 player) {
        this.moddedRefs.remove(player.method_5667());
        this.checkDestroyed();
    }

    private void checkDestroyed() {
        if (!this.moddedRefs.isEmpty() || !this.vanillaRefs.isEmpty()) {
            return;
        }
        this.destroy();
    }

    public String toString() {
        return "ServerSongHandle{checkedSong=%s, volume=%s, vanillaPlayers=%s, moddedPlayers=%s, started=%s}".formatted(this.checkedSong, this.playbackOptions, this.vanillaRefs, this.moddedRefs, this.started);
    }

    @Override
    public synchronized void seekTo(int ticks, boolean absolute) {
        if (this.serverPlayback != null) {
            this.serverPlayback.seekTo(ticks, absolute);
        }
        for (SongPlayerRef ref : this.moddedRefs.values()) {
            this.sendSeekPacket(ref.getPlayer(), ticks, absolute);
        }
    }
}

