/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.VisibleForTesting;
import work.lclpnet.notica.api.data.SongTempo;
import work.lclpnet.notica.api.data.TempoChange;

public class ImmutableSongTempo
implements SongTempo {
    private final Set<Integer> changeTimes;
    private final List<TempoChange> sections;
    private final float[] sectionTempo;
    private final int[] sectionStarts;

    public ImmutableSongTempo(List<TempoChange> tempoChanges) {
        this.changeTimes = new HashSet<Integer>(tempoChanges.size());
        ArrayList<TempoChange> filtered = new ArrayList<TempoChange>(tempoChanges.size());
        tempoChanges = new ArrayList<TempoChange>(tempoChanges);
        Collections.reverse(tempoChanges);
        for (TempoChange change : tempoChanges) {
            int time = change.timeTick();
            if (time < 0 || !this.changeTimes.add(time)) continue;
            filtered.add(change);
        }
        filtered.sort(Comparator.comparingInt(TempoChange::timeTick));
        int size = filtered.size();
        this.sectionStarts = new int[size];
        this.sectionTempo = new float[size];
        for (int i = 0; i < size; ++i) {
            TempoChange change = (TempoChange)filtered.get(i);
            this.sectionStarts[i] = change.timeTick();
            this.sectionTempo[i] = change.ticksPerSecond();
        }
        this.sections = Collections.unmodifiableList(filtered);
    }

    @Override
    public List<TempoChange> changes() {
        return this.sections;
    }

    @Override
    public boolean changeAt(int timeTick) {
        return this.changeTimes.contains(timeTick);
    }

    @Override
    public float tempoAt(int timeTick) {
        return this.sectionTempo[this.sectionAt(timeTick)];
    }

    @VisibleForTesting
    int sectionAt(int timeTick) {
        int i = Arrays.binarySearch(this.sectionStarts, timeTick);
        if (i >= 0) {
            return i;
        }
        return Math.max(0, -(i + 1) - 1);
    }

    @Override
    public float durationSeconds(int _startTicks, int durationTicks) {
        int _endTicks = _startTicks + durationTicks;
        int startTicks = Math.min(_startTicks, _endTicks);
        int endTicks = Math.max(_startTicks, _endTicks);
        int startSection = this.sectionAt(startTicks);
        int endSection = this.sectionAt(endTicks);
        float timeSeconds = 0.0f;
        int offsetTicks = startTicks;
        int sectionTicks = this.getSectionTicks(startSection, offsetTicks, durationTicks);
        timeSeconds += (float)sectionTicks / this.sectionTempo[startSection];
        offsetTicks += sectionTicks;
        durationTicks -= sectionTicks;
        for (int section = startSection + 1; section < endSection; ++section) {
            sectionTicks = this.getSectionTicks(section, offsetTicks, durationTicks);
            timeSeconds += (float)sectionTicks / this.sectionTempo[section];
            offsetTicks += sectionTicks;
            durationTicks -= sectionTicks;
        }
        if (endSection != startTicks) {
            sectionTicks = this.getSectionTicks(endSection, offsetTicks, durationTicks);
            timeSeconds += (float)sectionTicks / this.sectionTempo[endSection];
        }
        return timeSeconds;
    }

    @Override
    public int durationTicks(int offsetTicks, float remainingSeconds) {
        int direction = (int)Math.signum(remainingSeconds);
        if (direction == 0) {
            return 0;
        }
        remainingSeconds = Math.abs(remainingSeconds);
        int durationTicks = 0;
        while (remainingSeconds > 0.0f) {
            int section = this.sectionAt(offsetTicks);
            if (direction > 0 && section < this.sectionStarts.length - 1 || direction < 0 && section > 0) {
                int sectionTicks = direction > 0 ? this.sectionStarts[section + 1] - offsetTicks : offsetTicks - this.sectionStarts[section] + 1;
                float sectionSeconds = (float)sectionTicks / this.sectionTempo[section];
                float seconds = Math.min(remainingSeconds, sectionSeconds);
                if (seconds < sectionSeconds) {
                    sectionTicks = (int)Math.ceil(seconds * this.sectionTempo[section]);
                }
                durationTicks += sectionTicks;
                remainingSeconds -= seconds;
                offsetTicks += direction * sectionTicks;
                continue;
            }
            durationTicks += (int)Math.ceil(remainingSeconds * this.sectionTempo[section]);
            remainingSeconds = 0.0f;
        }
        return durationTicks;
    }

    private int getSectionTicks(int section, int offsetTicks, int remainingTicks) {
        if (section < this.sectionStarts.length - 1) {
            return Math.min(remainingTicks, this.sectionStarts[section + 1] - offsetTicks);
        }
        return remainingTicks;
    }
}

