/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.ds;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Debounce {
    private final int delayMs;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> future;

    public Debounce(int delayMs) {
        this.delayMs = delayMs;
    }

    public synchronized void debounce(Runnable action) {
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(false);
        }
        this.future = this.scheduler.schedule(action, (long)this.delayMs, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }
}

