/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.ds;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import work.lclpnet.notica.impl.ds.SendReceive;

@Environment(value=EnvType.CLIENT)
public class SemiBlockingSendReceive<T>
implements SendReceive<T> {
    private final Semaphore semaphore;
    private final int offerTimeoutMs;
    private final Queue<T> queue = new LinkedList<T>();

    public SemiBlockingSendReceive(int capacity, int offerTimeoutMs) {
        this.semaphore = new Semaphore(capacity, true);
        this.offerTimeoutMs = offerTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T item) throws InterruptedException {
        if (!this.semaphore.tryAcquire(this.offerTimeoutMs, TimeUnit.MILLISECONDS)) {
            return false;
        }
        SemiBlockingSendReceive semiBlockingSendReceive = this;
        synchronized (semiBlockingSendReceive) {
            if (!this.queue.offer(item)) {
                this.semaphore.release();
                return false;
            }
            return true;
        }
    }

    @Override
    public synchronized T take() {
        if (this.queue.isEmpty()) {
            return null;
        }
        T item = this.queue.poll();
        this.semaphore.release();
        return item;
    }

    @Override
    public synchronized int size() {
        return this.queue.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public synchronized void clear() {
        int size = this.queue.size();
        this.queue.clear();
        this.semaphore.release(size);
    }
}

