/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.mix;

import java.util.Arrays;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Scope {
    private final float[] sampleBuffer;
    private final float[][] buffers;

    public Scope(int sampleBufferCount, int bufferCount, int bufferSize) {
        this.sampleBuffer = new float[sampleBufferCount * bufferSize];
        this.buffers = new float[bufferCount][0];
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i] = new float[bufferSize];
        }
    }

    public float[] getBuffer(int i) {
        return this.buffers[i];
    }

    public void copy(Scope scope) {
        int bufferCount = scope.buffers.length;
        if (bufferCount != this.buffers.length) {
            throw new IllegalArgumentException("Buffer count mismatch");
        }
        for (int i = 0; i < bufferCount; ++i) {
            float[] src = scope.buffers[i];
            float[] dst = this.buffers[i];
            System.arraycopy(src, 0, dst, 0, src.length);
        }
    }

    public void add(Scope scope) {
        int bufferCount = scope.buffers.length;
        if (bufferCount != this.buffers.length) {
            throw new IllegalArgumentException("Buffer count mismatch");
        }
        for (int i = 0; i < bufferCount; ++i) {
            float[] src = scope.buffers[i];
            float[] dst = this.buffers[i];
            Scope.add(src, dst);
        }
    }

    private static void add(float[] src, float[] dst) {
        int len = src.length;
        if (len != dst.length) {
            throw new IllegalArgumentException("Buffer length mismatch");
        }
        for (int j = 0; j < len; ++j) {
            int n = j;
            dst[n] = dst[n] + src[j];
        }
    }

    public void reset() {
        this.resetBuffer(this.sampleBuffer);
        for (int i = 0; i < this.buffers.length; ++i) {
            this.resetBuffer(i);
        }
    }

    public void resetBuffer(int buffer) {
        this.resetBuffer(this.buffers[buffer]);
    }

    private void resetBuffer(float[] buf) {
        Arrays.fill(buf, 0.0f);
    }

    public int getBufferCount() {
        return this.buffers.length;
    }

    @Generated
    public float[] getSampleBuffer() {
        return this.sampleBuffer;
    }
}

