/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.mix;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;
import work.lclpnet.notica.api.StereoMode;
import work.lclpnet.notica.api.data.LoopOverride;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.impl.mix.NoteSampler;
import work.lclpnet.notica.impl.mix.NoteSamplerFactory;
import work.lclpnet.notica.impl.mix.ParallelBatchSongMixer;
import work.lclpnet.notica.impl.mix.SongAudioStream;
import work.lclpnet.notica.impl.mix.SoundMixer;
import work.lclpnet.notica.impl.mix.SoundSampleManager;

@Environment(value=EnvType.CLIENT)
public class SongExporter {
    private final SoundSampleManager sampleManager;
    private final NoteSamplerFactory noteSamplerFactory;
    private final AudioFormat inputFormat;
    private final Logger logger;
    private final int workerCount;
    private final float chunkSeconds;
    private final float maxExportSeconds;

    public SongExporter(SoundSampleManager sampleManager, NoteSamplerFactory noteSamplerFactory, AudioFormat inputFormat, Logger logger, int workerCount) {
        this(sampleManager, noteSamplerFactory, inputFormat, logger, workerCount, 1.0f, 14400.0f);
    }

    public SongExporter(SoundSampleManager sampleManager, NoteSamplerFactory noteSamplerFactory, AudioFormat inputFormat, Logger logger, int workerCount, float chunkSeconds, float maxExportSeconds) {
        this.sampleManager = sampleManager;
        this.noteSamplerFactory = noteSamplerFactory;
        this.inputFormat = inputFormat;
        this.logger = logger;
        this.workerCount = workerCount;
        this.chunkSeconds = chunkSeconds;
        this.maxExportSeconds = maxExportSeconds;
    }

    public void export(Song song, float volume, StereoMode stereoMode, Path path) throws IOException {
        int bufferBytes = SongAudioStream.getByteSize(this.inputFormat, this.chunkSeconds);
        NoteSampler noteSampler = this.noteSamplerFactory.create(this.sampleManager, this.inputFormat, stereoMode, song.instruments());
        SoundMixer soundMixer = new SoundMixer(this.inputFormat, noteSampler, bufferBytes, this.workerCount);
        ParallelBatchSongMixer songMixer = new ParallelBatchSongMixer(soundMixer, song, this.workerCount);
        songMixer.setSongVolume(volume);
        SongAudioStream stream = new SongAudioStream(this.inputFormat, soundMixer, songMixer, song, soundMixer::applyCompressor, this.logger, bufferBytes, LoopOverride.DEFAULT.withEnabled(false), true);
        stream.startProducer(1).join();
        Path tmpFile = Files.createTempFile("notica_export", null, new FileAttribute[0]);
        int maxIterations = (int)Math.ceil(this.maxExportSeconds / this.chunkSeconds);
        int samples = 0;
        try (OutputStream out = Files.newOutputStream(tmpFile, new OpenOption[0]);){
            byte[] array = new byte[bufferBytes];
            for (int i = 0; i < maxIterations; ++i) {
                ByteBuffer buf = stream.method_19720(bufferBytes);
                if (buf == null) {
                    break;
                }
                int len = buf.remaining();
                buf.get(array, 0, len);
                out.write(array, 0, len);
                samples += len;
            }
        }
        try (InputStream in = Files.newInputStream(tmpFile, new OpenOption[0]);
             OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            AudioInputStream audioIn = new AudioInputStream(in, this.inputFormat, samples);
            AudioSystem.write(audioIn, AudioFileFormat.Type.WAVE, out);
        }
    }
}

