/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.mix;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.UnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import work.lclpnet.notica.api.data.Instruments;
import work.lclpnet.notica.impl.mix.SoundRef;
import work.lclpnet.notica.impl.mix.SoundSampleProvider;
import work.lclpnet.notica.impl.mix.UnifiedSoundLoader;

@Environment(value=EnvType.CLIENT)
public class SoundSampleManager {
    private final SoundSampleProvider sampleProvider;
    private final UnifiedSoundLoader soundLoader;
    private final UnaryOperator<float[]> transformer;
    private final float[][] samples;

    public SoundSampleManager(Instruments instruments, SoundSampleProvider sampleProvider, UnifiedSoundLoader soundLoader, UnaryOperator<float[]> transformer) {
        this.sampleProvider = sampleProvider;
        this.soundLoader = soundLoader;
        this.samples = new float[instruments.customBegin() + instruments.custom().length][0];
        this.transformer = transformer;
    }

    public float[] getSample(byte instrument) {
        return this.samples[instrument & 0xFF];
    }

    public void loadAll() {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(this.samples.length);
        for (byte i = 0; i < this.samples.length; i = (byte)(i + 1)) {
            SoundRef sound = this.sampleProvider.getSample(i).orElse(null);
            if (sound == null) continue;
            int idx = i & 0xFF;
            CompletionStage future = this.soundLoader.getUnifiedSample(sound).thenAccept(opt -> opt.map(this.transformer).ifPresent(sample -> {
                this.samples[idx] = sample;
            }));
            futures.add(future);
        }
        futures.forEach(CompletableFuture::join);
    }
}

