/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.impl.mix;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;
import work.lclpnet.notica.api.StereoMode;
import work.lclpnet.notica.impl.mix.CatmullRomNoteSampler;
import work.lclpnet.notica.impl.mix.SoundRef;
import work.lclpnet.notica.impl.mix.SoundSample;
import work.lclpnet.notica.util.ByteBufferInputStream;

@Environment(value=EnvType.CLIENT)
public class UnifiedSoundLoader {
    private static final float INV_SHORT = 3.0517578E-5f;
    private final AudioFormat targetFormat;
    private final Logger logger;
    private final Map<SoundRef, CompletableFuture<Optional<float[]>>> unifiedSamples = new HashMap<SoundRef, CompletableFuture<Optional<float[]>>>();

    public UnifiedSoundLoader(AudioFormat targetFormat, Logger logger) {
        this.targetFormat = targetFormat;
        this.logger = logger;
    }

    public synchronized CompletableFuture<Optional<float[]>> getUnifiedSample(SoundRef sound) {
        CompletionStage<Optional<Object>> future = this.unifiedSamples.get(sound);
        if (future != null) {
            return future;
        }
        future = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)sound.load().thenCompose(this::recode)).thenApply(samples -> UnifiedSoundLoader.toDeinterleavedFloats(samples, this.targetFormat))).thenApply(sample -> this.transformSample((float[])sample, sound))).thenApply(Optional::of)).exceptionally(err -> {
            this.logger.error("Failed to get unified sample for sound {}", (Object)sound, err);
            UnifiedSoundLoader unifiedSoundLoader = this;
            synchronized (unifiedSoundLoader) {
                this.unifiedSamples.remove(sound);
            }
            return Optional.empty();
        });
        if (!((CompletableFuture)future).isCompletedExceptionally()) {
            this.unifiedSamples.put(sound, (CompletableFuture<Optional<float[]>>)future);
        }
        return future;
    }

    public static float[] toDeinterleavedFloats(ByteBuffer samples, AudioFormat format) {
        int channels = format.getChannels();
        int frameCount = samples.limit() / format.getFrameSize();
        samples.position(0);
        float[] floatSamples = new float[frameCount * channels];
        for (int i = 0; i < frameCount; ++i) {
            short ql = samples.getShort();
            short qr = samples.getShort();
            float cl = (float)ql * 3.0517578E-5f;
            float cr = (float)qr * 3.0517578E-5f;
            floatSamples[i] = cl;
            floatSamples[i + frameCount] = cr;
        }
        return floatSamples;
    }

    public static void toInterleavedBytes(float[] floatSamples, int frames, ByteBuffer out, AudioFormat format) {
        int bufferFrames = out.limit() / format.getFrameSize();
        int len = Math.min(bufferFrames, frames);
        for (int i = 0; i < len; ++i) {
            float vl = floatSamples[i];
            float vr = floatSamples[frames + i];
            short ql = (short)Math.max(-32768.0f, Math.min(32767.0f, vl * 32767.0f));
            short qr = (short)Math.max(-32768.0f, Math.min(32767.0f, vr * 32767.0f));
            out.putShort(ql);
            out.putShort(qr);
        }
    }

    private CompletableFuture<ByteBuffer> recode(SoundSample sample) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.recodeSync(sample);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to recode sound", e);
            }
        });
    }

    private ByteBuffer recodeSync(SoundSample sample) throws IOException {
        ByteOrder order;
        ByteBuffer source = sample.sample();
        AudioFormat srcFormat = sample.format();
        ByteOrder byteOrder = order = this.targetFormat.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        if (this.targetFormat.matches(srcFormat)) {
            return source.order(order);
        }
        AudioInputStream sourceIn = new AudioInputStream(new ByteBufferInputStream(source), srcFormat, source.limit());
        AudioInputStream convertedIn = AudioSystem.getAudioInputStream(this.targetFormat, sourceIn);
        byte[] convertedBytes = convertedIn.readAllBytes();
        return ByteBuffer.wrap(convertedBytes).order(order);
    }

    private float[] transformSample(float[] sample, SoundRef sound) {
        sample = CatmullRomNoteSampler.changePitch(sample, sound.pitch(), this.targetFormat);
        int frames = sample.length / 2;
        CatmullRomNoteSampler.applyVolumePanning(sample, frames, sound.volume(), 0.0f, StereoMode.EQUAL_POWER);
        return sample;
    }
}

