/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.network;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import work.lclpnet.kibu.hook.player.PlayerConnectionHooks;
import work.lclpnet.kibu.networking.protocol.Protocol;
import work.lclpnet.kibu.networking.protocol.ServerProtocolHandler;
import work.lclpnet.notica.NoticaInit;
import work.lclpnet.notica.api.SongSlice;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.impl.NoticaImpl;
import work.lclpnet.notica.mixin.ServerLoginNetworkHandlerAccessor;
import work.lclpnet.notica.network.SongSlicer;
import work.lclpnet.notica.network.packet.MusicOptionsS2CPacket;
import work.lclpnet.notica.network.packet.PlaySongS2CPacket;
import work.lclpnet.notica.network.packet.RequestSongC2SPacket;
import work.lclpnet.notica.network.packet.RespondSongS2CPacket;
import work.lclpnet.notica.network.packet.SongSeekS2CPacket;
import work.lclpnet.notica.network.packet.StopSongBidiPacket;

public class NoticaNetworking {
    public static final Protocol PROTOCOL = new Protocol(NoticaInit.identifier("version"), 4);
    public static final int MAX_PACKET_BYTES = 0x800000;
    private static final int RESET_MILLIS = 15000;
    private static final int MAX_REQUESTS = 40;
    private static NoticaNetworking instance = null;
    private final Logger logger;
    private final Map<UUID, PlayerData> playerData = new HashMap<UUID, PlayerData>();
    @Nullable
    private ServerProtocolHandler protocolHandler = null;

    public NoticaNetworking(Logger logger) {
        this.logger = logger;
        instance = this;
    }

    public void register() {
        this.protocolHandler = new ServerProtocolHandler(PROTOCOL, this.logger);
        this.protocolHandler.register();
        PayloadTypeRegistry playS2C = PayloadTypeRegistry.playS2C();
        playS2C.register(MusicOptionsS2CPacket.ID, MusicOptionsS2CPacket.CODEC);
        playS2C.register(PlaySongS2CPacket.ID, PlaySongS2CPacket.CODEC);
        playS2C.register(RespondSongS2CPacket.ID, RespondSongS2CPacket.CODEC);
        playS2C.register(StopSongBidiPacket.ID, StopSongBidiPacket.CODEC);
        playS2C.register(SongSeekS2CPacket.ID, SongSeekS2CPacket.CODEC);
        PayloadTypeRegistry playC2S = PayloadTypeRegistry.playC2S();
        playC2S.register(RequestSongC2SPacket.ID, RequestSongC2SPacket.CODEC);
        playC2S.register(StopSongBidiPacket.ID, StopSongBidiPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(RequestSongC2SPacket.ID, this::onRequestSong);
        ServerPlayNetworking.registerGlobalReceiver(StopSongBidiPacket.ID, this::onSongStopped);
        ServerLoginConnectionEvents.DISCONNECT.register(this::onLoginDisconnect);
        PlayerConnectionHooks.QUIT.register(this::onQuit);
    }

    private void onLoginDisconnect(class_3248 handler, MinecraftServer server) {
        GameProfile profile = ((ServerLoginNetworkHandlerAccessor)handler).getProfile();
        if (profile == null) {
            return;
        }
        this.onQuit(profile.id());
    }

    private void onRequestSong(RequestSongC2SPacket payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        PlayerData data = this.getData(player);
        if (player.method_5691() < 2 && data.throttle()) {
            this.logger.warn("Player {} is sending too many requests", (Object)player.method_5820());
            return;
        }
        class_2960 songId = payload.songId();
        NoticaImpl instance = NoticaImpl.getInstance(player.method_51469().method_8503());
        Optional<Song> optSong = instance.getSong(songId);
        if (optSong.isEmpty()) {
            this.logger.warn("Player {} requested unknown song {}", (Object)player.method_5820(), (Object)songId);
            return;
        }
        Song song = optSong.get();
        int tickOffset = payload.tickOffset();
        int layerOffset = payload.layerOffset();
        this.logger.debug("Player {} requested song slice {}, {} for song {}", new Object[]{player.method_5820(), tickOffset, layerOffset, songId});
        if (SongSlicer.isFinished(song, tickOffset, layerOffset)) {
            this.logger.debug("Cannot send more song data for song {}, end is reached", (Object)songId);
            return;
        }
        int maxBytes = 8388408;
        SongSlice slice = SongSlicer.sliceAt(song, tickOffset, layerOffset, maxBytes);
        boolean finished = SongSlicer.isFinished(song, slice);
        if (finished) {
            this.logger.debug("Song slice response reached the end (song {})", (Object)songId);
        }
        RespondSongS2CPacket responsePacket = new RespondSongS2CPacket(songId, slice, finished);
        ServerPlayNetworking.send((class_3222)player, (class_8710)responsePacket);
    }

    private void onSongStopped(StopSongBidiPacket payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        class_2960 songId = payload.songId();
        NoticaImpl instance = NoticaImpl.getInstance(player.method_51469().method_8503());
        instance.notifySongStopped(player, songId);
    }

    private PlayerData getData(class_3222 player) {
        return this.getData(player.method_5667());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlayerData getData(UUID uuid) {
        NoticaNetworking noticaNetworking = this;
        synchronized (noticaNetworking) {
            return this.playerData.computeIfAbsent(uuid, _uuid -> new PlayerData());
        }
    }

    private void onQuit(class_3222 player) {
        UUID uuid = player.method_5667();
        this.onQuit(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQuit(UUID uuid) {
        NoticaNetworking noticaNetworking = this;
        synchronized (noticaNetworking) {
            this.playerData.remove(uuid);
        }
    }

    public boolean understandsProtocol(class_3222 player) {
        return this.protocolHandler != null && this.protocolHandler.understands(player);
    }

    public static NoticaNetworking getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Notica networking is not yet initialized");
        }
        return instance;
    }

    private static class PlayerData {
        private long lastRequest = 0L;
        private int count = 0;

        private PlayerData() {
        }

        public boolean throttle() {
            long before = this.lastRequest;
            this.lastRequest = System.currentTimeMillis();
            if (this.lastRequest - before >= 15000L) {
                this.count = 1;
                return false;
            }
            return ++this.count >= 40;
        }
    }
}

