/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.class_2540;
import net.minecraft.class_7995;
import net.minecraft.class_8703;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import work.lclpnet.notica.api.Index;
import work.lclpnet.notica.api.IndexPointer;
import work.lclpnet.notica.api.PlaybackOptions;
import work.lclpnet.notica.api.PlaybackVariant;
import work.lclpnet.notica.api.PlayerConfig;
import work.lclpnet.notica.api.SongSlice;
import work.lclpnet.notica.api.StereoMode;
import work.lclpnet.notica.api.data.CustomInstrument;
import work.lclpnet.notica.api.data.Instruments;
import work.lclpnet.notica.api.data.LayerInfo;
import work.lclpnet.notica.api.data.LoopConfig;
import work.lclpnet.notica.api.data.LoopOverride;
import work.lclpnet.notica.api.data.SongTempo;
import work.lclpnet.notica.api.data.TempoChange;
import work.lclpnet.notica.impl.FixedIndex;
import work.lclpnet.notica.impl.data.ImmutableCustomInstrument;
import work.lclpnet.notica.impl.data.ImmutableInstruments;
import work.lclpnet.notica.impl.data.ImmutableLoopConfig;
import work.lclpnet.notica.impl.data.ImmutableSongTempo;
import work.lclpnet.notica.network.SongSlicer;
import work.lclpnet.notica.util.PlayerConfigEntry;

public class NoticaPacketCodecs {
    public static final class_9139<class_2540, PlayerConfig> PLAYER_CONFIG_PACKET_CODEC = class_9139.method_56434((class_9139)class_9135.field_48552, PlayerConfig::getVolume, volume -> {
        PlayerConfigEntry config = new PlayerConfigEntry();
        config.setVolume(volume.floatValue());
        return config;
    });
    public static final class_9139<class_2540, LoopConfig> LOOP_CONFIG_PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.field_48547, LoopConfig::enabled, (class_9139)class_9135.field_49675, LoopConfig::loopCount, (class_9139)class_9135.field_49675, LoopConfig::loopStartTick, ImmutableLoopConfig::new);
    public static final class_9139<class_2540, Index<? extends LayerInfo>> LAYER_INFO_PACKET_CODEC = class_9139.method_56438((layerInfo, buf) -> {
        buf.method_53002(layerInfo.size());
        for (IndexPointer entry : layerInfo.iterateOrdered()) {
            buf.method_53002(entry.index());
            LayerInfo layer = (LayerInfo)entry.value();
            buf.method_52997((int)layer.volume());
            buf.method_52998((int)layer.panning());
            buf.method_52964(layer.locked());
        }
    }, buf -> {
        int layerCount = buf.readInt();
        record 1LayerProto(byte volume, short panning, boolean locked) implements LayerInfo
        {
        }
        HashMap<Integer, 1LayerProto> layerInfo = new HashMap<Integer, 1LayerProto>(layerCount);
        for (int i = 0; i < layerCount; ++i) {
            int key = buf.readInt();
            byte volume = buf.readByte();
            short panning = buf.readShort();
            boolean locked = buf.readBoolean();
            layerInfo.put(key, new 1LayerProto(volume, panning, locked));
        }
        return new FixedIndex(layerInfo);
    });
    public static final class_9139<class_2540, Instruments> INSTRUMENTS_PACKET_CODEC = class_9139.method_56438((instruments, buf) -> {
        CustomInstrument[] custom = instruments.custom();
        buf.method_53002(custom.length);
        for (CustomInstrument instrument : custom) {
            buf.method_10814(instrument.name());
            buf.method_10814(instrument.soundFile());
            buf.method_52997((int)instrument.key());
        }
        buf.method_53002(instruments.customBegin());
    }, buf -> {
        int customCount = buf.readInt();
        CustomInstrument[] custom = new CustomInstrument[customCount];
        for (int i = 0; i < customCount; ++i) {
            String name = buf.method_19772();
            String soundFile = buf.method_19772();
            byte key = buf.readByte();
            custom[i] = new ImmutableCustomInstrument(name, soundFile, key);
        }
        int begin = buf.readInt();
        return new ImmutableInstruments(custom, begin);
    });
    public static final class_9139<class_2540, SongSlice> SONG_SLICE_PACKET_CODEC = class_9139.method_56437(SongSlicer::writeSlice, SongSlicer::readSlice);
    public static final class_9139<class_2540, SongTempo> SONG_TEMPO = class_9139.method_56438((tempo, buf) -> {
        List<TempoChange> sections = tempo.changes();
        buf.method_53002(sections.size());
        for (TempoChange change : sections) {
            buf.method_53002(change.timeTick());
            buf.method_52941(change.ticksPerSecond());
        }
    }, buf -> {
        int count = buf.readInt();
        ArrayList<TempoChange> changes = new ArrayList<TempoChange>(count);
        for (int i = 0; i < count; ++i) {
            int timeTick = buf.readInt();
            float ticksPerSecond = buf.readFloat();
            changes.add(new TempoChange(timeTick, ticksPerSecond));
        }
        return new ImmutableSongTempo(changes);
    });
    public static final class_9139<class_2540, LoopOverride> LOOP_OVERRIDE = class_9139.method_56436((class_9139)class_9135.method_56382((class_9139)class_9135.field_48547), LoopOverride::enabled, (class_9139)class_9135.method_56382((class_9139)class_9135.field_49675), LoopOverride::loopCount, (class_9139)class_9135.method_56382((class_9139)class_9135.field_49675), LoopOverride::loopStartTick, LoopOverride::new);
    public static final class_9139<class_2540, PlaybackOptions> PLAYBACK_OPTIONS = class_9139.method_56905((class_9139)class_9135.field_48552, PlaybackOptions::volume, NoticaPacketCodecs.indexed(class_7995.method_47914(Enum::ordinal, (Object[])PlaybackVariant.values(), (class_7995.class_7996)class_7995.class_7996.field_41664), Enum::ordinal), PlaybackOptions::playbackVariant, NoticaPacketCodecs.indexed(class_7995.method_47914(Enum::ordinal, (Object[])StereoMode.values(), (class_7995.class_7996)class_7995.class_7996.field_41664), Enum::ordinal), PlaybackOptions::stereoMode, LOOP_OVERRIDE, PlaybackOptions::loopOverride, PlaybackOptions::new);

    private NoticaPacketCodecs() {
    }

    private static <T> class_9139<class_2540, T> indexed(IntFunction<T> idx2Val, ToIntFunction<T> val2Idx) {
        return class_9139.method_56438((val, buf) -> {
            int i = val2Idx.applyAsInt(val);
            class_8703.method_53017((ByteBuf)buf, (int)i);
        }, buf -> {
            int i = class_8703.method_53016((ByteBuf)buf);
            return idx2Val.apply(i);
        });
    }
}

