/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.network;

import java.util.Map;
import net.minecraft.class_2540;
import work.lclpnet.notica.api.Index;
import work.lclpnet.notica.api.NoteEvent;
import work.lclpnet.notica.api.SongSlice;
import work.lclpnet.notica.api.data.Layer;
import work.lclpnet.notica.api.data.Note;
import work.lclpnet.notica.api.data.Song;
import work.lclpnet.notica.impl.FixedIndex;
import work.lclpnet.notica.impl.MutableIndex;
import work.lclpnet.notica.impl.MutableLayer;
import work.lclpnet.notica.impl.data.ImmutableNote;
import work.lclpnet.notica.network.ConcreteSongSlice;

public class SongSlicer {
    public static SongSlice sliceSeconds(Song song, int tickOffset, int seconds) {
        int ticks = song.tempo().durationTicks(tickOffset, seconds);
        int tickEnd = Math.min(song.durationTicks(), tickOffset + ticks);
        int maxLayerIndex = song.layers().streamKeysOrdered().max().orElse(-1);
        return new ConcreteSongSlice(song, tickOffset, tickEnd, 0, maxLayerIndex);
    }

    public static SongSlice sliceAt(Song song, int tickOffset, int layerOffset, long maxBytes) {
        if (maxBytes < 18L) {
            throw new IllegalArgumentException("A SongSlice is at least 18 bytes big");
        }
        maxBytes -= 4L;
        int maxLayerIndex = song.layers().streamKeysOrdered().max().orElse(-1);
        ConcreteSongSlice remaining = new ConcreteSongSlice(song, tickOffset, song.durationTicks(), layerOffset, maxLayerIndex);
        long totalBytes = 16L;
        int lastLayer = layerOffset - 1;
        int lastTick = tickOffset - 1;
        boolean firstTick = true;
        for (NoteEvent noteEvent : remaining) {
            int tick = noteEvent.tick();
            if (tick != lastTick) {
                if (firstTick) {
                    firstTick = false;
                } else {
                    totalBytes += 2L;
                }
                totalBytes += 2L;
            }
            if ((totalBytes += 8L) > maxBytes) break;
            lastTick = tick;
            lastLayer = noteEvent.layer();
        }
        if (firstTick) {
            return new ConcreteSongSlice(new FixedIndex(Map.of()), tickOffset, tickOffset - 1, layerOffset, layerOffset - 1);
        }
        return new ConcreteSongSlice(song, tickOffset, lastTick, layerOffset, lastLayer);
    }

    public static long getByteSize(SongSlice slice) {
        int tickStart = slice.tickStart();
        long totalBytes = 16L;
        int lastTick = tickStart - 1;
        boolean firstTick = true;
        for (NoteEvent noteEvent : slice) {
            int tick = noteEvent.tick();
            if (tick != lastTick) {
                if (firstTick) {
                    firstTick = false;
                } else {
                    totalBytes += 2L;
                }
                totalBytes += 2L;
                lastTick = tick;
            }
            totalBytes += 8L;
        }
        if (!firstTick) {
            totalBytes += 2L;
        }
        return totalBytes += 2L;
    }

    public static void writeSlice(class_2540 buf, SongSlice slice) {
        int tickStart = slice.tickStart();
        int tickEnd = slice.tickEnd();
        int layerStart = slice.layerStart();
        int layerEnd = slice.layerEnd();
        buf.method_53002(tickStart);
        buf.method_53002(tickEnd);
        buf.method_53002(layerStart);
        buf.method_53002(layerEnd);
        int lastTick = tickStart - 1;
        int lastLayer = -1;
        boolean firstTick = true;
        for (NoteEvent noteEvent : slice) {
            int tick = noteEvent.tick();
            int layer = noteEvent.layer();
            if (tick != lastTick) {
                if (firstTick) {
                    firstTick = false;
                } else {
                    buf.method_52998(0);
                    lastLayer = -1;
                }
                buf.method_52998(tick - lastTick);
                lastTick = tick;
            }
            buf.method_52998(layer - lastLayer);
            lastLayer = layer;
            Note note = noteEvent.note();
            buf.method_52997((int)note.instrument());
            buf.method_52997((int)note.key());
            buf.method_52997((int)note.velocity());
            buf.method_52997((int)note.panning());
            buf.method_52998((int)note.pitch());
        }
        if (!firstTick) {
            buf.method_52998(0);
        }
        buf.method_52998(0);
    }

    public static SongSlice readSlice(class_2540 buf) {
        short jump;
        int tickStart = buf.readInt();
        int tickEnd = buf.readInt();
        int layerStart = buf.readInt();
        int layerEnd = buf.readInt();
        MutableIndex<MutableLayer> layers = new MutableIndex<MutableLayer>();
        int tick = -1;
        while ((jump = buf.readShort()) != 0) {
            tick += jump;
            int layer = -1;
            while ((jump = buf.readShort()) != 0) {
                layer += jump;
                byte instrument = buf.readByte();
                byte key = buf.readByte();
                byte velocity = buf.readByte();
                short panning = buf.readUnsignedByte();
                short pitch = buf.readShort();
                MutableLayer notes = layers.computeIfAbsent(layer, l -> new MutableLayer());
                ImmutableNote note = new ImmutableNote(instrument, key, velocity, panning, pitch);
                notes.accept(tick + tickStart, note);
            }
        }
        return new ConcreteSongSlice(layers, tickStart, tickEnd, layerStart, layerEnd);
    }

    public static boolean isFinished(Song song, SongSlice slice) {
        return SongSlicer.isFinished(song, slice.tickEnd(), slice.layerEnd());
    }

    public static boolean isFinished(Song song, int tickOffset, int layerOffset) {
        int lastTick = song.lastNoteTick().orElse(-1);
        if (tickOffset > lastTick) {
            return true;
        }
        if (tickOffset < lastTick) {
            return false;
        }
        Index<? extends Layer> layers = song.layers();
        int lastLayer = layers.streamKeysOrdered().filter(i -> {
            Layer layer = (Layer)layers.get(i);
            if (layer == null) {
                return false;
            }
            return layer.notes().get(lastTick) != null;
        }).max().orElse(-1);
        return layerOffset >= lastLayer;
    }
}

