/*
 * Decompiled with CFR 0.152.
 */
package work.lclpnet.notica.util;

import java.io.InputStream;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;
    private int markedPos = -1;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(byte @NotNull [] bytes, int off, int len) {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buf.remaining());
        this.buf.get(bytes, off, len);
        return len;
    }

    @Override
    public void mark(int readlimit) {
        this.markedPos = this.buf.position();
    }

    @Override
    public void reset() {
        this.buf.position(this.markedPos);
    }
}

